/**
 * Copyright matsu4512 ( http://wonderfl.net/user/matsu4512 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3UWH
 */

//クリックしてね
// forked from Saqoosha's Fire
package {
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.ColorMatrixFilter;
	import flash.filters.ConvolutionFilter;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import net.hires.debug.Stats;
	
	[SWF(width=465, height=465, backgroundColor=0x0, frameRate=60)]

	public class PerlinNoise extends Sprite {
		
		private static const ZERO_POINT:Point = new Point();
		
		private var _fireColor:BitmapData;
		private var _currentFireColor:int;
		
		private var _canvas:BitmapData;
		private var _grey:BitmapData;
		private var _spread:ConvolutionFilter;
		private var _cooling:BitmapData;
		private var _color:ColorMatrixFilter;
		private var _offset:Array;
		private var _fire:BitmapData;
		private var _palette:Array;
		private var _zeroArray:Array;
		private var charBmpData:BitmapData;
		private var tx:TextField;
		private var particles:Array = [];
		private var f:Boolean = false;
		
		public function PerlinNoise() {
			this.stage.scaleMode = StageScaleMode.NO_SCALE;
			this.stage.quality = StageQuality.LOW;
			
			
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, this._onLoaded);
			loader.load(new URLRequest('http://saqoosha.net/lab/Moyasu/srcview/source/fire-color.png'), new LoaderContext(true));
		}
		
		private function _onLoaded(e:Event):void {
			this._fireColor = Bitmap(LoaderInfo(e.target).loader.content).bitmapData;
			
			this._canvas = new BitmapData(465, 465, true, 0);
			tx = new TextField();
			tx.selectable = false;
			tx.autoSize = TextFieldAutoSize.LEFT;
			tx.defaultTextFormat = new TextFormat("Verdana", 80, 0xffffff, true);
			tx.text = "Wonderfl";
			tx.x = (465 - tx.width) / 2;
			tx.y = (465 - tx.height) / 2;
			_canvas.draw(tx, new Matrix(1,0,0,1,tx.x,tx.y));
			
			this._grey = new BitmapData(465, 465, false, 0x0);
			this._spread = new ConvolutionFilter(3, 3, [0, 1, 0,  1, 1, 1,  0, 1, 0], 5);
			this._cooling = new BitmapData(465, 465, false, 0x0);
			this._offset = [new Point(), new Point()];
			this._fire = new BitmapData(465, 465, false, 0x0);
			this.addChild(new Bitmap(this._fire));
			
			this._createCooling(0.16);
			this._createPalette(this._currentFireColor = 0);
			
			this.addEventListener(Event.ENTER_FRAME, this._update);
			this.stage.addEventListener(MouseEvent.CLICK, this._onClick);
			
			var status:Stats = new Stats();
            addChild(status);
		}
		
		private function _onClick(e:MouseEvent):void {
			if(f){
				_canvas.draw(tx, new Matrix(1,0,0,1,tx.x,tx.y));
				f = false;
				return;
			}
			f = true;
			for(var i:int = 0; i < _canvas.height; i++){
				for(var j:int = 0; j < _canvas.width; j++){
					if(_canvas.getPixel(j,i) == 0xffffff){						
					 	_canvas.setPixel(j,i,0);
					 	var p:Particle = new Particle();
					 	p.x = j;
					 	p.y = i;
					 	p.vx = Math.random()*20-10;
					 	p.vy = Math.random()*20-10;

					 	particles.push(p);
					}
				}
			}
		}
		
		private function _createCooling(a:Number):void {
			this._color = new ColorMatrixFilter([
				a, 0, 0, 0, 0,
				0, a, 0, 0, 0,
				0, 0, a, 0, 0,
				0, 0, 0, 1, 0
			]);
		}
		
		private function _createPalette(idx:int):void {
			this._palette = [];
			this._zeroArray = [];
			for (var i:int = 0; i < 256; i++) {
				this._palette.push(this._fireColor.getPixel(i, idx * 32));
				this._zeroArray.push(0);
			}
		}
		
		private var framei:int = 0;
		
		private function _update(e:Event):void {
			this._grey.draw(this._canvas);
			this._grey.applyFilter(this._grey, this._grey.rect, ZERO_POINT, this._spread);
			var i:int = particles.length;
			var p:Particle;
			while(i--){
				p = particles[i];
				_grey.setPixel(p.x, p.y, 0xffffff);
				p.x += p.vx;
				p.y += p.vy;
				if(p.x < 0 || p.x > stage.stageWidth || p.y < 0 || p.y > stage.stageHeight)
					particles.splice(i, 1);
			}
			if(framei % 4 == 0){
				this._cooling.perlinNoise(50, 50, 1, 982374, false, false, 0, true, this._offset);
				this._offset[0].x += 2.0;
				this._offset[1].y += 2.0;
				this._cooling.applyFilter(this._cooling, this._cooling.rect, ZERO_POINT, this._color);
				this._grey.draw(this._cooling, null, null, BlendMode.SUBTRACT);
				this._grey.scroll(0, -5);
				this._fire.paletteMap(this._grey, this._grey.rect, ZERO_POINT, this._palette, this._zeroArray, this._zeroArray, this._zeroArray);
			}
			framei++;
		}
	}
}

class Particle{
	public var x:Number, y:Number, vx:Number, vy:Number;
}
