/**
 * Copyright AtuyL ( http://wonderfl.net/user/AtuyL )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3TF0
 */

// forked from Event's CBC NET
/*
マウスの左右移動で全体の回転速度を調節できるよ（´・ω・）
回転周期が最も遅いリング（item要素）が選択状態になるよ（´・ω・）
そのままクリックすると飛ぶよ（´・ω・）

※回転速度が遅すぎて別にストロボ効果使ってなかった件（´・ω・）
*/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.net.navigateToURL;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    [SWF(backgroundColor=0x000000)]
    public class Main extends Sprite{
        private const RSS:String = "http://assets.wonderfl.net/static/assets/session5/cbcnet_feed.xml";
        
        private var feed:Feed;
        public function Main():void{
            this.stage.scaleMode = StageScaleMode.NO_SCALE;
            this.stage.align = StageAlign.TOP_LEFT;
            this.stage.quality = StageQuality.BEST;
            BitmapTextField.stage = this.stage;
            
            var loader:URLLoader = new URLLoader();
            loader.dataFormat = URLLoaderDataFormat.TEXT;
            var self:Object = this;
            loader.addEventListener(Event.COMPLETE,function(event:Event):void{
                event.currentTarget.removeEventListener(event.type,arguments.callee);
                self.initialize(loader.data);
            });
            var request:URLRequest = new URLRequest(RSS);
            loader.load(request);
        }
        
        private function initialize(data:*):void{
            this.feed = (
                data is String ? new Feed(new XML(data)) :
                data is XML ? new Feed(data) : 
                data is Feed ? data as Feed : null
            );
            this.disc = new Disc;
            this.currentIndex = -1;
            this.loadNextItem();
        }
        
        private var disc:Disc;
        private var scene3d:Scene3D;
        private var viewport3d:Viewport3D;
        private var renderer:BasicRenderEngine;
        private var camera3d:Camera3D;
        private var disc3d:Disc3D;
        private var texture:BitmapData;
        public function init3D():void{
            this.camera3d = new Camera3D;
            this.scene3d = new Scene3D;
            this.viewport3d = new Viewport3D(512,512,true);
            this.addChild(this.viewport3d);
            
            this.disc3d = new Disc3D();
            this.disc3d.scale = 2;
            this.texture = new BitmapData(2048,2048,false,0x0);
            this.disc3d.material = new BitmapMaterial(this.texture,false);
            this.scene3d.addChild(this.disc3d);
            
            this.camera3d.target = DisplayObject3D.ZERO;
            this.camera3d.z = -250;
            this.camera3d.y = 250;
            this.camera3d.fov = 45;
            
            this.renderer = new BasicRenderEngine;
        }
        private function enter_frame(event:Event):void{
            this.disc.speed = (this.stage.mouseX / this.stage.stageWidth - 0.5) * 2.0;
            this.disc.update();
            var m:Matrix = new Matrix;
            m.scale(1,2048/this.disc.height);
            this.texture.draw(this.disc,m);
            this.renderer.renderScene(this.scene3d,this.camera3d,this.viewport3d);
            
            if(this.disc.currentTrack){
                if(this.currentBitmap) this.removeChild(this.currentBitmap);
                this.currentBitmap = new Bitmap(this.disc.currentTrack.originalBitmapData.clone());
                this.currentBitmap.x = (this.stage.stageWidth - this.currentBitmap.width) >> 1;
                this.currentBitmap.y = this.stage.stageHeight * 0.2;
                this.addChild(this.currentBitmap);
                this.url = this.disc.currentTrack.item.link;
                this.buttonMode = true;
            }else{
                this.removeChild(this.currentBitmap);
                this.currentBitmap = null;
                this.url = null;
                this.buttonMode = false;
            }
        }
        
        private var currentIndex:int;
        private var currentTrack:Track;
        private var currentBitmap:Bitmap;
        private function loadNextItem(event:Event = null):void{
            if(event) event.currentTarget.removeEventListener(event.type,arguments.callee);
            this.currentIndex++;
            if(this.currentIndex >= this.feed.items.length){
                this.start();
            }else{
                var item:Item = this.feed.items[this.currentIndex];
                this.currentTrack = new Track(item);
                this.currentTrack.addEventListener(Event.COMPLETE,this.appendTrack);
                this.currentTrack.addEventListener(Event.COMPLETE,this.loadNextItem);
            }
        }
        
        private function appendTrack(event:Event = null):void{
            if(event) event.currentTarget.removeEventListener(event.type,arguments.callee);
            this.disc.addTrack(this.currentTrack);
        }
        
        private function start():void{
            this.currentTrack = null;
            this.init3D();
            this.stage.addEventListener(Event.ENTER_FRAME,this.enter_frame);
            this.stage.addEventListener(Event.RESIZE,this.resize);
            this.stage.addEventListener(MouseEvent.CLICK,this.click);
            this.resize();
        }
        
        private var url:String;
        private function click(event:Event):void{
            if(this.buttonMode){
                navigateToURL(new URLRequest(this.url),"_blank");
            }
        }
        
        private function resize(event:Event = null):void{
            this.disc.resizeTo(this.stage.stageWidth,this.stage.stageHeight);
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.display.Loader;
import flash.display.PixelSnapping;
import flash.display.Sprite;
import flash.display.Stage;
import flash.events.Event;
import flash.filters.BlurFilter;
import flash.geom.Matrix;
import flash.net.URLRequest;
import flash.system.LoaderContext;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import org.papervision3d.core.geom.*;
import org.papervision3d.core.geom.renderables.Triangle3D;
import org.papervision3d.core.geom.renderables.Vertex3D;
import org.papervision3d.core.math.NumberUV;
import org.papervision3d.core.proto.*;


internal class Disc extends Sprite{
    private var _mask:Sprite;
    public function Disc(){
        super();
        this.mouseChildren = false;
        this.mouseEnabled = false;
        this.trackList = [];
        
        this.opaqueBackground = 0x0;
    }
    private var trackList:Array;
    private var length:int;
    public function addTrack(track:Track):void{
        var height:Number = this.height;
        track.y = height + this.length * 2;
        this.addChild(track);
        this.length = this.trackList.push(track);
    }
    
    private var _speed:Number;
    public function set speed(value:Number):void{
        this._speed = value;
    }
    
    private var loopThreshold:Number;
    public var currentTrack:Track;
    
    public function update():void{
        var minMove:Number = Infinity;
        this.currentTrack = null;
        var index:int;
        var offset:Number = 100 / this.trackList.length;
        for each(var track:Track in this.trackList){
            track.enabled = false;
            
            var speedOffset:Number = index++ * offset;
            var offsetX:Number = speedOffset + 100 * this._speed;
            
            var x:Number = track.x + offsetX;
            var moveValue:Number = Math.sin(offsetX / this.loopThreshold * Math.PI);
            moveValue = moveValue < 0 ? -moveValue : moveValue;
            if(minMove > moveValue){
                currentTrack = track;
                minMove = minMove > moveValue ? moveValue : minMove;
            }
            
            if(x > this.loopThreshold){
                x -= (x / this.loopThreshold >> 0) * this.loopThreshold;
            }else if(x < -this.loopThreshold){
                x += (x / -this.loopThreshold >> 0) * this.loopThreshold;
            }
            track.x = x;
        }
        if(currentTrack){
            currentTrack.enabled = true;
        }
    }
    
    public function resizeTo(width:Number,height:Number):void{
        var width:Number = 2048;
        this.loopThreshold = width;
        for each(var track:Track in this.trackList){
            track.resizeTo(width,height);
        }
        this.update();
    }
}

internal class Track extends Sprite{
    public var item:Item;
    private var original:Sprite;
    public function Track(item:Item){
        this.mouseChildren = false;
        this.mouseEnabled = false;
        
        this.original = new Sprite;
        
        this.item = item;
        this.appendTitle();
        this.appendDate();
        this.appendDescription();
        
        if(this.item.image){
            this.appendImage();
        }else{
            this.attachClones();
        }
    }
    
    public function set enabled(value:Boolean):void{
        if(value){
            this.opaqueBackground = 0xFF9900;
        }else{
            this.opaqueBackground = 0x0;
        }
    }
    
    private var title:DisplayObject;
    public function appendTitle():void{
        var height:Number = this.original.height;
        this.title = this.original.addChild(new BitmapTextField(this.item.title));
        this.title.y = height;
    }
    
    private var date:DisplayObject;
    public function appendDate():void{
        var height:Number = this.original.height;
        this.date = this.original.addChild(new BitmapTextField(this.item.pubDate.toLocaleDateString()));
        this.date.y = height;
    }
    
    private var description:DisplayObject;
    public function appendDescription():void{
        var height:Number = this.original.height;
        this.description = this.original.addChild(new BitmapTextField(this.item.description));
        this.description.y = height;
    }
    
    private var loader:Loader;
    public function appendImage():void{
        var request:URLRequest = new URLRequest(this.item.image);
        loader = new Loader();
        loader.cacheAsBitmap = true;
        
        loader.load(request,new LoaderContext(true));
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE,function(event:Event):void{
            event.currentTarget.removeEventListener(event.type,arguments.callee);
            attachClones();
        });
    }
    
    private var center:ItemBitmap;
    private var left:ItemBitmap;
    private var right:ItemBitmap;
    public var originalBitmapData:BitmapData;
    
    private function attachClones():void{
        if(this.loader){
            var h:Number = this.original.height;
            var scale:Number = h / this.loader.height;
            this.loader.scaleX = scale;
            this.loader.scaleY = scale;
            this.original.addChild(this.loader);
            
            var paddingX:Number = this.loader.width;
            this.title.x = paddingX;
            this.date.x = paddingX;
            this.description.x = paddingX;
        }
        
        var width:Number = this.original.width;
        var height:Number = this.original.height;
        this.originalBitmapData = new BitmapData(width,height,true,0x0);
        this.originalBitmapData.draw(this.original);
        
        this.center = new ItemBitmap(this.originalBitmapData);
        this.left = new ItemBitmap(this.originalBitmapData);
        this.right = new ItemBitmap(this.originalBitmapData);
        
        this.addChild(this.center);
        this.addChild(this.left);
        this.addChild(this.right);
        
        this.dispatchEvent(new Event(Event.COMPLETE));
    }
    
    public function resizeTo(width:Number,height:Number):void{
        this.left.x = -width;
        this.center.x = 0;
        this.right.x = width;
    }
}

internal class ItemBitmap extends Bitmap{
    public function ItemBitmap(bitmapData:BitmapData){
        super(bitmapData);
    }
}

internal class Feed{
    public var channel:Channel;
    public var items:Vector.<Item>;
    
    public function Feed(xml:XML){
        var channelList:XMLList = xml.channel;
        try{
            var channel:XML = xml.channel[0];
            this.channel = new Channel(channel);
            
            var itemList:XMLList = channel.item;
            this.items = new Vector.<Item>;
            for each(var item:XML in itemList){
                this.items.push(new Item(item));
            }
        }catch(e:Error){
            trace(e);
        }
    }
}

internal class Channel{
    public var title:String;
    public var link:String;
    public var language:String;
    public var description:String;
    public var copyright:String;
    public var lastBuildDate:Date;
    public function Channel(xml:XML){
        var children:XMLList = xml.children();
        for each(var child:XML in children){
            var name:String = child.name();
            var has:Boolean = this.hasOwnProperty(name);
            if(!has) continue;
            // hasProperties ----------------
            if(name === "lastBuildDate"){
                this.lastBuildDate = new Date(
                    Date.parse(
                        child.toString().replace(/^Web/,"Wed")
                    )
                );
            }else{
                this[name] = child.toString();
            }
        }
    }
}
internal class ItemList{
    private var keys:Array = [];
    private var data:Array = [];
    private var key:String;
    public function ItemList(key:String){
        this.key = key;
    }
    public function addItem(item:Item):void{
        var keyData:Object = item[this.key];
        for each(var name:String in keyData){
            var keyIndex:int = this.keys.indexOf(name);
            if(keyIndex < 0){
                keyIndex = this.keys.length;
                this.keys.push(name);
                this.data.push([item]);
            }else{
                this.data[keyIndex].push(item);
            }
        }
    }
    public function getItems(keyData:String):Array{
        var keyIndex:int = this.keys.indexOf(keyData);
        return keyIndex < 0 ? null : this.data[keyIndex];
    }
    public function getKeys():Array{
        return this.keys.concat();
    }
}
// singleton
internal const categories:ItemList = new ItemList("category");
internal const tags:ItemList = new ItemList("tag");

internal class Item{
    public var title:String;
    public var link:String;
    public var guid:String;
    public var pubDate:Date;
    public var category:Array;
    public var tag:Array;
    public var description:String;
    public var image:String;
    
    public function Item(xml:XML){
        var children:XMLList = xml.children();
        for each(var child:XML in children){
            var name:String = child.name();
            var has:Boolean = this.hasOwnProperty(name);
            if(!has) continue;
            // hasProperties ----------------
            if(name === "pubDate"){
                this.pubDate = new Date(
                    Date.parse(
                        child.toString().replace(/^Web/,"Wed")
                    )
                );
            }else if(name === "category"){
                this.category = child.toString().toUpperCase().replace(/\s/g,"").split(",");
                categories.addItem(this);
            }else if(name === "tag"){
                this.tag = child.toString().toUpperCase().replace(/\s/g,"").split(",");
                tags.addItem(this);
            }else{
                this[name] = child.toString();
            }
        }
    }
}

internal class BitmapTextField extends Bitmap{
    public static var stage:Stage;
    private var field:TextField;
    public function BitmapTextField(text:String = null,width:int = 2048){
        super(null,PixelSnapping.NEVER,true);
        this.field = new TextField;
        this.field.width = width;
        this.field.wordWrap = true;
        this.field.autoSize = TextFieldAutoSize.LEFT;
        this.field.embedFonts = false;
        if(text) this.text = text;
    }
    public function set text(value:String):void{
        this.field.text = value;
        var format:TextFormat = new TextFormat;
        format.size = 24;
        format.font = "_ゴシック";
        format.color = 0xFFFFFF;
        this.field.setTextFormat(format);
        
        var quality:String = BitmapTextField.stage.quality;
        BitmapTextField.stage.quality = flash.display.StageQuality.BEST;
        
        var buffer:Bitmap = new Bitmap(new BitmapData(field.width,field.height,true,0x0));
        buffer.bitmapData.draw(field);
        buffer.smoothing = true;
        var m:Matrix = new Matrix;
        m.scale(0.5,0.5);
        
        var bitmapData:BitmapData = new BitmapData(buffer.width * 0.5,buffer.height * 0.5,true,0x0);
        bitmapData.draw(buffer,m,null,null,null,true);
        this.bitmapData = bitmapData;
        
        BitmapTextField.stage.quality = quality;
    }
}


internal class Disc3D extends TriangleMesh3D{
    public var verts :Array;
    public var faceAr:Array;
    public var uvs :Array;
    private function v(x:Number,y:Number,z:Number):void{verts.push(new Vertex3D(x,y,z));}
    private function uv(u:Number,v:Number):void{uvs.push(new NumberUV(u,v));}
    private function f(vn0:int, vn1:int, vn2:int, uvn0:int, uvn1:int,uvn2:int):void{faceAr.push( new Triangle3D( this, [verts[vn0],verts[vn1],verts[vn2] ], null, [uvs[uvn0],uvs[uvn1],uvs[uvn2]] ) );}
    public function Disc3D( material:MaterialObject3D=null )
    {
        super( material, new Array(), new Array(), null );
        verts = this.geometry.vertices;
        faceAr= this.geometry.faces;
        uvs   =new Array();
        v(200.0,0.0,-6.7481e-006);
        v(196.157,0.0,39.0181);
        v(184.776,0.0,76.5367);
        v(166.294,0.0,111.114);
        v(141.421,0.0,141.421);
        v(111.114,0.0,166.294);
        v(76.5367,0.0,184.776);
        v(39.018,0.0,196.157);
        v(1.19167e-005,0.0,200.0);
        v(-39.0181,0.0,196.157);
        v(-76.5367,0.0,184.776);
        v(-111.114,0.0,166.294);
        v(-141.421,0.0,141.421);
        v(-166.294,0.0,111.114);
        v(-184.776,0.0,76.5366);
        v(-196.157,0.0,39.018);
        v(-200.0,0.0,-6.77833e-005);
        v(-196.157,0.0,-39.0182);
        v(-184.776,0.0,-76.5368);
        v(-166.294,0.0,-111.114);
        v(-141.421,0.0,-141.421);
        v(-111.114,0.0,-166.294);
        v(-76.5366,0.0,-184.776);
        v(-39.0179,0.0,-196.157);
        v(0.000164505,0.0,-200.0);
        v(39.0183,0.0,-196.157);
        v(76.5369,0.0,-184.776);
        v(111.114,0.0,-166.294);
        v(141.421,0.0,-141.421);
        v(166.294,0.0,-111.114);
        v(184.776,0.0,-76.5364);
        v(196.157,0.0,-39.0178);
        v(187.5,0.0,-6.7481e-006);
        v(183.897,0.0,36.5794);
        v(173.227,0.0,71.7531);
        v(155.901,0.0,104.169);
        v(132.583,0.0,132.583);
        v(104.169,0.0,155.901);
        v(71.7531,0.0,173.227);
        v(36.5794,0.0,183.897);
        v(1.19167e-005,0.0,187.5);
        v(-36.5794,0.0,183.897);
        v(-71.7531,0.0,173.227);
        v(-104.169,0.0,155.901);
        v(-132.583,0.0,132.583);
        v(-155.901,0.0,104.169);
        v(-173.227,0.0,71.7531);
        v(-183.897,0.0,36.5794);
        v(-187.5,0.0,-6.77833e-005);
        v(-183.897,0.0,-36.5795);
        v(-173.227,0.0,-71.7532);
        v(-155.9,0.0,-104.17);
        v(-132.582,0.0,-132.583);
        v(-104.169,0.0,-155.901);
        v(-71.753,0.0,-173.227);
        v(-36.5793,0.0,-183.897);
        v(0.000164505,0.0,-187.5);
        v(36.5796,0.0,-183.897);
        v(71.7533,0.0,-173.227);
        v(104.17,0.0,-155.9);
        v(132.583,0.0,-132.582);
        v(155.901,0.0,-104.169);
        v(173.227,0.0,-71.7529);
        v(183.897,0.0,-36.5792);
        v(175.0,0.0,-6.7481e-006);
        v(171.637,0.0,34.1408);
        v(161.679,0.0,66.9696);
        v(145.507,0.0,97.2248);
        v(123.744,0.0,123.744);
        v(97.2248,0.0,145.507);
        v(66.9696,0.0,161.679);
        v(34.1408,0.0,171.637);
        v(1.19167e-005,0.0,175.0);
        v(-34.1408,0.0,171.637);
        v(-66.9696,0.0,161.679);
        v(-97.2248,0.0,145.507);
        v(-123.744,0.0,123.744);
        v(-145.507,0.0,97.2248);
        v(-161.679,0.0,66.9696);
        v(-171.637,0.0,34.1407);
        v(-175.0,0.0,-6.77833e-005);
        v(-171.637,0.0,-34.1409);
        v(-161.679,0.0,-66.9697);
        v(-145.507,0.0,-97.2249);
        v(-123.744,0.0,-123.744);
        v(-97.2247,0.0,-145.507);
        v(-66.9695,0.0,-161.679);
        v(-34.1407,0.0,-171.637);
        v(0.000149246,0.0,-175.0);
        v(34.141,0.0,-171.637);
        v(66.9698,0.0,-161.679);
        v(97.2249,0.0,-145.507);
        v(123.744,0.0,-123.744);
        v(145.507,0.0,-97.2246);
        v(161.679,0.0,-66.9694);
        v(171.637,0.0,-34.1405);
        v(162.5,0.0,-6.7481e-006);
        v(159.378,0.0,31.7022);
        v(150.13,0.0,62.186);
        v(135.114,0.0,90.2801);
        v(114.905,0.0,114.905);
        v(90.2801,0.0,135.114);
        v(62.186,0.0,150.13);
        v(31.7021,0.0,159.378);
        v(1.19167e-005,0.0,162.5);
        v(-31.7022,0.0,159.378);
        v(-62.186,0.0,150.13);
        v(-90.2802,0.0,135.114);
        v(-114.905,0.0,114.905);
        v(-135.114,0.0,90.2802);
        v(-150.13,0.0,62.186);
        v(-159.378,0.0,31.7021);
        v(-162.5,0.0,-5.25245e-005);
        v(-159.378,0.0,-31.7023);
        v(-150.13,0.0,-62.1861);
        v(-135.114,0.0,-90.2803);
        v(-114.905,0.0,-114.905);
        v(-90.2801,0.0,-135.114);
        v(-62.186,0.0,-150.13);
        v(-31.7021,0.0,-159.378);
        v(0.000164505,0.0,-162.5);
        v(31.7024,0.0,-159.378);
        v(62.1862,0.0,-150.13);
        v(90.2803,0.0,-135.114);
        v(114.905,0.0,-114.905);
        v(135.114,0.0,-90.28);
        v(150.131,0.0,-62.1858);
        v(159.378,0.0,-31.7019);
        v(150.0,0.0,-6.7481e-006);
        v(147.118,0.0,29.2635);
        v(138.582,0.0,57.4025);
        v(124.72,0.0,83.3355);
        v(106.066,0.0,106.066);
        v(83.3355,0.0,124.72);
        v(57.4025,0.0,138.582);
        v(29.2635,0.0,147.118);
        v(-1.86009e-005,0.0,150.0);
        v(-29.2636,0.0,147.118);
        v(-57.4025,0.0,138.582);
        v(-83.3355,0.0,124.72);
        v(-106.066,0.0,106.066);
        v(-124.72,0.0,83.3355);
        v(-138.582,0.0,57.4025);
        v(-147.118,0.0,29.2635);
        v(-150.0,0.0,-5.25245e-005);
        v(-147.118,0.0,-29.2636);
        v(-138.582,0.0,-57.4026);
        v(-124.72,0.0,-83.3356);
        v(-106.066,0.0,-106.066);
        v(-83.3355,0.0,-124.721);
        v(-57.4024,0.0,-138.582);
        v(-29.2634,0.0,-147.118);
        v(0.000118728,0.0,-150.0);
        v(29.2637,0.0,-147.118);
        v(57.4026,0.0,-138.582);
        v(83.3357,0.0,-124.72);
        v(106.066,0.0,-106.066);
        v(124.721,0.0,-83.3354);
        v(138.582,0.0,-57.4023);
        v(147.118,0.0,-29.2633);
        v(137.5,0.0,-6.7481e-006);
        v(134.858,0.0,26.8249);
        v(127.033,0.0,52.619);
        v(114.327,0.0,76.3909);
        v(97.2272,0.0,97.2272);
        v(76.3909,0.0,114.327);
        v(52.619,0.0,127.033);
        v(26.8249,0.0,134.858);
        v(-1.86009e-005,0.0,137.5);
        v(-26.8249,0.0,134.858);
        v(-52.619,0.0,127.033);
        v(-76.3909,0.0,114.327);
        v(-97.2272,0.0,97.2272);
        v(-114.327,0.0,76.3909);
        v(-127.033,0.0,52.6189);
        v(-134.858,0.0,26.8249);
        v(-137.5,0.0,-3.72657e-005);
        v(-134.858,0.0,-26.825);
        v(-127.033,0.0,-52.619);
        v(-114.327,0.0,-76.391);
        v(-97.2271,0.0,-97.2272);
        v(-76.3908,0.0,-114.327);
        v(-52.6189,0.0,-127.033);
        v(-26.8248,0.0,-134.858);
        v(0.000118728,0.0,-137.5);
        v(26.825,0.0,-134.858);
        v(52.6191,0.0,-127.033);
        v(76.391,0.0,-114.327);
        v(97.2273,0.0,-97.2271);
        v(114.327,0.0,-76.3908);
        v(127.033,0.0,-52.6188);
        v(134.858,0.0,-26.8247);
        v(125.0,0.0,-6.7481e-006);
        v(122.598,0.0,24.3863);
        v(115.485,0.0,47.8354);
        v(103.934,0.0,69.4463);
        v(88.3883,0.0,88.3883);
        v(69.4463,0.0,103.934);
        v(47.8354,0.0,115.485);
        v(24.3863,0.0,122.598);
        v(-1.86009e-005,0.0,125.0);
        v(-24.3863,0.0,122.598);
        v(-47.8354,0.0,115.485);
        v(-69.4463,0.0,103.934);
        v(-88.3884,0.0,88.3883);
        v(-103.934,0.0,69.4463);
        v(-115.485,0.0,47.8354);
        v(-122.598,0.0,24.3863);
        v(-125.0,0.0,-3.72657e-005);
        v(-122.598,0.0,-24.3864);
        v(-115.485,0.0,-47.8355);
        v(-103.934,0.0,-69.4463);
        v(-88.3883,0.0,-88.3884);
        v(-69.4462,0.0,-103.934);
        v(-47.8354,0.0,-115.485);
        v(-24.3862,0.0,-122.598);
        v(0.000103469,0.0,-125.0);
        v(24.3864,0.0,-122.598);
        v(47.8355,0.0,-115.485);
        v(69.4464,0.0,-103.934);
        v(88.3884,0.0,-88.3882);
        v(103.934,0.0,-69.4461);
        v(115.485,0.0,-47.8353);
        v(122.598,0.0,-24.3861);
        v(112.5,0.0,-6.7481e-006);
        v(110.338,0.0,21.9477);
        v(103.936,0.0,43.0519);
        v(93.5403,0.0,62.5016);
        v(79.5495,0.0,79.5495);
        v(62.5016,0.0,93.5403);
        v(43.0519,0.0,103.936);
        v(21.9476,0.0,110.338);
        v(-1.86009e-005,0.0,112.5);
        v(-21.9477,0.0,110.338);
        v(-43.0519,0.0,103.936);
        v(-62.5017,0.0,93.5403);
        v(-79.5495,0.0,79.5495);
        v(-93.5404,0.0,62.5016);
        v(-103.936,0.0,43.0519);
        v(-110.338,0.0,21.9476);
        v(-112.5,0.0,-3.72657e-005);
        v(-110.338,0.0,-21.9477);
        v(-103.936,0.0,-43.0519);
        v(-93.5403,0.0,-62.5017);
        v(-79.5495,0.0,-79.5496);
        v(-62.5016,0.0,-93.5404);
        v(-43.0518,0.0,-103.936);
        v(-21.9476,0.0,-110.338);
        v(0.000103469,0.0,-112.5);
        v(21.9478,0.0,-110.338);
        v(43.052,0.0,-103.936);
        v(62.5018,0.0,-93.5403);
        v(79.5496,0.0,-79.5494);
        v(93.5404,0.0,-62.5015);
        v(103.936,0.0,-43.0517);
        v(110.338,0.0,-21.9475);
        v(100.0,0.0,-6.7481e-006);
        v(98.0785,0.0,19.509);
        v(92.3879,0.0,38.2683);
        v(83.1469,0.0,55.557);
        v(70.7107,0.0,70.7107);
        v(55.557,0.0,83.1469);
        v(38.2683,0.0,92.388);
        v(19.509,0.0,98.0785);
        v(-1.86009e-005,0.0,100.0);
        v(-19.509,0.0,98.0785);
        v(-38.2683,0.0,92.388);
        v(-55.557,0.0,83.1469);
        v(-70.7107,0.0,70.7107);
        v(-83.147,0.0,55.557);
        v(-92.388,0.0,38.2683);
        v(-98.0785,0.0,19.509);
        v(-100.0,0.0,-3.72657e-005);
        v(-98.0785,0.0,-19.5091);
        v(-92.388,0.0,-38.2684);
        v(-83.1469,0.0,-55.5571);
        v(-70.7107,0.0,-70.7107);
        v(-55.557,0.0,-83.147);
        v(-38.2683,0.0,-92.388);
        v(-19.509,0.0,-98.0785);
        v(7.29518e-005,0.0,-100.0);
        v(19.5091,0.0,-98.0785);
        v(38.2684,0.0,-92.3879);
        v(55.5571,0.0,-83.1469);
        v(70.7107,0.0,-70.7106);
        v(83.147,0.0,-55.5569);
        v(92.388,0.0,-38.2682);
        v(98.0785,0.0,-19.5089);
        v(87.5,0.0,-6.7481e-006);
        v(85.8187,0.0,17.0704);
        v(80.8395,0.0,33.4848);
        v(72.7536,0.0,48.6124);
        v(61.8718,0.0,61.8718);
        v(48.6124,0.0,72.7536);
        v(33.4848,0.0,80.8395);
        v(17.0704,0.0,85.8187);
        v(-1.86009e-005,0.0,87.5);
        v(-17.0704,0.0,85.8187);
        v(-33.4848,0.0,80.8395);
        v(-48.6124,0.0,72.7536);
        v(-61.8719,0.0,61.8718);
        v(-72.7536,0.0,48.6124);
        v(-80.8395,0.0,33.4848);
        v(-85.8187,0.0,17.0704);
        v(-87.5,0.0,-2.20069e-005);
        v(-85.8187,0.0,-17.0704);
        v(-80.8395,0.0,-33.4848);
        v(-72.7536,0.0,-48.6124);
        v(-61.8718,0.0,-61.8719);
        v(-48.6124,0.0,-72.7536);
        v(-33.4847,0.0,-80.8395);
        v(-17.0703,0.0,-85.8187);
        v(7.29518e-005,0.0,-87.5);
        v(17.0705,0.0,-85.8187);
        v(33.4849,0.0,-80.8394);
        v(48.6125,0.0,-72.7535);
        v(61.8719,0.0,-61.8718);
        v(72.7536,0.0,-48.6123);
        v(80.8395,0.0,-33.4847);
        v(85.8187,0.0,-17.0703);
        v(75.0,0.0,-6.7481e-006);
        v(73.5589,0.0,14.6318);
        v(69.291,0.0,28.7013);
        v(62.3602,0.0,41.6678);
        v(53.033,0.0,53.033);
        v(41.6678,0.0,62.3602);
        v(28.7012,0.0,69.291);
        v(14.6318,0.0,73.5589);
        v(-1.86009e-005,0.0,75.0);
        v(-14.6318,0.0,73.5589);
        v(-28.7013,0.0,69.291);
        v(-41.6678,0.0,62.3602);
        v(-53.033,0.0,53.033);
        v(-62.3602,0.0,41.6678);
        v(-69.291,0.0,28.7013);
        v(-73.5589,0.0,14.6317);
        v(-75.0,0.0,-2.20069e-005);
        v(-73.5589,0.0,-14.6318);
        v(-69.291,0.0,-28.7013);
        v(-62.3602,0.0,-41.6678);
        v(-53.033,0.0,-53.033);
        v(-41.6677,0.0,-62.3603);
        v(-28.7012,0.0,-69.291);
        v(-14.6317,0.0,-73.5589);
        v(5.7693e-005,0.0,-75.0);
        v(14.6318,0.0,-73.5589);
        v(28.7013,0.0,-69.2909);
        v(41.6678,0.0,-62.3602);
        v(53.033,0.0,-53.033);
        v(62.3603,0.0,-41.6677);
        v(69.291,0.0,-28.7012);
        v(73.5589,0.0,-14.6317);
        v(62.5,0.0,-6.7481e-006);
        v(61.2991,0.0,12.1932);
        v(57.7424,0.0,23.9177);
        v(51.9668,0.0,34.7231);
        v(44.1941,0.0,44.1942);
        v(34.7231,0.0,51.9669);
        v(23.9177,0.0,57.7425);
        v(12.1931,0.0,61.2991);
        v(-1.86009e-005,0.0,62.5);
        v(-12.1932,0.0,61.2991);
        v(-23.9177,0.0,57.7425);
        v(-34.7232,0.0,51.9669);
        v(-44.1942,0.0,44.1942);
        v(-51.9669,0.0,34.7231);
        v(-57.7425,0.0,23.9177);
        v(-61.2991,0.0,12.1931);
        v(-62.5,0.0,-2.20069e-005);
        v(-61.2991,0.0,-12.1932);
        v(-57.7425,0.0,-23.9177);
        v(-51.9668,0.0,-34.7232);
        v(-44.1942,0.0,-44.1942);
        v(-34.7231,0.0,-51.9669);
        v(-23.9177,0.0,-57.7425);
        v(-12.1931,0.0,-61.2991);
        v(5.7693e-005,0.0,-62.5);
        v(12.1932,0.0,-61.2991);
        v(23.9178,0.0,-57.7425);
        v(34.7232,0.0,-51.9668);
        v(44.1942,0.0,-44.1941);
        v(51.9669,0.0,-34.7231);
        v(57.7425,0.0,-23.9176);
        v(61.2991,0.0,-12.193);
        v(50.0,0.0,-6.7481e-006);
        v(49.0393,0.0,9.75451);
        v(46.194,0.0,19.1342);
        v(41.5735,0.0,27.7785);
        v(35.3553,0.0,35.3553);
        v(27.7785,0.0,41.5735);
        v(19.1342,0.0,46.194);
        v(9.7545,0.0,49.0393);
        v(-1.86009e-005,0.0,50.0);
        v(-9.75453,0.0,49.0393);
        v(-19.1342,0.0,46.194);
        v(-27.7785,0.0,41.5735);
        v(-35.3554,0.0,35.3553);
        v(-41.5735,0.0,27.7785);
        v(-46.194,0.0,19.1342);
        v(-49.0393,0.0,9.75451);
        v(-50.0,0.0,-3.72657e-005);
        v(-49.0393,0.0,-9.75454);
        v(-46.194,0.0,-19.1342);
        v(-41.5735,0.0,-27.7785);
        v(-35.3553,0.0,-35.3554);
        v(-27.7785,0.0,-41.5735);
        v(-19.1342,0.0,-46.194);
        v(-9.7545,0.0,-49.0393);
        v(2.71755e-005,0.0,-50.0);
        v(9.75457,0.0,-49.0393);
        v(19.1342,0.0,-46.194);
        v(27.7786,0.0,-41.5735);
        v(35.3554,0.0,-35.3553);
        v(41.5735,0.0,-27.7785);
        v(46.194,0.0,-19.1341);
        v(49.0393,0.0,-9.75445);
        v(37.5,0.0,-6.7481e-006);
        v(36.7794,0.0,7.3159);
        v(34.6455,0.0,14.3506);
        v(31.1801,0.0,20.8339);
        v(26.5165,0.0,26.5165);
        v(20.8339,0.0,31.1801);
        v(14.3506,0.0,34.6455);
        v(7.31588,0.0,36.7794);
        v(-1.86009e-005,0.0,37.5);
        v(-7.31589,0.0,36.7794);
        v(-14.3506,0.0,34.6455);
        v(-20.8339,0.0,31.1801);
        v(-26.5165,0.0,26.5165);
        v(-31.1801,0.0,20.8339);
        v(-34.6455,0.0,14.3506);
        v(-36.7795,0.0,7.31587);
        v(-37.5,0.0,-3.72657e-005);
        v(-36.7795,0.0,-7.31591);
        v(-34.6455,0.0,-14.3507);
        v(-31.1801,0.0,-20.8339);
        v(-26.5165,0.0,-26.5165);
        v(-20.8339,0.0,-31.1801);
        v(-14.3506,0.0,-34.6455);
        v(-7.31588,0.0,-36.7795);
        v(2.71755e-005,0.0,-37.5);
        v(7.3159,0.0,-36.7794);
        v(14.3507,0.0,-34.6455);
        v(20.8339,0.0,-31.1801);
        v(26.5165,0.0,-26.5165);
        v(31.1801,0.0,-20.8338);
        v(34.6455,0.0,-14.3506);
        v(36.7794,0.0,-7.31583);
        v(25.0,0.0,-6.7481e-006);
        v(24.5196,0.0,4.87728);
        v(23.097,0.0,9.56709);
        v(20.7867,0.0,13.8893);
        v(17.6776,0.0,17.6777);
        v(13.8892,0.0,20.7867);
        v(9.56707,0.0,23.097);
        v(4.87727,0.0,24.5196);
        v(-1.86009e-005,0.0,25.0);
        v(-4.87728,0.0,24.5196);
        v(-9.5671,0.0,23.097);
        v(-13.8893,0.0,20.7867);
        v(-17.6777,0.0,17.6777);
        v(-20.7868,0.0,13.8893);
        v(-23.097,0.0,9.56707);
        v(-24.5197,0.0,4.87725);
        v(-25.0,0.0,-3.72657e-005);
        v(-24.5197,0.0,-4.87726);
        v(-23.097,0.0,-9.5671);
        v(-20.7868,0.0,-13.8893);
        v(-17.6777,0.0,-17.6777);
        v(-13.8893,0.0,-20.7868);
        v(-9.5671,0.0,-23.097);
        v(-4.87725,0.0,-24.5196);
        v(1.19167e-005,0.0,-25.0);
        v(4.87729,0.0,-24.5196);
        v(9.56711,0.0,-23.097);
        v(13.8892,0.0,-20.7867);
        v(17.6777,0.0,-17.6776);
        v(20.7867,0.0,-13.8892);
        v(23.097,0.0,-9.56705);
        v(24.5196,0.0,-4.87723);
        uv(0.750044,0.0);
        uv(0.781289,0.0);
        uv(0.812533,0.0);
        uv(0.843778,0.0);
        uv(0.875022,0.0);
        uv(0.906267,0.0);
        uv(0.937511,0.0);
        uv(0.968756,0.0);
        uv(1.0,0.0);
        uv(0.0314208,0.0);
        uv(0.0626653,0.0);
        uv(0.0939098,0.0);
        uv(0.125154,0.0);
        uv(0.156399,0.0);
        uv(0.187643,0.0);
        uv(0.218888,0.0);
        uv(0.250132,0.0);
        uv(0.281377,0.0);
        uv(0.312621,0.0);
        uv(0.343866,0.0);
        uv(0.37511,0.0);
        uv(0.406355,0.0);
        uv(0.437599,0.0);
        uv(0.468844,0.0);
        uv(0.500088,0.0);
        uv(0.531333,0.0);
        uv(0.562577,0.0);
        uv(0.593822,0.0);
        uv(0.625066,0.0);
        uv(0.656311,0.0);
        uv(0.687555,0.0);
        uv(0.7188,0.0);
        uv(0.750044,0.0713183);
        uv(0.781289,0.0713183);
        uv(0.812533,0.0713183);
        uv(0.843778,0.0713183);
        uv(0.875022,0.0713183);
        uv(0.906267,0.0713183);
        uv(0.937511,0.0713183);
        uv(0.968756,0.0713183);
        uv(1.0,0.0713183);
        uv(0.0314208,0.0713183);
        uv(0.0626653,0.0713183);
        uv(0.0939098,0.0713183);
        uv(0.125154,0.0713183);
        uv(0.156399,0.0713183);
        uv(0.187643,0.0713183);
        uv(0.218888,0.0713183);
        uv(0.250132,0.0713183);
        uv(0.281377,0.0713183);
        uv(0.312621,0.0713183);
        uv(0.343866,0.0713183);
        uv(0.37511,0.0713183);
        uv(0.406355,0.0713183);
        uv(0.437599,0.0713183);
        uv(0.468844,0.0713183);
        uv(0.500088,0.0713183);
        uv(0.531333,0.0713183);
        uv(0.562577,0.0713183);
        uv(0.593822,0.0713183);
        uv(0.625066,0.0713183);
        uv(0.656311,0.0713183);
        uv(0.687555,0.0713183);
        uv(0.7188,0.0713183);
        uv(0.750044,0.142637);
        uv(0.781289,0.142637);
        uv(0.812533,0.142637);
        uv(0.843778,0.142637);
        uv(0.875022,0.142637);
        uv(0.906267,0.142637);
        uv(0.937511,0.142637);
        uv(0.968756,0.142637);
        uv(1.0,0.142637);
        uv(0.0314208,0.142637);
        uv(0.0626653,0.142637);
        uv(0.0939098,0.142637);
        uv(0.125154,0.142637);
        uv(0.156399,0.142637);
        uv(0.187643,0.142637);
        uv(0.218888,0.142637);
        uv(0.250132,0.142637);
        uv(0.281377,0.142637);
        uv(0.312621,0.142637);
        uv(0.343866,0.142637);
        uv(0.37511,0.142637);
        uv(0.406355,0.142637);
        uv(0.437599,0.142637);
        uv(0.468844,0.142637);
        uv(0.500088,0.142637);
        uv(0.531333,0.142637);
        uv(0.562577,0.142637);
        uv(0.593822,0.142637);
        uv(0.625066,0.142637);
        uv(0.656311,0.142637);
        uv(0.687555,0.142637);
        uv(0.7188,0.142637);
        uv(0.750044,0.213955);
        uv(0.781289,0.213955);
        uv(0.812533,0.213955);
        uv(0.843778,0.213955);
        uv(0.875022,0.213955);
        uv(0.906267,0.213955);
        uv(0.937511,0.213955);
        uv(0.968756,0.213955);
        uv(1.0,0.213955);
        uv(0.0314208,0.213955);
        uv(0.0626653,0.213955);
        uv(0.0939098,0.213955);
        uv(0.125154,0.213955);
        uv(0.156399,0.213955);
        uv(0.187643,0.213955);
        uv(0.218888,0.213955);
        uv(0.250132,0.213955);
        uv(0.281377,0.213955);
        uv(0.312621,0.213955);
        uv(0.343866,0.213955);
        uv(0.37511,0.213955);
        uv(0.406355,0.213955);
        uv(0.437599,0.213955);
        uv(0.468844,0.213955);
        uv(0.500088,0.213955);
        uv(0.531333,0.213955);
        uv(0.562577,0.213955);
        uv(0.593822,0.213955);
        uv(0.625066,0.213955);
        uv(0.656311,0.213955);
        uv(0.687555,0.213955);
        uv(0.7188,0.213955);
        uv(0.750044,0.285273);
        uv(0.781289,0.285273);
        uv(0.812533,0.285273);
        uv(0.843778,0.285273);
        uv(0.875022,0.285273);
        uv(0.906267,0.285273);
        uv(0.937511,0.285273);
        uv(0.968756,0.285273);
        uv(1.0,0.285273);
        uv(0.0314208,0.285273);
        uv(0.0626653,0.285273);
        uv(0.0939098,0.285273);
        uv(0.125154,0.285273);
        uv(0.156399,0.285273);
        uv(0.187643,0.285273);
        uv(0.218888,0.285273);
        uv(0.250132,0.285273);
        uv(0.281377,0.285273);
        uv(0.312621,0.285273);
        uv(0.343866,0.285273);
        uv(0.37511,0.285273);
        uv(0.406355,0.285273);
        uv(0.437599,0.285273);
        uv(0.468844,0.285273);
        uv(0.500088,0.285273);
        uv(0.531333,0.285273);
        uv(0.562577,0.285273);
        uv(0.593822,0.285273);
        uv(0.625066,0.285273);
        uv(0.656311,0.285273);
        uv(0.687555,0.285273);
        uv(0.7188,0.285273);
        uv(0.750044,0.356592);
        uv(0.781289,0.356592);
        uv(0.812533,0.356592);
        uv(0.843778,0.356592);
        uv(0.875022,0.356592);
        uv(0.906267,0.356592);
        uv(0.937511,0.356592);
        uv(0.968756,0.356592);
        uv(1.0,0.356592);
        uv(0.0314208,0.356592);
        uv(0.0626653,0.356592);
        uv(0.0939098,0.356592);
        uv(0.125154,0.356592);
        uv(0.156399,0.356592);
        uv(0.187643,0.356592);
        uv(0.218888,0.356592);
        uv(0.250132,0.356592);
        uv(0.281377,0.356592);
        uv(0.312621,0.356592);
        uv(0.343866,0.356592);
        uv(0.37511,0.356592);
        uv(0.406355,0.356592);
        uv(0.437599,0.356592);
        uv(0.468844,0.356592);
        uv(0.500088,0.356592);
        uv(0.531333,0.356592);
        uv(0.562577,0.356592);
        uv(0.593822,0.356592);
        uv(0.625066,0.356592);
        uv(0.656311,0.356592);
        uv(0.687555,0.356592);
        uv(0.7188,0.356592);
        uv(0.750044,0.42791);
        uv(0.781289,0.42791);
        uv(0.812533,0.42791);
        uv(0.843778,0.42791);
        uv(0.875022,0.42791);
        uv(0.906267,0.42791);
        uv(0.937511,0.42791);
        uv(0.968756,0.42791);
        uv(1.0,0.42791);
        uv(0.0314208,0.42791);
        uv(0.0626653,0.42791);
        uv(0.0939098,0.42791);
        uv(0.125154,0.42791);
        uv(0.156399,0.42791);
        uv(0.187643,0.42791);
        uv(0.218888,0.42791);
        uv(0.250132,0.42791);
        uv(0.281377,0.42791);
        uv(0.312621,0.42791);
        uv(0.343866,0.42791);
        uv(0.37511,0.42791);
        uv(0.406355,0.42791);
        uv(0.437599,0.42791);
        uv(0.468844,0.42791);
        uv(0.500088,0.42791);
        uv(0.531333,0.42791);
        uv(0.562577,0.42791);
        uv(0.593822,0.42791);
        uv(0.625066,0.42791);
        uv(0.656311,0.42791);
        uv(0.687555,0.42791);
        uv(0.7188,0.42791);
        uv(0.750044,0.499228);
        uv(0.781289,0.499228);
        uv(0.812533,0.499228);
        uv(0.843778,0.499228);
        uv(0.875022,0.499228);
        uv(0.906267,0.499228);
        uv(0.937511,0.499228);
        uv(0.968756,0.499228);
        uv(1.0,0.499228);
        uv(0.0314208,0.499228);
        uv(0.0626653,0.499228);
        uv(0.0939098,0.499228);
        uv(0.125154,0.499228);
        uv(0.156399,0.499228);
        uv(0.187643,0.499228);
        uv(0.218888,0.499228);
        uv(0.250132,0.499228);
        uv(0.281377,0.499228);
        uv(0.312621,0.499228);
        uv(0.343866,0.499228);
        uv(0.37511,0.499228);
        uv(0.406355,0.499228);
        uv(0.437599,0.499228);
        uv(0.468844,0.499228);
        uv(0.500088,0.499228);
        uv(0.531333,0.499228);
        uv(0.562577,0.499228);
        uv(0.593822,0.499228);
        uv(0.625066,0.499228);
        uv(0.656311,0.499228);
        uv(0.687555,0.499228);
        uv(0.7188,0.499228);
        uv(0.750044,0.570547);
        uv(0.781289,0.570547);
        uv(0.812533,0.570547);
        uv(0.843778,0.570547);
        uv(0.875022,0.570547);
        uv(0.906267,0.570547);
        uv(0.937511,0.570547);
        uv(0.968756,0.570547);
        uv(1.0,0.570547);
        uv(0.0314208,0.570547);
        uv(0.0626653,0.570547);
        uv(0.0939098,0.570547);
        uv(0.125154,0.570547);
        uv(0.156399,0.570547);
        uv(0.187643,0.570547);
        uv(0.218888,0.570547);
        uv(0.250132,0.570547);
        uv(0.281377,0.570547);
        uv(0.312621,0.570547);
        uv(0.343866,0.570547);
        uv(0.37511,0.570547);
        uv(0.406355,0.570547);
        uv(0.437599,0.570547);
        uv(0.468844,0.570547);
        uv(0.500088,0.570547);
        uv(0.531333,0.570547);
        uv(0.562577,0.570547);
        uv(0.593822,0.570547);
        uv(0.625066,0.570547);
        uv(0.656311,0.570547);
        uv(0.687555,0.570547);
        uv(0.7188,0.570547);
        uv(0.750044,0.641865);
        uv(0.781289,0.641865);
        uv(0.812533,0.641865);
        uv(0.843778,0.641865);
        uv(0.875022,0.641865);
        uv(0.906267,0.641865);
        uv(0.937511,0.641865);
        uv(0.968756,0.641865);
        uv(1.0,0.641865);
        uv(0.0314208,0.641865);
        uv(0.0626653,0.641865);
        uv(0.0939098,0.641865);
        uv(0.125154,0.641865);
        uv(0.156399,0.641865);
        uv(0.187643,0.641865);
        uv(0.218888,0.641865);
        uv(0.250132,0.641865);
        uv(0.281377,0.641865);
        uv(0.312621,0.641865);
        uv(0.343866,0.641865);
        uv(0.37511,0.641865);
        uv(0.406355,0.641865);
        uv(0.437599,0.641865);
        uv(0.468844,0.641865);
        uv(0.500088,0.641865);
        uv(0.531333,0.641865);
        uv(0.562577,0.641865);
        uv(0.593822,0.641865);
        uv(0.625066,0.641865);
        uv(0.656311,0.641865);
        uv(0.687555,0.641865);
        uv(0.7188,0.641865);
        uv(0.750044,0.713183);
        uv(0.781289,0.713183);
        uv(0.812533,0.713183);
        uv(0.843778,0.713183);
        uv(0.875022,0.713183);
        uv(0.906267,0.713183);
        uv(0.937511,0.713183);
        uv(0.968756,0.713183);
        uv(1.0,0.713183);
        uv(0.0314208,0.713183);
        uv(0.0626653,0.713183);
        uv(0.0939098,0.713183);
        uv(0.125154,0.713183);
        uv(0.156399,0.713183);
        uv(0.187643,0.713183);
        uv(0.218888,0.713183);
        uv(0.250132,0.713183);
        uv(0.281377,0.713183);
        uv(0.312621,0.713183);
        uv(0.343866,0.713183);
        uv(0.37511,0.713183);
        uv(0.406355,0.713183);
        uv(0.437599,0.713183);
        uv(0.468844,0.713183);
        uv(0.500088,0.713183);
        uv(0.531333,0.713183);
        uv(0.562577,0.713183);
        uv(0.593822,0.713183);
        uv(0.625066,0.713183);
        uv(0.656311,0.713183);
        uv(0.687555,0.713183);
        uv(0.7188,0.713183);
        uv(0.750044,0.784502);
        uv(0.781289,0.784502);
        uv(0.812533,0.784502);
        uv(0.843778,0.784502);
        uv(0.875022,0.784502);
        uv(0.906267,0.784502);
        uv(0.937511,0.784502);
        uv(0.968756,0.784502);
        uv(1.0,0.784502);
        uv(0.0314208,0.784502);
        uv(0.0626653,0.784502);
        uv(0.0939098,0.784502);
        uv(0.125154,0.784502);
        uv(0.156399,0.784502);
        uv(0.187643,0.784502);
        uv(0.218888,0.784502);
        uv(0.250132,0.784502);
        uv(0.281377,0.784502);
        uv(0.312621,0.784502);
        uv(0.343866,0.784502);
        uv(0.37511,0.784502);
        uv(0.406355,0.784502);
        uv(0.437599,0.784502);
        uv(0.468844,0.784502);
        uv(0.500088,0.784502);
        uv(0.531333,0.784502);
        uv(0.562577,0.784502);
        uv(0.593822,0.784502);
        uv(0.625066,0.784502);
        uv(0.656311,0.784502);
        uv(0.687555,0.784502);
        uv(0.7188,0.784502);
        uv(0.750044,0.85582);
        uv(0.781289,0.85582);
        uv(0.812533,0.85582);
        uv(0.843778,0.85582);
        uv(0.875022,0.85582);
        uv(0.906267,0.85582);
        uv(0.937511,0.85582);
        uv(0.968756,0.85582);
        uv(1.0,0.85582);
        uv(0.0314208,0.85582);
        uv(0.0626653,0.85582);
        uv(0.0939098,0.85582);
        uv(0.125154,0.85582);
        uv(0.156399,0.85582);
        uv(0.187643,0.85582);
        uv(0.218888,0.85582);
        uv(0.250132,0.85582);
        uv(0.281377,0.85582);
        uv(0.312621,0.85582);
        uv(0.343866,0.85582);
        uv(0.37511,0.85582);
        uv(0.406355,0.85582);
        uv(0.437599,0.85582);
        uv(0.468844,0.85582);
        uv(0.500088,0.85582);
        uv(0.531333,0.85582);
        uv(0.562577,0.85582);
        uv(0.593822,0.85582);
        uv(0.625066,0.85582);
        uv(0.656311,0.85582);
        uv(0.687555,0.85582);
        uv(0.7188,0.85582);
        uv(0.750044,0.927138);
        uv(0.781289,0.927138);
        uv(0.812533,0.927138);
        uv(0.843778,0.927138);
        uv(0.875022,0.927138);
        uv(0.906267,0.927138);
        uv(0.937511,0.927138);
        uv(0.968756,0.927138);
        uv(1.0,0.927138);
        uv(0.0314208,0.927138);
        uv(0.0626653,0.927138);
        uv(0.0939098,0.927138);
        uv(0.125154,0.927138);
        uv(0.156399,0.927138);
        uv(0.187643,0.927138);
        uv(0.218888,0.927138);
        uv(0.250132,0.927138);
        uv(0.281377,0.927138);
        uv(0.312621,0.927138);
        uv(0.343866,0.927138);
        uv(0.37511,0.927138);
        uv(0.406355,0.927138);
        uv(0.437599,0.927138);
        uv(0.468844,0.927138);
        uv(0.500088,0.927138);
        uv(0.531333,0.927138);
        uv(0.562577,0.927138);
        uv(0.593822,0.927138);
        uv(0.625066,0.927138);
        uv(0.656311,0.927138);
        uv(0.687555,0.927138);
        uv(0.7188,0.927138);
        uv(0.750044,0.998457);
        uv(0.781289,0.998457);
        uv(0.812533,0.998457);
        uv(0.843778,0.998457);
        uv(0.875022,0.998457);
        uv(0.906267,0.998457);
        uv(0.937511,0.998457);
        uv(0.968756,0.998457);
        uv(1.0,0.998457);
        uv(0.0314208,0.998457);
        uv(0.0626653,0.998457);
        uv(0.0939098,0.998457);
        uv(0.125154,0.998457);
        uv(0.156399,0.998457);
        uv(0.187643,0.998457);
        uv(0.218888,0.998457);
        uv(0.250132,0.998457);
        uv(0.281377,0.998457);
        uv(0.312621,0.998457);
        uv(0.343866,0.998457);
        uv(0.37511,0.998457);
        uv(0.406355,0.998457);
        uv(0.437599,0.998457);
        uv(0.468844,0.998457);
        uv(0.500088,0.998457);
        uv(0.531333,0.998457);
        uv(0.562577,0.998457);
        uv(0.593822,0.998457);
        uv(0.625066,0.998457);
        uv(0.656311,0.998457);
        uv(0.687555,0.998457);
        uv(0.7188,0.998457);
        uv(0.000176267,0.0);
        uv(0.000176327,0.0713183);
        uv(0.000176327,0.0713183);
        uv(0.000176327,0.142637);
        uv(0.000176327,0.142637);
        uv(0.000176267,0.213955);
        uv(0.000176267,0.213955);
        uv(0.000176267,0.285273);
        uv(0.000176267,0.285273);
        uv(0.000176267,0.356592);
        uv(0.000176267,0.356592);
        uv(0.000176327,0.42791);
        uv(0.000176327,0.42791);
        uv(0.000176327,0.499228);
        uv(0.000176327,0.499228);
        uv(0.000176267,0.570547);
        uv(0.000176267,0.570547);
        uv(0.000176327,0.641865);
        uv(0.000176327,0.641865);
        uv(0.000176267,0.713183);
        uv(0.000176267,0.713183);
        uv(0.000176327,0.784502);
        uv(0.000176327,0.784502);
        uv(0.000176267,0.85582);
        uv(0.000176267,0.85582);
        uv(0.000176267,0.927138);
        uv(0.000176267,0.927138);
        uv(0.000176267,0.998457);
        f(0,1,33,0,1,33);
        f(33,32,0,33,32,0);
        f(1,2,34,1,2,34);
        f(34,33,1,34,33,1);
        f(2,3,35,2,3,35);
        f(35,34,2,35,34,2);
        f(3,4,36,3,4,36);
        f(36,35,3,36,35,3);
        f(4,5,37,4,5,37);
        f(37,36,4,37,36,4);
        f(5,6,38,5,6,38);
        f(38,37,5,38,37,5);
        f(6,7,39,6,7,39);
        f(39,38,6,39,38,6);
        f(7,8,40,7,8,40);
        f(40,39,7,40,39,7);
        f(8,9,41,480,9,41);
        f(41,40,8,41,481,480);
        f(9,10,42,9,10,42);
        f(42,41,9,42,41,9);
        f(10,11,43,10,11,43);
        f(43,42,10,43,42,10);
        f(11,12,44,11,12,44);
        f(44,43,11,44,43,11);
        f(12,13,45,12,13,45);
        f(45,44,12,45,44,12);
        f(13,14,46,13,14,46);
        f(46,45,13,46,45,13);
        f(14,15,47,14,15,47);
        f(47,46,14,47,46,14);
        f(15,16,48,15,16,48);
        f(48,47,15,48,47,15);
        f(16,17,49,16,17,49);
        f(49,48,16,49,48,16);
        f(17,18,50,17,18,50);
        f(50,49,17,50,49,17);
        f(18,19,51,18,19,51);
        f(51,50,18,51,50,18);
        f(19,20,52,19,20,52);
        f(52,51,19,52,51,19);
        f(20,21,53,20,21,53);
        f(53,52,20,53,52,20);
        f(21,22,54,21,22,54);
        f(54,53,21,54,53,21);
        f(22,23,55,22,23,55);
        f(55,54,22,55,54,22);
        f(23,24,56,23,24,56);
        f(56,55,23,56,55,23);
        f(24,25,57,24,25,57);
        f(57,56,24,57,56,24);
        f(25,26,58,25,26,58);
        f(58,57,25,58,57,25);
        f(26,27,59,26,27,59);
        f(59,58,26,59,58,26);
        f(27,28,60,27,28,60);
        f(60,59,27,60,59,27);
        f(28,29,61,28,29,61);
        f(61,60,28,61,60,28);
        f(29,30,62,29,30,62);
        f(62,61,29,62,61,29);
        f(30,31,63,30,31,63);
        f(63,62,30,63,62,30);
        f(31,0,32,31,0,32);
        f(32,63,31,32,63,31);
        f(32,33,65,32,33,65);
        f(65,64,32,65,64,32);
        f(33,34,66,33,34,66);
        f(66,65,33,66,65,33);
        f(34,35,67,34,35,67);
        f(67,66,34,67,66,34);
        f(35,36,68,35,36,68);
        f(68,67,35,68,67,35);
        f(36,37,69,36,37,69);
        f(69,68,36,69,68,36);
        f(37,38,70,37,38,70);
        f(70,69,37,70,69,37);
        f(38,39,71,38,39,71);
        f(71,70,38,71,70,38);
        f(39,40,72,39,40,72);
        f(72,71,39,72,71,39);
        f(40,41,73,482,41,73);
        f(73,72,40,73,483,482);
        f(41,42,74,41,42,74);
        f(74,73,41,74,73,41);
        f(42,43,75,42,43,75);
        f(75,74,42,75,74,42);
        f(43,44,76,43,44,76);
        f(76,75,43,76,75,43);
        f(44,45,77,44,45,77);
        f(77,76,44,77,76,44);
        f(45,46,78,45,46,78);
        f(78,77,45,78,77,45);
        f(46,47,79,46,47,79);
        f(79,78,46,79,78,46);
        f(47,48,80,47,48,80);
        f(80,79,47,80,79,47);
        f(48,49,81,48,49,81);
        f(81,80,48,81,80,48);
        f(49,50,82,49,50,82);
        f(82,81,49,82,81,49);
        f(50,51,83,50,51,83);
        f(83,82,50,83,82,50);
        f(51,52,84,51,52,84);
        f(84,83,51,84,83,51);
        f(52,53,85,52,53,85);
        f(85,84,52,85,84,52);
        f(53,54,86,53,54,86);
        f(86,85,53,86,85,53);
        f(54,55,87,54,55,87);
        f(87,86,54,87,86,54);
        f(55,56,88,55,56,88);
        f(88,87,55,88,87,55);
        f(56,57,89,56,57,89);
        f(89,88,56,89,88,56);
        f(57,58,90,57,58,90);
        f(90,89,57,90,89,57);
        f(58,59,91,58,59,91);
        f(91,90,58,91,90,58);
        f(59,60,92,59,60,92);
        f(92,91,59,92,91,59);
        f(60,61,93,60,61,93);
        f(93,92,60,93,92,60);
        f(61,62,94,61,62,94);
        f(94,93,61,94,93,61);
        f(62,63,95,62,63,95);
        f(95,94,62,95,94,62);
        f(63,32,64,63,32,64);
        f(64,95,63,64,95,63);
        f(64,65,97,64,65,97);
        f(97,96,64,97,96,64);
        f(65,66,98,65,66,98);
        f(98,97,65,98,97,65);
        f(66,67,99,66,67,99);
        f(99,98,66,99,98,66);
        f(67,68,100,67,68,100);
        f(100,99,67,100,99,67);
        f(68,69,101,68,69,101);
        f(101,100,68,101,100,68);
        f(69,70,102,69,70,102);
        f(102,101,69,102,101,69);
        f(70,71,103,70,71,103);
        f(103,102,70,103,102,70);
        f(71,72,104,71,72,104);
        f(104,103,71,104,103,71);
        f(72,73,105,484,73,105);
        f(105,104,72,105,485,484);
        f(73,74,106,73,74,106);
        f(106,105,73,106,105,73);
        f(74,75,107,74,75,107);
        f(107,106,74,107,106,74);
        f(75,76,108,75,76,108);
        f(108,107,75,108,107,75);
        f(76,77,109,76,77,109);
        f(109,108,76,109,108,76);
        f(77,78,110,77,78,110);
        f(110,109,77,110,109,77);
        f(78,79,111,78,79,111);
        f(111,110,78,111,110,78);
        f(79,80,112,79,80,112);
        f(112,111,79,112,111,79);
        f(80,81,113,80,81,113);
        f(113,112,80,113,112,80);
        f(81,82,114,81,82,114);
        f(114,113,81,114,113,81);
        f(82,83,115,82,83,115);
        f(115,114,82,115,114,82);
        f(83,84,116,83,84,116);
        f(116,115,83,116,115,83);
        f(84,85,117,84,85,117);
        f(117,116,84,117,116,84);
        f(85,86,118,85,86,118);
        f(118,117,85,118,117,85);
        f(86,87,119,86,87,119);
        f(119,118,86,119,118,86);
        f(87,88,120,87,88,120);
        f(120,119,87,120,119,87);
        f(88,89,121,88,89,121);
        f(121,120,88,121,120,88);
        f(89,90,122,89,90,122);
        f(122,121,89,122,121,89);
        f(90,91,123,90,91,123);
        f(123,122,90,123,122,90);
        f(91,92,124,91,92,124);
        f(124,123,91,124,123,91);
        f(92,93,125,92,93,125);
        f(125,124,92,125,124,92);
        f(93,94,126,93,94,126);
        f(126,125,93,126,125,93);
        f(94,95,127,94,95,127);
        f(127,126,94,127,126,94);
        f(95,64,96,95,64,96);
        f(96,127,95,96,127,95);
        f(96,97,129,96,97,129);
        f(129,128,96,129,128,96);
        f(97,98,130,97,98,130);
        f(130,129,97,130,129,97);
        f(98,99,131,98,99,131);
        f(131,130,98,131,130,98);
        f(99,100,132,99,100,132);
        f(132,131,99,132,131,99);
        f(100,101,133,100,101,133);
        f(133,132,100,133,132,100);
        f(101,102,134,101,102,134);
        f(134,133,101,134,133,101);
        f(102,103,135,102,103,135);
        f(135,134,102,135,134,102);
        f(103,104,136,103,104,136);
        f(136,135,103,136,135,103);
        f(104,105,137,486,105,137);
        f(137,136,104,137,487,486);
        f(105,106,138,105,106,138);
        f(138,137,105,138,137,105);
        f(106,107,139,106,107,139);
        f(139,138,106,139,138,106);
        f(107,108,140,107,108,140);
        f(140,139,107,140,139,107);
        f(108,109,141,108,109,141);
        f(141,140,108,141,140,108);
        f(109,110,142,109,110,142);
        f(142,141,109,142,141,109);
        f(110,111,143,110,111,143);
        f(143,142,110,143,142,110);
        f(111,112,144,111,112,144);
        f(144,143,111,144,143,111);
        f(112,113,145,112,113,145);
        f(145,144,112,145,144,112);
        f(113,114,146,113,114,146);
        f(146,145,113,146,145,113);
        f(114,115,147,114,115,147);
        f(147,146,114,147,146,114);
        f(115,116,148,115,116,148);
        f(148,147,115,148,147,115);
        f(116,117,149,116,117,149);
        f(149,148,116,149,148,116);
        f(117,118,150,117,118,150);
        f(150,149,117,150,149,117);
        f(118,119,151,118,119,151);
        f(151,150,118,151,150,118);
        f(119,120,152,119,120,152);
        f(152,151,119,152,151,119);
        f(120,121,153,120,121,153);
        f(153,152,120,153,152,120);
        f(121,122,154,121,122,154);
        f(154,153,121,154,153,121);
        f(122,123,155,122,123,155);
        f(155,154,122,155,154,122);
        f(123,124,156,123,124,156);
        f(156,155,123,156,155,123);
        f(124,125,157,124,125,157);
        f(157,156,124,157,156,124);
        f(125,126,158,125,126,158);
        f(158,157,125,158,157,125);
        f(126,127,159,126,127,159);
        f(159,158,126,159,158,126);
        f(127,96,128,127,96,128);
        f(128,159,127,128,159,127);
        f(128,129,161,128,129,161);
        f(161,160,128,161,160,128);
        f(129,130,162,129,130,162);
        f(162,161,129,162,161,129);
        f(130,131,163,130,131,163);
        f(163,162,130,163,162,130);
        f(131,132,164,131,132,164);
        f(164,163,131,164,163,131);
        f(132,133,165,132,133,165);
        f(165,164,132,165,164,132);
        f(133,134,166,133,134,166);
        f(166,165,133,166,165,133);
        f(134,135,167,134,135,167);
        f(167,166,134,167,166,134);
        f(135,136,168,135,136,168);
        f(168,167,135,168,167,135);
        f(136,137,169,488,137,169);
        f(169,168,136,169,489,488);
        f(137,138,170,137,138,170);
        f(170,169,137,170,169,137);
        f(138,139,171,138,139,171);
        f(171,170,138,171,170,138);
        f(139,140,172,139,140,172);
        f(172,171,139,172,171,139);
        f(140,141,173,140,141,173);
        f(173,172,140,173,172,140);
        f(141,142,174,141,142,174);
        f(174,173,141,174,173,141);
        f(142,143,175,142,143,175);
        f(175,174,142,175,174,142);
        f(143,144,176,143,144,176);
        f(176,175,143,176,175,143);
        f(144,145,177,144,145,177);
        f(177,176,144,177,176,144);
        f(145,146,178,145,146,178);
        f(178,177,145,178,177,145);
        f(146,147,179,146,147,179);
        f(179,178,146,179,178,146);
        f(147,148,180,147,148,180);
        f(180,179,147,180,179,147);
        f(148,149,181,148,149,181);
        f(181,180,148,181,180,148);
        f(149,150,182,149,150,182);
        f(182,181,149,182,181,149);
        f(150,151,183,150,151,183);
        f(183,182,150,183,182,150);
        f(151,152,184,151,152,184);
        f(184,183,151,184,183,151);
        f(152,153,185,152,153,185);
        f(185,184,152,185,184,152);
        f(153,154,186,153,154,186);
        f(186,185,153,186,185,153);
        f(154,155,187,154,155,187);
        f(187,186,154,187,186,154);
        f(155,156,188,155,156,188);
        f(188,187,155,188,187,155);
        f(156,157,189,156,157,189);
        f(189,188,156,189,188,156);
        f(157,158,190,157,158,190);
        f(190,189,157,190,189,157);
        f(158,159,191,158,159,191);
        f(191,190,158,191,190,158);
        f(159,128,160,159,128,160);
        f(160,191,159,160,191,159);
        f(160,161,193,160,161,193);
        f(193,192,160,193,192,160);
        f(161,162,194,161,162,194);
        f(194,193,161,194,193,161);
        f(162,163,195,162,163,195);
        f(195,194,162,195,194,162);
        f(163,164,196,163,164,196);
        f(196,195,163,196,195,163);
        f(164,165,197,164,165,197);
        f(197,196,164,197,196,164);
        f(165,166,198,165,166,198);
        f(198,197,165,198,197,165);
        f(166,167,199,166,167,199);
        f(199,198,166,199,198,166);
        f(167,168,200,167,168,200);
        f(200,199,167,200,199,167);
        f(168,169,201,490,169,201);
        f(201,200,168,201,491,490);
        f(169,170,202,169,170,202);
        f(202,201,169,202,201,169);
        f(170,171,203,170,171,203);
        f(203,202,170,203,202,170);
        f(171,172,204,171,172,204);
        f(204,203,171,204,203,171);
        f(172,173,205,172,173,205);
        f(205,204,172,205,204,172);
        f(173,174,206,173,174,206);
        f(206,205,173,206,205,173);
        f(174,175,207,174,175,207);
        f(207,206,174,207,206,174);
        f(175,176,208,175,176,208);
        f(208,207,175,208,207,175);
        f(176,177,209,176,177,209);
        f(209,208,176,209,208,176);
        f(177,178,210,177,178,210);
        f(210,209,177,210,209,177);
        f(178,179,211,178,179,211);
        f(211,210,178,211,210,178);
        f(179,180,212,179,180,212);
        f(212,211,179,212,211,179);
        f(180,181,213,180,181,213);
        f(213,212,180,213,212,180);
        f(181,182,214,181,182,214);
        f(214,213,181,214,213,181);
        f(182,183,215,182,183,215);
        f(215,214,182,215,214,182);
        f(183,184,216,183,184,216);
        f(216,215,183,216,215,183);
        f(184,185,217,184,185,217);
        f(217,216,184,217,216,184);
        f(185,186,218,185,186,218);
        f(218,217,185,218,217,185);
        f(186,187,219,186,187,219);
        f(219,218,186,219,218,186);
        f(187,188,220,187,188,220);
        f(220,219,187,220,219,187);
        f(188,189,221,188,189,221);
        f(221,220,188,221,220,188);
        f(189,190,222,189,190,222);
        f(222,221,189,222,221,189);
        f(190,191,223,190,191,223);
        f(223,222,190,223,222,190);
        f(191,160,192,191,160,192);
        f(192,223,191,192,223,191);
        f(192,193,225,192,193,225);
        f(225,224,192,225,224,192);
        f(193,194,226,193,194,226);
        f(226,225,193,226,225,193);
        f(194,195,227,194,195,227);
        f(227,226,194,227,226,194);
        f(195,196,228,195,196,228);
        f(228,227,195,228,227,195);
        f(196,197,229,196,197,229);
        f(229,228,196,229,228,196);
        f(197,198,230,197,198,230);
        f(230,229,197,230,229,197);
        f(198,199,231,198,199,231);
        f(231,230,198,231,230,198);
        f(199,200,232,199,200,232);
        f(232,231,199,232,231,199);
        f(200,201,233,492,201,233);
        f(233,232,200,233,493,492);
        f(201,202,234,201,202,234);
        f(234,233,201,234,233,201);
        f(202,203,235,202,203,235);
        f(235,234,202,235,234,202);
        f(203,204,236,203,204,236);
        f(236,235,203,236,235,203);
        f(204,205,237,204,205,237);
        f(237,236,204,237,236,204);
        f(205,206,238,205,206,238);
        f(238,237,205,238,237,205);
        f(206,207,239,206,207,239);
        f(239,238,206,239,238,206);
        f(207,208,240,207,208,240);
        f(240,239,207,240,239,207);
        f(208,209,241,208,209,241);
        f(241,240,208,241,240,208);
        f(209,210,242,209,210,242);
        f(242,241,209,242,241,209);
        f(210,211,243,210,211,243);
        f(243,242,210,243,242,210);
        f(211,212,244,211,212,244);
        f(244,243,211,244,243,211);
        f(212,213,245,212,213,245);
        f(245,244,212,245,244,212);
        f(213,214,246,213,214,246);
        f(246,245,213,246,245,213);
        f(214,215,247,214,215,247);
        f(247,246,214,247,246,214);
        f(215,216,248,215,216,248);
        f(248,247,215,248,247,215);
        f(216,217,249,216,217,249);
        f(249,248,216,249,248,216);
        f(217,218,250,217,218,250);
        f(250,249,217,250,249,217);
        f(218,219,251,218,219,251);
        f(251,250,218,251,250,218);
        f(219,220,252,219,220,252);
        f(252,251,219,252,251,219);
        f(220,221,253,220,221,253);
        f(253,252,220,253,252,220);
        f(221,222,254,221,222,254);
        f(254,253,221,254,253,221);
        f(222,223,255,222,223,255);
        f(255,254,222,255,254,222);
        f(223,192,224,223,192,224);
        f(224,255,223,224,255,223);
        f(224,225,257,224,225,257);
        f(257,256,224,257,256,224);
        f(225,226,258,225,226,258);
        f(258,257,225,258,257,225);
        f(226,227,259,226,227,259);
        f(259,258,226,259,258,226);
        f(227,228,260,227,228,260);
        f(260,259,227,260,259,227);
        f(228,229,261,228,229,261);
        f(261,260,228,261,260,228);
        f(229,230,262,229,230,262);
        f(262,261,229,262,261,229);
        f(230,231,263,230,231,263);
        f(263,262,230,263,262,230);
        f(231,232,264,231,232,264);
        f(264,263,231,264,263,231);
        f(232,233,265,494,233,265);
        f(265,264,232,265,495,494);
        f(233,234,266,233,234,266);
        f(266,265,233,266,265,233);
        f(234,235,267,234,235,267);
        f(267,266,234,267,266,234);
        f(235,236,268,235,236,268);
        f(268,267,235,268,267,235);
        f(236,237,269,236,237,269);
        f(269,268,236,269,268,236);
        f(237,238,270,237,238,270);
        f(270,269,237,270,269,237);
        f(238,239,271,238,239,271);
        f(271,270,238,271,270,238);
        f(239,240,272,239,240,272);
        f(272,271,239,272,271,239);
        f(240,241,273,240,241,273);
        f(273,272,240,273,272,240);
        f(241,242,274,241,242,274);
        f(274,273,241,274,273,241);
        f(242,243,275,242,243,275);
        f(275,274,242,275,274,242);
        f(243,244,276,243,244,276);
        f(276,275,243,276,275,243);
        f(244,245,277,244,245,277);
        f(277,276,244,277,276,244);
        f(245,246,278,245,246,278);
        f(278,277,245,278,277,245);
        f(246,247,279,246,247,279);
        f(279,278,246,279,278,246);
        f(247,248,280,247,248,280);
        f(280,279,247,280,279,247);
        f(248,249,281,248,249,281);
        f(281,280,248,281,280,248);
        f(249,250,282,249,250,282);
        f(282,281,249,282,281,249);
        f(250,251,283,250,251,283);
        f(283,282,250,283,282,250);
        f(251,252,284,251,252,284);
        f(284,283,251,284,283,251);
        f(252,253,285,252,253,285);
        f(285,284,252,285,284,252);
        f(253,254,286,253,254,286);
        f(286,285,253,286,285,253);
        f(254,255,287,254,255,287);
        f(287,286,254,287,286,254);
        f(255,224,256,255,224,256);
        f(256,287,255,256,287,255);
        f(256,257,289,256,257,289);
        f(289,288,256,289,288,256);
        f(257,258,290,257,258,290);
        f(290,289,257,290,289,257);
        f(258,259,291,258,259,291);
        f(291,290,258,291,290,258);
        f(259,260,292,259,260,292);
        f(292,291,259,292,291,259);
        f(260,261,293,260,261,293);
        f(293,292,260,293,292,260);
        f(261,262,294,261,262,294);
        f(294,293,261,294,293,261);
        f(262,263,295,262,263,295);
        f(295,294,262,295,294,262);
        f(263,264,296,263,264,296);
        f(296,295,263,296,295,263);
        f(264,265,297,496,265,297);
        f(297,296,264,297,497,496);
        f(265,266,298,265,266,298);
        f(298,297,265,298,297,265);
        f(266,267,299,266,267,299);
        f(299,298,266,299,298,266);
        f(267,268,300,267,268,300);
        f(300,299,267,300,299,267);
        f(268,269,301,268,269,301);
        f(301,300,268,301,300,268);
        f(269,270,302,269,270,302);
        f(302,301,269,302,301,269);
        f(270,271,303,270,271,303);
        f(303,302,270,303,302,270);
        f(271,272,304,271,272,304);
        f(304,303,271,304,303,271);
        f(272,273,305,272,273,305);
        f(305,304,272,305,304,272);
        f(273,274,306,273,274,306);
        f(306,305,273,306,305,273);
        f(274,275,307,274,275,307);
        f(307,306,274,307,306,274);
        f(275,276,308,275,276,308);
        f(308,307,275,308,307,275);
        f(276,277,309,276,277,309);
        f(309,308,276,309,308,276);
        f(277,278,310,277,278,310);
        f(310,309,277,310,309,277);
        f(278,279,311,278,279,311);
        f(311,310,278,311,310,278);
        f(279,280,312,279,280,312);
        f(312,311,279,312,311,279);
        f(280,281,313,280,281,313);
        f(313,312,280,313,312,280);
        f(281,282,314,281,282,314);
        f(314,313,281,314,313,281);
        f(282,283,315,282,283,315);
        f(315,314,282,315,314,282);
        f(283,284,316,283,284,316);
        f(316,315,283,316,315,283);
        f(284,285,317,284,285,317);
        f(317,316,284,317,316,284);
        f(285,286,318,285,286,318);
        f(318,317,285,318,317,285);
        f(286,287,319,286,287,319);
        f(319,318,286,319,318,286);
        f(287,256,288,287,256,288);
        f(288,319,287,288,319,287);
        f(288,289,321,288,289,321);
        f(321,320,288,321,320,288);
        f(289,290,322,289,290,322);
        f(322,321,289,322,321,289);
        f(290,291,323,290,291,323);
        f(323,322,290,323,322,290);
        f(291,292,324,291,292,324);
        f(324,323,291,324,323,291);
        f(292,293,325,292,293,325);
        f(325,324,292,325,324,292);
        f(293,294,326,293,294,326);
        f(326,325,293,326,325,293);
        f(294,295,327,294,295,327);
        f(327,326,294,327,326,294);
        f(295,296,328,295,296,328);
        f(328,327,295,328,327,295);
        f(296,297,329,498,297,329);
        f(329,328,296,329,499,498);
        f(297,298,330,297,298,330);
        f(330,329,297,330,329,297);
        f(298,299,331,298,299,331);
        f(331,330,298,331,330,298);
        f(299,300,332,299,300,332);
        f(332,331,299,332,331,299);
        f(300,301,333,300,301,333);
        f(333,332,300,333,332,300);
        f(301,302,334,301,302,334);
        f(334,333,301,334,333,301);
        f(302,303,335,302,303,335);
        f(335,334,302,335,334,302);
        f(303,304,336,303,304,336);
        f(336,335,303,336,335,303);
        f(304,305,337,304,305,337);
        f(337,336,304,337,336,304);
        f(305,306,338,305,306,338);
        f(338,337,305,338,337,305);
        f(306,307,339,306,307,339);
        f(339,338,306,339,338,306);
        f(307,308,340,307,308,340);
        f(340,339,307,340,339,307);
        f(308,309,341,308,309,341);
        f(341,340,308,341,340,308);
        f(309,310,342,309,310,342);
        f(342,341,309,342,341,309);
        f(310,311,343,310,311,343);
        f(343,342,310,343,342,310);
        f(311,312,344,311,312,344);
        f(344,343,311,344,343,311);
        f(312,313,345,312,313,345);
        f(345,344,312,345,344,312);
        f(313,314,346,313,314,346);
        f(346,345,313,346,345,313);
        f(314,315,347,314,315,347);
        f(347,346,314,347,346,314);
        f(315,316,348,315,316,348);
        f(348,347,315,348,347,315);
        f(316,317,349,316,317,349);
        f(349,348,316,349,348,316);
        f(317,318,350,317,318,350);
        f(350,349,317,350,349,317);
        f(318,319,351,318,319,351);
        f(351,350,318,351,350,318);
        f(319,288,320,319,288,320);
        f(320,351,319,320,351,319);
        f(320,321,353,320,321,353);
        f(353,352,320,353,352,320);
        f(321,322,354,321,322,354);
        f(354,353,321,354,353,321);
        f(322,323,355,322,323,355);
        f(355,354,322,355,354,322);
        f(323,324,356,323,324,356);
        f(356,355,323,356,355,323);
        f(324,325,357,324,325,357);
        f(357,356,324,357,356,324);
        f(325,326,358,325,326,358);
        f(358,357,325,358,357,325);
        f(326,327,359,326,327,359);
        f(359,358,326,359,358,326);
        f(327,328,360,327,328,360);
        f(360,359,327,360,359,327);
        f(328,329,361,500,329,361);
        f(361,360,328,361,501,500);
        f(329,330,362,329,330,362);
        f(362,361,329,362,361,329);
        f(330,331,363,330,331,363);
        f(363,362,330,363,362,330);
        f(331,332,364,331,332,364);
        f(364,363,331,364,363,331);
        f(332,333,365,332,333,365);
        f(365,364,332,365,364,332);
        f(333,334,366,333,334,366);
        f(366,365,333,366,365,333);
        f(334,335,367,334,335,367);
        f(367,366,334,367,366,334);
        f(335,336,368,335,336,368);
        f(368,367,335,368,367,335);
        f(336,337,369,336,337,369);
        f(369,368,336,369,368,336);
        f(337,338,370,337,338,370);
        f(370,369,337,370,369,337);
        f(338,339,371,338,339,371);
        f(371,370,338,371,370,338);
        f(339,340,372,339,340,372);
        f(372,371,339,372,371,339);
        f(340,341,373,340,341,373);
        f(373,372,340,373,372,340);
        f(341,342,374,341,342,374);
        f(374,373,341,374,373,341);
        f(342,343,375,342,343,375);
        f(375,374,342,375,374,342);
        f(343,344,376,343,344,376);
        f(376,375,343,376,375,343);
        f(344,345,377,344,345,377);
        f(377,376,344,377,376,344);
        f(345,346,378,345,346,378);
        f(378,377,345,378,377,345);
        f(346,347,379,346,347,379);
        f(379,378,346,379,378,346);
        f(347,348,380,347,348,380);
        f(380,379,347,380,379,347);
        f(348,349,381,348,349,381);
        f(381,380,348,381,380,348);
        f(349,350,382,349,350,382);
        f(382,381,349,382,381,349);
        f(350,351,383,350,351,383);
        f(383,382,350,383,382,350);
        f(351,320,352,351,320,352);
        f(352,383,351,352,383,351);
        f(352,353,385,352,353,385);
        f(385,384,352,385,384,352);
        f(353,354,386,353,354,386);
        f(386,385,353,386,385,353);
        f(354,355,387,354,355,387);
        f(387,386,354,387,386,354);
        f(355,356,388,355,356,388);
        f(388,387,355,388,387,355);
        f(356,357,389,356,357,389);
        f(389,388,356,389,388,356);
        f(357,358,390,357,358,390);
        f(390,389,357,390,389,357);
        f(358,359,391,358,359,391);
        f(391,390,358,391,390,358);
        f(359,360,392,359,360,392);
        f(392,391,359,392,391,359);
        f(360,361,393,502,361,393);
        f(393,392,360,393,503,502);
        f(361,362,394,361,362,394);
        f(394,393,361,394,393,361);
        f(362,363,395,362,363,395);
        f(395,394,362,395,394,362);
        f(363,364,396,363,364,396);
        f(396,395,363,396,395,363);
        f(364,365,397,364,365,397);
        f(397,396,364,397,396,364);
        f(365,366,398,365,366,398);
        f(398,397,365,398,397,365);
        f(366,367,399,366,367,399);
        f(399,398,366,399,398,366);
        f(367,368,400,367,368,400);
        f(400,399,367,400,399,367);
        f(368,369,401,368,369,401);
        f(401,400,368,401,400,368);
        f(369,370,402,369,370,402);
        f(402,401,369,402,401,369);
        f(370,371,403,370,371,403);
        f(403,402,370,403,402,370);
        f(371,372,404,371,372,404);
        f(404,403,371,404,403,371);
        f(372,373,405,372,373,405);
        f(405,404,372,405,404,372);
        f(373,374,406,373,374,406);
        f(406,405,373,406,405,373);
        f(374,375,407,374,375,407);
        f(407,406,374,407,406,374);
        f(375,376,408,375,376,408);
        f(408,407,375,408,407,375);
        f(376,377,409,376,377,409);
        f(409,408,376,409,408,376);
        f(377,378,410,377,378,410);
        f(410,409,377,410,409,377);
        f(378,379,411,378,379,411);
        f(411,410,378,411,410,378);
        f(379,380,412,379,380,412);
        f(412,411,379,412,411,379);
        f(380,381,413,380,381,413);
        f(413,412,380,413,412,380);
        f(381,382,414,381,382,414);
        f(414,413,381,414,413,381);
        f(382,383,415,382,383,415);
        f(415,414,382,415,414,382);
        f(383,352,384,383,352,384);
        f(384,415,383,384,415,383);
        f(384,385,417,384,385,417);
        f(417,416,384,417,416,384);
        f(385,386,418,385,386,418);
        f(418,417,385,418,417,385);
        f(386,387,419,386,387,419);
        f(419,418,386,419,418,386);
        f(387,388,420,387,388,420);
        f(420,419,387,420,419,387);
        f(388,389,421,388,389,421);
        f(421,420,388,421,420,388);
        f(389,390,422,389,390,422);
        f(422,421,389,422,421,389);
        f(390,391,423,390,391,423);
        f(423,422,390,423,422,390);
        f(391,392,424,391,392,424);
        f(424,423,391,424,423,391);
        f(392,393,425,504,393,425);
        f(425,424,392,425,505,504);
        f(393,394,426,393,394,426);
        f(426,425,393,426,425,393);
        f(394,395,427,394,395,427);
        f(427,426,394,427,426,394);
        f(395,396,428,395,396,428);
        f(428,427,395,428,427,395);
        f(396,397,429,396,397,429);
        f(429,428,396,429,428,396);
        f(397,398,430,397,398,430);
        f(430,429,397,430,429,397);
        f(398,399,431,398,399,431);
        f(431,430,398,431,430,398);
        f(399,400,432,399,400,432);
        f(432,431,399,432,431,399);
        f(400,401,433,400,401,433);
        f(433,432,400,433,432,400);
        f(401,402,434,401,402,434);
        f(434,433,401,434,433,401);
        f(402,403,435,402,403,435);
        f(435,434,402,435,434,402);
        f(403,404,436,403,404,436);
        f(436,435,403,436,435,403);
        f(404,405,437,404,405,437);
        f(437,436,404,437,436,404);
        f(405,406,438,405,406,438);
        f(438,437,405,438,437,405);
        f(406,407,439,406,407,439);
        f(439,438,406,439,438,406);
        f(407,408,440,407,408,440);
        f(440,439,407,440,439,407);
        f(408,409,441,408,409,441);
        f(441,440,408,441,440,408);
        f(409,410,442,409,410,442);
        f(442,441,409,442,441,409);
        f(410,411,443,410,411,443);
        f(443,442,410,443,442,410);
        f(411,412,444,411,412,444);
        f(444,443,411,444,443,411);
        f(412,413,445,412,413,445);
        f(445,444,412,445,444,412);
        f(413,414,446,413,414,446);
        f(446,445,413,446,445,413);
        f(414,415,447,414,415,447);
        f(447,446,414,447,446,414);
        f(415,384,416,415,384,416);
        f(416,447,415,416,447,415);
        f(416,417,449,416,417,449);
        f(449,448,416,449,448,416);
        f(417,418,450,417,418,450);
        f(450,449,417,450,449,417);
        f(418,419,451,418,419,451);
        f(451,450,418,451,450,418);
        f(419,420,452,419,420,452);
        f(452,451,419,452,451,419);
        f(420,421,453,420,421,453);
        f(453,452,420,453,452,420);
        f(421,422,454,421,422,454);
        f(454,453,421,454,453,421);
        f(422,423,455,422,423,455);
        f(455,454,422,455,454,422);
        f(423,424,456,423,424,456);
        f(456,455,423,456,455,423);
        f(424,425,457,506,425,457);
        f(457,456,424,457,507,506);
        f(425,426,458,425,426,458);
        f(458,457,425,458,457,425);
        f(426,427,459,426,427,459);
        f(459,458,426,459,458,426);
        f(427,428,460,427,428,460);
        f(460,459,427,460,459,427);
        f(428,429,461,428,429,461);
        f(461,460,428,461,460,428);
        f(429,430,462,429,430,462);
        f(462,461,429,462,461,429);
        f(430,431,463,430,431,463);
        f(463,462,430,463,462,430);
        f(431,432,464,431,432,464);
        f(464,463,431,464,463,431);
        f(432,433,465,432,433,465);
        f(465,464,432,465,464,432);
        f(433,434,466,433,434,466);
        f(466,465,433,466,465,433);
        f(434,435,467,434,435,467);
        f(467,466,434,467,466,434);
        f(435,436,468,435,436,468);
        f(468,467,435,468,467,435);
        f(436,437,469,436,437,469);
        f(469,468,436,469,468,436);
        f(437,438,470,437,438,470);
        f(470,469,437,470,469,437);
        f(438,439,471,438,439,471);
        f(471,470,438,471,470,438);
        f(439,440,472,439,440,472);
        f(472,471,439,472,471,439);
        f(440,441,473,440,441,473);
        f(473,472,440,473,472,440);
        f(441,442,474,441,442,474);
        f(474,473,441,474,473,441);
        f(442,443,475,442,443,475);
        f(475,474,442,475,474,442);
        f(443,444,476,443,444,476);
        f(476,475,443,476,475,443);
        f(444,445,477,444,445,477);
        f(477,476,444,477,476,444);
        f(445,446,478,445,446,478);
        f(478,477,445,478,477,445);
        f(446,447,479,446,447,479);
        f(479,478,446,479,478,446);
        f(447,416,448,447,416,448);
        f(448,479,447,448,479,447);
        this.geometry.ready = true;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

}
