/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3SNh
 */

package {
  import flash.display.Sprite;
  import flash.events.MouseEvent;
  import flash.text.TextField;
  import flash.text.TextFieldAutoSize;
  import flash.text.TextFormat;
  
  public class ch9ex3 extends Sprite {
    protected var labels:Vector.<TextField>;

    protected const DEFAULT_FORMAT:TextFormat
      = new TextFormat("_sans", 12, 0x000000, true);
    protected const SELECTED_FORMAT:TextFormat
      = new TextFormat("_sans", 12, 0x00ffff, true);
    protected const MARGIN:Number = 20;

    public function ch9ex3() {
      labels = new Vector.<TextField>;
      makeMenuItem("home");
      makeMenuItem("about");
      makeMenuItem("blog");
      makeMenuItem("contact");
    }
    
    protected function makeMenuItem(label:String):void {
      var tf:TextField = new TextField();
      tf.selectable = false;
      tf.defaultTextFormat = DEFAULT_FORMAT;
      tf.text = label;
      tf.width = tf.height = 0;
      tf.autoSize = TextFieldAutoSize.LEFT;
      if (labels.length > 0) {
        var lastTF:TextField = labels[labels.length-1];
        tf.x = lastTF.x + lastTF.textWidth + MARGIN; 
      }
      addChild(tf);
      labels.push(tf);
      tf.addEventListener(MouseEvent.CLICK, onItemClick);
    }
    
    protected function onItemClick(event:MouseEvent):void {
      for each (var tf:TextField in labels) {
        tf.setTextFormat((tf == event.target)? SELECTED_FORMAT:DEFAULT_FORMAT);
      }
    }
  }
}