/**
 * Copyright jules ( http://wonderfl.net/user/jules )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Rd8
 */

package {
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.display.Loader;
    import flash.events.*;
    import flash.net.URLRequest;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.utils.ByteArray;
    import flash.geom.Rectangle;
    import flash.events.MouseEvent;
    
    public class FlashTest extends Sprite {
        
       public var bitmapdata:BitmapData = new BitmapData(800,600, false, 0x000000);
       public var bitmap:Bitmap = new Bitmap(bitmapdata);
       public var canvas:BitmapData = Bitmap(addChild(bitmap)).bitmapData;
       public var mySpray:Spray = new Spray(canvas,0);
        
        public function FlashTest() {
            // write as3 code here..
            
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, startSpray);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, moveSpray);
            stage.addEventListener(MouseEvent.MOUSE_UP, stopSpray);

//addEventListener(MouseEvent.MOUSE_MOVE, test());
      //addEventListener(MouseEvent.CLICK, test());
        //canvas.addEventListener(MouseEvent.MOUSE_OVER, mouseOverHandler);
       
        }
        
   
        public function startSpray(event:MouseEvent):void{
            //test();
            mySpray.spray(mouseX,mouseY);
        }
        
        public function stopSpray(event:MouseEvent):void{
            //test();
            
        }
        
        public function moveSpray(event:MouseEvent):void{
            //test();
            mySpray.spray(mouseX,mouseY);
            
        }
        
        
        public function test() {
            for (var i:int = 0;i<50;i++) {
                mySpray.spray(50* i,40*i);
            }
        }
    }
}

      import flash.display.BitmapData;
	import flash.utils.ByteArray;
	import flash.geom.Rectangle;

	 class Spray {
		//constructor
		public function Spray(canvas:BitmapData,type:int) {

			class_canvas = canvas;
			if (type == 0) {				//dither
				sprayType = 0;
				trace("constructing dithering");
				myRandom = new Random();
			} else if (type == 1) {			//gaussian
				sprayType = 1;
				trace("constructing gaussian");
				generateKernel();
				brush = 1;
			}
		}
		//PROPERTIES***************************************************************/
		public var class_canvas:BitmapData;
		public var sprayType: int;
		//private var r_seed:int = 12345678;
		private var maxRadius:int = 25;
		private var density:int = 9;

		private var ditherColour:uint  = 0x99f00000;//red colour.0x55f00000 

		private var brush:int = 2;

		private var myRandom:Random;


		//-------------------Gaussian Properties-------------------//
		private var stDev:Number = 7;
		private var kernelSize:int = 51;
		private var kernelStart:int = 3;
		private var kernelFinish:int = -3;
		public var  kernel:Array;

		//Colour stuff
		private var a:uint = 0;
		private var r:uint = 0;
		private var g:uint = 0;
		private var b:uint = 0;

		private var a2:uint = 0;
		private var r2:uint = 0;
		private var g2:uint = 0;
		private var b2:uint = 0;

		private var currVal:uint;
		private var test:uint;


		private var kernelVal:Number;


		//END OF PROPERTIES***************************************************************/



		//METHODS
		public function setBrush(size:int):void {
			brush = size;
			trace("brush is now: " + brush);
		}

		public function spray(x:int,y:int):void {
			if (sprayType == 0) {
				ditherSpray(x,y);
			} else if (sprayType == 1) {
				gaussianSpray(x,y);
			}
		}//end spray funcrion


		public function ditherSpray(x:Number,y:Number):void {
			//taken from flash example on net, cant remember where
			for (var i:int = 0; i < density; i++) {
				var angle:Number = myRandom.uniform() * Math.PI * 2;
				var radius:Number = myRandom.uniform() * maxRadius;
				var x1:int = x + Math.cos(angle) * radius;
				var y1:int = y + Math.sin(angle) * radius;
				/*end flash ex*/

				paint(x1,y1,ditherColour);

			}//end for
		}
		public function paint(x,y,colour):void {
			//colour = colour+20;   uncomment this for changing colours
			for (var i:int = 0; i<brush; i++) {
				for (var j:int = 0; j<brush; j++) {
					class_canvas.setPixel32(x+i,y+j,colour);
				}
			}
		}
		//*****************************GAUSSIAN SPRAY METHODS******************************//
		public function gaussian(x:int,y:int):Number {
			var i:Number = (1 / (2 * Math.PI * Math.pow(stDev,2)));
			//=(1/(2*PI()*POWER(stdev,2)))
			var j:Number = Math.exp(- ((Math.pow(x,2) + Math.pow(y,2)) / (2 * Math.pow(stDev,2))));
			//=EXP(-((POWER(I20,2)+POWER(J20,2))/(2*POWER(stdev,2))))
			return i * j;
		}
		public function generateKernel():void {
			//generate a blank kernel
			trace("generating kernel");
			var i:Number;
			var j:Number;

			kernel = new Array(kernelSize);
			kernelStart = Math.floor(kernelSize/2);
			kernelFinish = - Math.floor(kernelSize/2);

			for (i=kernelStart; i >= kernelFinish; i--) {
				kernel[i] = new Array(kernelSize);
				for (j=kernelStart; j >= kernelFinish; j--) {
					kernel[i][j] = gaussian(Math.abs(i),Math.abs(j));
				}
			}
			var oldMax:Number = kernel[0][0];//centre of the kernel will be the max value
			var oldMin:Number = kernel[kernelStart][kernelStart];//top left of the kernel should always be the min value
			scaleKernel(oldMin,oldMax,0,255);
		}//end generateKernel function

		private function scaleKernel(oldMin:int,oldMax:int,newMin:int,newMax:int):void {
			var i:int;
			var j:int;
			trace("scaling kernel");
			//trace("kerne " + kernel[1][1]);
			for (i=kernelStart; i >= kernelFinish; i--) {
				for (j=kernelStart; j >= kernelFinish; j--) {
					kernel[i][j] = Math.round(((kernel[i][j] - oldMin) / oldMax)*50);
					//trace(kernel[i][j]);
				}
			}
		}
		public function gaussianSpray(x:int,y:int):void {
			//currVal  = 0x60FF00DD;
			//trace("stdev: " + stDev);
			for (var i:int=kernelStart; i >= kernelFinish; i--) {

				for (var j:int=kernelStart; j >= kernelFinish; j--) {
					currVal = class_canvas.getPixel32(x+i,y+j);
					//trace(currVal);
					var argb:Array = HexToARGB(currVal);
					kernelVal = kernel[i][j];
					r2 = addColour(argb[1],kernelVal);
					a2 = addAlpha(argb[0],kernelVal);
					//trace(r2);
					//test = ARGBToHex(argb[0],r2,argb[2],argb[3]);
					test = ARGBToHex(a2,r2,argb[2],argb[3]);
					
					paint(x+i,y+j,test);

				}
			}
		}//End gaussian spray method


		private function RGBToHex(r:uint, g:uint, b:uint):uint {
			var hex:uint = (r << 16 | g << 8 | b);
			return hex;
		}
		private function ARGBToHex(a:uint, r:uint, g:uint, b:uint):uint {
			var hex:uint = (a << 24 | r << 16 | g << 8 | b);
			return hex;
		}

		private function HexToRGB(hex:uint):Array {
			var rgb:Array = [];

			var r:uint = hex >> 16 & 0xFF;
			var g:uint = hex >> 8 & 0xFF;
			var b:uint = hex & 0xFF;

			rgb.push(r, g, b);
			return rgb;
		}
		
		
		//probably needs reference
		private function HexToARGB(hex:uint):Array {
			var argb:Array = [];

			var a:uint = hex >> 24 & 0xFF;
			var r:uint = hex >> 16 & 0xFF;
			var g:uint = hex >> 8 & 0xFF;
			var b:uint = hex & 0xFF;

			argb.push(a,r, g, b);
			return argb;
		}

		private function addAlpha(oldC:Number,newC:Number):Number {
			var temp:Number = oldC+newC;
			if (temp > 200) {
				return 200;
			} else {
				return temp;
			}
		}
		
		private function addColour(oldC:Number,newC:Number):Number {
			var temp:Number = oldC+newC;
			if (temp > 255) {
				return 255;
			} else {
				return temp;
			}
		}
		private function subtractColour(oldC:Number,newC:Number):Number {
			var temp:Number = oldC-newC;
			if (temp < 0) {
				return 0;
			} else {
				return temp;
			}
		}
		public function setstDev(newstDev:Number):void {
			stDev = newstDev;
			trace("stdev: "+ stDev);
		}
		public function setSize(newSize:int):void {
			kernelSize = newSize;
			trace("kernelSize: "+kernelSize);
		}
	}//end class
	
	class Random {
		//constructor
		//constructor takes a seed value or defaults to use 12345678 if constructor parameter is empty
		public function Random(seed:int = 12345678) {

			r_seed = seed;

		}
		//properties***************************************************************/
		public var r_seed:int;

		// Basic Lehmer generator - constants
		private var m:int = 2147483647;
		private var a:int = 48271;
		private var q:int = 44488;
		private var r:int = 3399;
//		private var r_seed:int = 12345678;

		
		

		//METHODS*******************************************/
		// Basic Lehmer generator - uniform[0,1]
		// For more information see Knuth, Vol. II.
		public function uniform():Number {
			var hi:int = r_seed / q;
			var lo:int  = r_seed - q * hi;
			var t:int = a * lo - r * hi;
			if (t > 0) {
				r_seed = t;
			} else {
				r_seed = t + m;

			}
			var returnValue:Number = r_seed / m;
			//trace("r_seed=" + r_seed + " m=" + m + " returnValue=" + returnValue);
			return returnValue;
		}
		
		public function test():void {
			trace("testing method in random class");
		}

	}//end class