/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3QVY
 */

// forked from hacker_7daxapax's Papervision3DTest03
//←↑→↓またはA、W、D、XボタンでSphereとConeオブジェクトを移動させます
//VボタンでY軸に沿ってカメラ視点を変更　Vボタンを押し続けると元の視点に戻ります
//Coneオブジェクトが紫色のクリスタルもどきに触れるとクリスタルが消えて100ポイント加算されます(クリスタル取得処理)
//クリスタルもどきを2つとも取得すると終了となりキー操作を受け付けなくなります

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.AntiAliasType;
 
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.objects.primitives.Cone;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.objects.primitives.Cylinder;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.WireframeMaterial;
    
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.render.BasicRenderEngine;
 
    [SWF(width="500", height="500", frameRate="60", backgroundColor="#0055ff")]
 
    public class CrystalGain extends Sprite
    {
        private var container    : Sprite;
        private var viewport     : Viewport3D;
        private var scene        : Scene3D;
        private var camera       : Camera3D;
        private var planeObj     : Plane; 
        private var coneObj      : Cone;
        private var sphereObj    : Sphere;
        private var crystal01    : Cylinder;
        private var crystal02    : Cylinder;
        private var renderer     : BasicRenderEngine;
        
        private var textarea : TextField; // テキスト表示部分
        private var planeSize : int = 1000; //Planeオブジェクト1辺の長さ
        private var score : int = 0; //スコア表示用
        private var keyFreeze : Boolean = false; //キー操作凍結を判定

        //CrystalGainクラスのコンストラクタ
        public function CrystalGain():void
        {          
            //ビューポート生成
            viewport = new Viewport3D(stage.stageWidth, stage.stageHeight);
            addChild(viewport);

            //シーン生成
            scene = new Scene3D();

            //レンダリングエンジン生成
            renderer = new BasicRenderEngine();

            //Planeオブジェクト生成
            planeObj= new Plane(new WireframeMaterial(0xffff00), planeSize, planeSize, 4, 4);
            planeObj.rotationX = 90;
            scene.addChild(planeObj);
            
            //Coneオブジェクト生成
            coneObj = new Cone(new ColorMaterial(0xff7700), 100, 150, 8, 6);
            coneObj.y = 100;
            coneObj.rotationX = 180;
            scene.addChild(coneObj);
            
            //Sphereオブジェクト生成
            sphereObj = new Sphere(new ColorMaterial(0xff0000), 65, 8, 6);
            sphereObj.y = 250;
            scene.addChild(sphereObj);
            
            //Cylinderオブジェクト生成(クリスタルもどき＊２)
            //右手奥配置クリスタルもどき
            crystal01 = new Cylinder(new ColorMaterial(0xff00ff),50,300);
            crystal01.x = 400;
            crystal01.z = 400;
            crystal01.y = 150;
            scene.addChild(crystal01);
            //左手手前配置クリスタルもどき
            crystal02 = new Cylinder(new ColorMaterial(0xff00ff),50,300);
            crystal02.x = -400;
            crystal02.z = -400;
            crystal02.y = 150;
            scene.addChild(crystal02);
            
            //カメラ設定
            camera = new Camera3D();
            camera.y = 300;
            camera.z = -1100; //カメラのz座標defaultは-1000？
 
            //情報表示用テキストエリアを設定
            setTestarea();
            showInfoText("Score: " + score + " points");
            
            //イベント処理用リスナを設定
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }

        //フレーム毎の処理
        private function onEnterFrame(e:Event):void{
            renderer.renderScene(scene, camera, viewport);
        }
        
        //キーボード入力処理
        //←↑→↓、A、W、D、Xボタン押下時処理(Cubeオブジェクト移動処理)
        //Vボタン押下時処理(カメラ視点変更処理)
        private function onKeyDown(event:KeyboardEvent):void{
            //「YOU CLEARED!!!」表示後はキー操作を受け付けない
            if (keyFreeze) {return;}
            
            //←ボタンまたはAボタン X軸移動　X座標値増加     
            if ((event.keyCode == 37) || (event.keyCode == 65)) {
                if (sphereObj.x > -450) {
                    sphereObj.x -= 5;
                    coneObj.x -= 5;
                    checkCrystalGain();
                }
            //→ボタンまたはDボタン X軸移動　X座標値減少
            } else if ((event.keyCode == 39) || (event.keyCode == 68)) {
                if (sphereObj.x < 450) {
                    sphereObj.x += 5;
                    coneObj.x += 5;
                    checkCrystalGain();
                }
            //↑ボタンまたはWボタン Z軸移動　Z座標値増加
            } else if ((event.keyCode == 38) || (event.keyCode == 87)) {
                if (sphereObj.z < 450) {
                    sphereObj.z += 5;
                    coneObj.z += 5;
                    checkCrystalGain();
                }
            //↓ボタンまたはXボタン Z軸移動　Z座標値減少
            } else if ((event.keyCode == 40) || (event.keyCode == 88)) {
                if (sphereObj.z > -450) {
                    sphereObj.z -= 5;
                    coneObj.z -= 5;
                    checkCrystalGain();
                }
            //Vボタン　カメラY軸座標視点変更
            } else if (event.keyCode == 86) {
                camera.y += 100;
                if (camera.y > 400) {camera.y = 0;}
            } 
        }
        
        //クリスタルもどきを取得したか(=円錐部分がクリスタルもどきに触れたか)判定
        private function checkCrystalGain():void{
            //右手奥配置クリスタルもどきに触れたか判定
            //クリスタルもどき表示中かつ触れた場合に、クリスタルもどきを消す(表示を停止)
            if(crystal01.visible && coneObj.hitTestObject(crystal01)) {
                crystal01.visible = false;
                score += 100;
                showInfoText("Score: " + score + " points");
            }
            //左手手前配置クリスタルもどきに触れたか判定
            //クリスタルもどき表示中かつ触れた場合に、クリスタルもどきを消す(表示を停止)
            if(crystal02.visible && coneObj.hitTestObject(crystal02)) {
                crystal02.visible = false;
                score += 100;
                showInfoText("Score: " + score + " points");
            }
            
            //クリスタルもどきが2つとも消された場合の処理
            if(!crystal01.visible && !crystal02.visible) {
                appendText("YOU CLEARED!!!");
                //キー操作を受け付けなくする
                keyFreeze = true;
            }
        }
        
        //情報表示用テキストエリアを設定
        private function setTestarea():void
        {
            var txtFmt:TextFormat = new TextFormat();
            txtFmt.font  = 'Courier New'; // 等幅フォント
            txtFmt.color = '0xFFFFFF';
            txtFmt.size  = 15;

            textarea = new TextField();
            textarea.defaultTextFormat = txtFmt;
            textarea.height = 200;
            textarea.width = 450;
            textarea.multiline = true;
            textarea.antiAliasType = AntiAliasType.ADVANCED;

            addChild(textarea);
        }
        
        //テキストエリアを新しいテキストで置き換え
        private function showInfoText(text:String):void {
            textarea.replaceText(0, textarea.length, text);
        }

        //テキストエリアにすでにあるテキストに新しいテキストを連結する
        private function appendText(text:String):void {
            textarea.replaceText(0, 0, text + "\n");
        }                
    }
}
