/**
 * Copyright hacker_rs10vazy ( http://wonderfl.net/user/hacker_rs10vazy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3QAM
 */

// forked from yd_niku's forked from: Tiling Algorythm
// forked from yd_niku's Tiling Algorythm
package {
    import flash.utils.Timer;
    import flash.display.Sprite;
    import flash.events.*;
    import flash.geom.Rectangle;
    public class FlashTest extends Sprite {
        private var _nodes:Array = [];
        private var _queue:Array = [];
        
        private var _timer:Timer;
        
        private var _lim:Number = 1;
        private var _tileW:Number = 20;
        private var _tileH:Number = 20;
        private var limit:Number = 300;
        
        public function FlashTest() {
            separate(new Node(0,0,_tileW,_tileH));
            
            _timer = new Timer(20);
            _timer.addEventListener(TimerEvent.TIMER, loop);
            _timer.start();
        }
        
        private function loop(e:Event):void {
            if(_queue.length<limit+1) {
                var n:Node = _queue.shift();
                drawNode(n, 0x00, (n.size.length/10)*0xff<<16);
            }
            if(_nodes.length<limit+1) {
                n = _nodes.shift();
               separate(n);
            }
        }
        
        public function drawNode(n:Node, color:uint=0xFF0000, fill:uint = 0):void {
            graphics.lineStyle(0,color);
            if(!isNaN(fill) && fill!=0) graphics.beginFill(fill);
            var scale:Number = 465/_tileW;
            trace(n.width + " -width");
            graphics.drawRect(n.x* scale, n.y* scale, Math.max(1,n.width)* scale, Math.max(1,n.height)* scale);
            graphics.endFill();
        }
        public function addNode(n:Node):void {
            if(n.width<_lim||n.height<_lim) return;
            
            //drawNode(n, 0x99ff99);
            _nodes.push(n);
        }
        public function addQueue(n:Node):void {
            _queue.push(n);
        }
        
        
        public function separate(n:Node):void {
            var partA_height:int = Math.floor((Math.random()*0.2+0.4)*n.height),
                partB_height:int = n.height-partA_height;
            var partA_width:int = Math.floor((Math.random()*0.2+0.4)*n.width),
                partB_width:int = n.width-partA_width;
                
            if( partA_height<partB_height ) {
                if( partA_width<partB_width) {
                    addQueue(new Node(
                        n.x, n.y,
                        partA_width, partA_height
                        ) );
                    addNode(new Node(
                        n.x+partA_width, n.y,
                        partB_width, partA_height
                        ) );
                }
                else {
                    addQueue(new Node(
                        n.x+partA_width, n.y,
                        partB_width, partA_height
                        ) );
                    addNode(new Node(
                        n.x, n.y,
                        partA_width, partA_height
                        ) );
                }
                addNode(new Node(
                    n.x, n.y+partA_height,
                    n.width, partB_height
                    ) );
            }
            else {
                if( partA_width<partB_width) {
                    addQueue(new Node(
                        n.x, n.y+partA_height,
                        partA_width, partB_height
                        ) );
                    addNode(new Node(
                        n.x+partA_width, n.y+partA_height,
                        partB_width, partB_height
                        ) );
                }
                else {
                    addQueue(new Node(
                        n.x+partA_width, n.y+partA_height,
                        partB_width, partB_height
                        ) );
                    addNode(new Node(
                        n.x, n.y+partA_height,
                        partA_width, partB_height
                        ) );
                }
                addNode(new Node(
                    n.x, n.y,
                    n.width, partA_height
                    ) );
            }
        }
        
    }
}
import flash.geom.Rectangle;

class Node extends Rectangle {
    public function Node(x:Number,y:Number,w:Number,h:Number):void {
        super(x,y,w,h)
    }
}