/**
 * Copyright wetcradle ( http://wonderfl.net/user/wetcradle )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Q7h
 */

/**
Mac OS Xでよく見かけるバッジを真似してみました。
黒い長方形の上でマウスを動かしてみて下さい。
*/

package {
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	public class IconBadgeTest extends Sprite {
		private var iconBadge:IconBadge;
		private var rect:Sprite;
		public function IconBadgeTest():void {
			//バッジの作成
			iconBadge = new IconBadge();
			iconBadge.x = iconBadge.y = 10;
			addChild(iconBadge);
			//rectの作成
			rect = new Sprite();
			rect.graphics.beginFill(0x000000);
			rect.graphics.drawRect(0, 0, 400, 50);
			rect.graphics.endFill();
			rect.y = 100;
			rect.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
			addChild(rect);
		}
		private function mouseMoveHandler(e:MouseEvent):void {
			iconBadge.count = Math.pow(e.localX/10, 3);
		}
	}
}

import flash.display.BitmapData;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.display.Sprite;
import flash.events.Event;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;

class IconBadge extends Sprite {
	
	private var _count:int = 0;
	private var badgeCanvas:Sprite;
	private var badge:Loader;
	private var badgeLeft:Loader;
	private var badgeCenter:Loader;
	private var badgeRight:Loader;
	private var textField:TextField;
	private var centerBitmapData:BitmapData;
	
	private const BADGE_BASE64:String = "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";		
	private const BADGE_LEFT_BASE64:String = "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";
	private const BADGE_CENTER_BASE64:String = "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";
	private const BADGE_RIGHT_BASE64:String = "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";
	
	private const MARGIN:Number = 12;
	
	////////////////////////////////////////////////////////////
	//////////////コンストラクタ
	////////////////////////////////////////////////////////////
	
	public function IconBadge():void {
		super();
		
		badgeCanvas = new Sprite();
		addChild(badgeCanvas);
		
		var textFormat:TextFormat = new TextFormat("Helvetica", 25, 0xffffff, true);
		textField = new TextField();
		textField.defaultTextFormat = textFormat;
		textField.autoSize = TextFieldAutoSize.LEFT;
		textField.selectable = false;
		textField.y = 12;
		textField.width = textField.height = 0;
		addChild(textField);
		
		badge = Base64ImageLoader.load(BADGE_BASE64);
		badgeLeft = Base64ImageLoader.load(BADGE_LEFT_BASE64);
		badgeCenter = Base64ImageLoader.load(BADGE_CENTER_BASE64);
		badgeRight = Base64ImageLoader.load(BADGE_RIGHT_BASE64);
		
		badge.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
		badgeLeft.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
		badgeCenter.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
		badgeRight.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
	}
	
	////////////////////////////////////////////////////////////
	//////////////プロパティ
	////////////////////////////////////////////////////////////
	
	//______________ count ______________//
	public function get count():int {
		return _count;
	}
	public function set count(value:int):void {
		if (value == _count) {
			return;
		}
		_count = value;
		refreshCount();
	}
	
	////////////////////////////////////////////////////////////
	//////////////メソッド
	////////////////////////////////////////////////////////////
	
	//______________ refreshCount ______________//
	private function refreshCount():void {
		if (!centerBitmapData) {
			return;
		}
		var prevTextWidth:Number = textField.textWidth;
		textField.text = String(Math.max(0, _count));
		if (textField.textWidth == prevTextWidth) {
			return;
		}
		badgeCanvas.graphics.clear();
		while (badgeCanvas.numChildren) {
			badgeCanvas.removeChildAt(0);
		}
		var minWidth:Number = textField.textWidth + MARGIN * 2;
		if (_count < 100) {
			badgeCanvas.addChild(badge);
			textField.x = (badge.width - textField.textWidth) / 2 - 3;
		}
		else if (minWidth <= badgeLeft.width + badgeRight.width) {
			badgeRight.x = badgeLeft.width;
			badgeCanvas.addChild(badgeLeft);
			badgeCanvas.addChild(badgeRight);
			textField.x = (badgeLeft.width + badgeRight.width - textField.textWidth) / 2 - 3;
		}
		else {
			var centerCount:int = Math.ceil((minWidth - badgeLeft.width - badgeRight.width) / badgeCenter.width);
			badgeCanvas.graphics.beginBitmapFill(centerBitmapData);
			badgeCanvas.graphics.drawRect(badgeLeft.width, 0, badgeCenter.width * centerCount, badgeCenter.height);
			badgeCanvas.graphics.endFill();
			badgeRight.x = badgeLeft.width + badgeCenter.width * centerCount;
			badgeCanvas.addChild(badgeLeft);
			badgeCanvas.addChild(badgeRight);
			textField.x = (badgeLeft.width + badgeCenter.width * centerCount + badgeRight.width - textField.textWidth) / 2 - 3;
		}
	}
	
	////////////////////////////////////////////////////////////
	//////////////イベントハンドラ
	////////////////////////////////////////////////////////////
	
	//______________ completeHandler ______________//
	private function completeHandler(e:Event):void {
		e.currentTarget.removeEventListener(Event.COMPLETE, completeHandler);
		if (badge.content && badgeLeft.content && badgeCenter.content && badgeRight.content) {
			centerBitmapData = new BitmapData(badgeCenter.width, badgeCenter.height);
			centerBitmapData.draw(badgeCenter);
			refreshCount();
		}
	}
	
}

import flash.display.DisplayObjectContainer;
import flash.display.Loader;
import flash.utils.ByteArray;
import mx.utils.Base64Decoder;
class Base64ImageLoader {
	static public function load(data:String):Loader {
		var byteArray:ByteArray;
		var base64Decoder:Base64Decoder = new Base64Decoder();
		base64Decoder.decode(data);
		try {
			byteArray = base64Decoder.toByteArray();
			byteArray.position = 0;
		}
		catch (e:Error) {
			return null;
		}
		var loader:Loader = new Loader();
		loader.loadBytes(byteArray);
		return loader;
	}
}
