/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3PpK
 */

package
{
	import Box2D.Dynamics.Joints.b2DistanceJointDef;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import Box2D.Dynamics.b2World;
	import Box2D.Dynamics.b2DebugDraw;
	import Box2D.Collision.b2AABB;
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Dynamics.b2Body;
 
	[SWF(backgroundColor="0x414647")]
	public class Main extends Sprite
	{
		private var world:b2World;
		private var scale:Number = 10;
 
		public function Main()
		{
			var worldAABB:b2AABB = new b2AABB();
			worldAABB.lowerBound.Set(-100, -100);
			worldAABB.upperBound.Set(stage.stageWidth + 100, stage.stageHeight + 100);
 
			var gravity:b2Vec2 = new b2Vec2(0, 5);
			world = new b2World(worldAABB, gravity, true);
 
			var draw:b2DebugDraw = new b2DebugDraw();
			draw.m_sprite = this;
			draw.m_drawScale = scale;
			draw.m_drawFlags = b2DebugDraw.e_shapeBit | b2DebugDraw.e_jointBit;
			world.SetDebugDraw(draw);
			
			Shape.world = world;
			Shape.scale = scale;
			Shape.create( { shape:Shape.RECT, x:0, y:465, width:465, height:1 } );
			
			var bodyA:b2Body = Shape.create( { shape:Shape.CIRCLE, x:200, y:200, radius:10, density:10, restitution:0.5 } );
			var bodyB:b2Body = Shape.create( { shape:Shape.CIRCLE, x:300, y:200, radius:10, density:10, restitution:0.8 } );
			
			var joint:b2DistanceJointDef = new b2DistanceJointDef();
			joint.Initialize(bodyA, bodyB, bodyA.GetWorldCenter(), bodyB.GetWorldCenter());
			world.CreateJoint(joint);
 
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		private function onEnterFrame(event:Event):void 
		{
			world.Step(1 / stage.frameRate, 10);
		}
	}
}
 
import Box2D.Collision.Shapes.b2CircleDef;
import Box2D.Collision.Shapes.b2PolygonDef;
import Box2D.Collision.Shapes.b2ShapeDef;
import Box2D.Common.Math.b2Vec2;
import Box2D.Dynamics.b2Body;
import Box2D.Dynamics.b2BodyDef;
import Box2D.Dynamics.b2World;
 
class Shape
{
	public static const CIRCLE:int = 0;
	public static const RECT:int = 1;
 
	public static var world:b2World;
	public static var scale:Number;
 
	public static function addVec2(body:b2Body, x:Number, y:Number):void
	{
		body.SetXForm(new b2Vec2(body.GetPosition().x + x / scale, body.GetPosition().y + y / scale), body.GetAngle());
	}
 
	public static function setVec2(body:b2Body, x:Number, y:Number):void
	{
		body.SetXForm(new b2Vec2(x / scale, y / scale), body.GetAngle());
	}
 
	public static function addAngle(body:b2Body, rotate:Number):void
	{
		body.SetXForm(body.GetPosition(), body.GetAngle() + rotate * Math.PI / 180);
	}
 
	public static function setAngle(body:b2Body, rotate:Number):void
	{
		body.SetXForm(body.GetPosition(), rotate * Math.PI / 180);
	}
 
	public static function create(params:Object):b2Body
	{
		var def:b2BodyDef = new b2BodyDef();
		if (params.angle) def.angle = params.angle * Math.PI / 180;
 
		var shape:b2ShapeDef;
		if (params.shape == Shape.RECT)
		{
			def.position.Set((params.x + params.width / 2) / scale, (params.y + params.height / 2) / scale);
			shape = new b2PolygonDef();
			b2PolygonDef(shape).SetAsBox(params.width / 2 / scale, params.height / 2 / scale);
		}
		else if (params.shape == Shape.CIRCLE)
		{
			def.position.Set(params.x / scale, params.y / scale);
			shape = new b2CircleDef();
			b2CircleDef(shape).radius = params.radius / scale;
		}
 
		shape.density = params.density;
		shape.restitution = params.restitution;
 
		var body:b2Body = world.CreateBody(def);
		body.CreateShape(shape);
 
		if (shape.density > 0) body.SetMassFromShapes();
 
		return body;
	}
}