/**
 * Copyright codeonwort ( http://wonderfl.net/user/codeonwort )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3P8J
 */

// forked from codeonwort's forked from: transition
// forked from Nyarineko's transition
package {
    
    import flash.geom.Vector3D
    import flash.geom.Point;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.display.Graphics;
    import flash.filters.BlurFilter
    
    [SWF(width = "465", height = "465", backgroundColor = "0xffffff", frameRate = "60")]
    
    public class Main extends Sprite {
        
        private const M_WIDTH:Number = 465;
        private const M_HEIGH:Number = 465;
        private const OX:Number = 465 / 2;
        private const OY:Number = 465 / 2;
        private const V:Number = 1
        private const OBJ_MAX:Number = 60;
        private var max:uint = 20;
        private var amax:uint = 0;
        private var _canvas:BitmapData
        private var dst:BitmapData
        private var _bmp:Bitmap;
        private var first:Particle;
        
        //------------------------------------------------------
        //コンストラクタ
        //------------------------------------------------------
        public function Main() {
            graphics.beginFill(0)
            graphics.drawRect(0, 0, M_WIDTH, M_HEIGH)
            graphics.endFill()
            
            _canvas = new BitmapData(M_WIDTH, M_HEIGH, true, 0xffffff);
            dst = _canvas.clone()
            _bmp = new Bitmap(dst);
            _bmp.smoothing = true;
            addChild(_bmp)
            
            Particle.originX = OX, Particle.originY = OY
            init();
            stage.addEventListener(MouseEvent.CLICK,onClick);
            stage.addEventListener(Event.ENTER_FRAME,enterframeHandler);
        }
        
        //------------------------------------------------------
        //初期化
        //------------------------------------------------------
        private function init():void {
            first = new Particle
            var p:Particle = first;
            for(var i:uint = 0;i < max;i++){
                p.phi = 360 * i / max
                p.theta = Math.random() * 180 //180 * i / max
                p.phiVel = 1
                p.radius = 1
                p.thetaVel = 0
                if(i != max - 1){
                    p.next = new Particle
                    p = p.next;
                }
            }
        }
        
        private var zero:Point = new Point
        private var blur:BlurFilter = new BlurFilter(8, 8)
        private function enterframeHandler(e:Event):void {
            update();
            dst.copyPixels(_canvas, _canvas.rect, zero)
            //var temp:BitmapData = _canvas.clone()
            //temp.applyFilter(dst, dst.rect, zero, blur)
            //dst.draw(temp, null, null, "add")
            //dst.draw(temp, null, null, "add")
            //temp.dispose()
        }
        
        private function onClick(e:MouseEvent):void {
            _canvas.lock();
            _canvas.fillRect(_canvas.rect, 0xFFFFFF);
            _canvas.unlock();
            init();
        }
        
        private function update():void {
            var sh:Shape = new Shape();
            var g:Graphics = sh.graphics;
            var ran:Number;
            var p:Particle = first;
            var cnt:uint = 0;
            
            var zRate:Number, pos:Vector3D
            
            _canvas.lock();
            while(p){
                pos = p.position
                zRate = (pos.z + p.radius) / (p.radius + p.radius)
                g.lineStyle(1+zRate, 0xffffff, (1-zRate)*0.5);
                cnt++;
                if(p.radius > 400){
                    p = p.next;
                    continue;
                }
                ran =  Math.random();
                if(ran < 0.1){
                    p.phiVel = p.thetaVel = 0;
                    p.radVel = V;
                }else if(ran < 0.2){
                    p.phiVel = -V;
                    p.radVel = p.thetaVel = 0;
                }else if(ran < 0.3){
                    p.phiVel = V;
                    p.radVel = p.thetaVel = 0;
                }else if(ran < 0.4){
                    p.thetaVel = V
                    p.phiVel = p.radVel = 0
                }else if(ran < 0.5){
                    p.thetaVel = -V
                    p.phiVel = p.radVel = 0
                }else if(ran < 0.504 && amax < OBJ_MAX){
                    var newP:Particle = new Particle();
                    newP.phi = p.phi
                    newP.theta = p.theta
                    newP.radius = p.radius
                    if(p.phiVel == 0){
                        newP.phiVel = 0
                        newP.radVel = 1
                    }else{
                        newP.phiVel = Math.random() < 0.5 ? -1 : 1
                        newP.radVel = 0
                    }
                    newP.next = p.next;
                    p.next = newP;
                }
                g.moveTo(pos.x, pos.y)
                p.radius += p.radVel
                p.phi += p.phiVel
                p.theta += p.thetaVel
                pos = p.position
                g.lineTo(pos.x, pos.y)
                p = p.next;
            }
            
            _canvas.draw(sh);
            g = null;
            sh = null;
            _canvas.unlock();
            amax = cnt;
        }
    }
}

import flash.geom.Vector3D
internal class Particle {
    
    public static var originX:Number, originY:Number
    
    private static const K:Number = Math.PI / 180
    private static const Kinv:Number = 180 / Math.PI
    
    private var _theta:Number = 0
    private var _phi:Number = 0
    public var radius:Number = 0
    public var thetaVel:Number = 0, phiVel:Number = 0, radVel:Number = 0
    
    public var next:Particle
    
    public function get position():Vector3D {
        var v:Vector3D = new Vector3D
        v.x = radius * Math.cos(_phi) * Math.cos(_theta)
        v.y = radius * Math.sin(_phi)
        v.z = radius * Math.cos(_phi) * Math.sin(_theta)
        v.x += originX, v.y += originY
        return v
    }
    
    public function get phi():Number { return _phi * Kinv }
    public function set phi(v:Number):void { _phi = v * K }
    
    public function get theta():Number { return _theta * Kinv }
    public function set theta(v:Number):void { _theta = v * K }

}