/**
 * Copyright Cheshir ( http://wonderfl.net/user/Cheshir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3OZp
 */

package {
    import flash.geom.Point;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            var world:ColideWorld = new ColideWorld();
            world.addPlane(new Point(20, 80), new Point(200, 150));
            world.addSphere(new Point(30, 30));
            addChild(world);
        }
    }
}
import flash.text.TextField;
import flash.events.Event;
import flash.display.Sprite;
import flash.geom.Point;

Class {
    class ColideWorld extends Sprite {
        private var planes:Array = [];
        private var objects:Array = [];
        private var tf:TextField;
        private var redraw:Sprite = new Sprite();
        public function ColideWorld():void {
            addChild(redraw);
            tf = new TextField();
            tf.autoSize = 'left';
            addChild(tf);
            addEventListener(Event.ENTER_FRAME, updateWorld);
        }
        private function updateWorld(e:Event):void {
            redraw.graphics.clear();
            for(var i:int=0; i<objects.length; i++){
                objects[i].center.y++;
                redraw.graphics.lineStyle(1);
                redraw.graphics.drawCircle(objects[i].center.x, objects[i].center.y, objects[i].radius);
                // Проверка на столкновение со всем линиями?
                // Дистанция от точки до прямой ага...
                tf.text = 'a='+planes[0].a +' b='+planes[0].b+' c='+planes[0].c+'\n';
                tf.appendText( point2plane(objects[0].center.x, objects[0].center.y, planes[0]).toString());
                for(var line:int=0; line<planes.length; line++){
                    if(point2plane(objects[i].center.x, objects[i].center.y, planes[line])<objects[i].rad){
                        redraw.graphics.clear();
                        redraw.graphics.lineStyle(1, 0xff0000);
                        redraw.graphics.drawCircle(objects[i].center.x, objects[i].center.y, objects[i].radius);
                    }
                }
            }
        }
        public function point2plane(x:Number, y:Number, plane:Plane):Number {    // distance from a point to a line
            return (plane.a*x + plane.b*y + plane.c)/Math.sqrt(plane.a*plane.a+plane.b*plane.b);
        }
        public function addSphere(spTo:Point, rad:Number=10):void {
            var sphere1:Sphere = new Sphere(spTo, rad);
            objects.push(sphere1);
        }
        public function addPlane(moveTo:Point, lineTo:Point):void {
            var plane1:Plane = new Plane(moveTo, lineTo);
            this.graphics.lineStyle(1);
            this.graphics.moveTo(plane1.p1.x, plane1.p1.y);
            this.graphics.lineTo(plane1.p2.x, plane1.p2.y);
            planes.push(plane1);
        }
    }
    
    class Sphere {
        public var center:Point;
        public var radius:Number;
        public function Sphere(center:Point, rad:Number) {
            this.center = center;
            this.radius = rad;
        }
    }

    class Plane {
        public var p1:Point;
        public var p2:Point;
        public var a:Number;
        public var b:Number;
        public var c:Number;
        public function Plane(p1:Point, p2:Point) {
            this.p1 = p1;
            this.p2 = p2;
            // (y2-y1)*(x-x1) - (x2-x1)*(y-y1) = 0; //a*x + b*y + c = 0;
            this.a = (p2.y-p1.y);
            this.b = (p2.x-p1.x);
            this.c = (p2.y-p1.y)*(-p1.x) - (p2.x-p1.x)*(-p1.y);
        }
    }
}
