/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3OAk
 */






package 
{
    import flash.text.TextFormat;
    import flash.display.Shape;
    import flash.events.KeyboardEvent;
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.ui.Keyboard
    
    [SWF( backgroundColor=0x000000 )]
    
    
    public class FlashTest extends Sprite 
    {        
        private var input:TextField
        private var ten:LCD, one:LCD, sign:LCD
        
        public function FlashTest() 
        {
            input = new TextField
            input.border = true
            input.borderColor = 0xffffff
            input.background = true
            input.backgroundColor = 0xffffff
            input.defaultTextFormat = new TextFormat(null, 26)
            input.type = "input"
            //input.autoSize = "left"
            input.width = 400
            input.height = 40
            input.multiline = false
            input.maxChars = 15
            addChild(input)
            
            with(addChild(sign = new LCD))
            {
                x = 30
                y = 150
            }
            
            with(addChild(ten = new LCD))
            {
                x = 150
                y = 150
            }
            with(addChild(one = new LCD))
            {
                x = 270
                y = 150
            }
            
            sign.drawSign("0")
            ten.drawNumber("0000000")
            one.drawNumber("0000000")
            
            stage.addEventListener("keyDown", kd)
        }
        
        private function kd(e:KeyboardEvent):void {
            if(e.keyCode == Keyboard.ENTER){
                draw(input.text)
            }
        }
        
        private function draw(code:String):void {
            var sgn:String = code.charAt(0)
            var a:String = code.substr(1, 7)
            var b:String = code.substr(8, 7)
            
            sign.drawSign(sgn)
            ten.drawNumber(a)
            one.drawNumber(b)
        }

    }
    
}

import flash.display.Shape
internal class LCD extends Shape 
{
    private static const w:Number = 80, h:Number = 140
    public function drawNumber(code:String):void 
    {
       // code.length = 7
       graphics.clear()
       line(code, 0, 0,0, w,0)
       line(code, 1, w,0, w,h/2)
       line(code, 2, w,h/2, w,h)
       line(code, 3, 0,h, w,h)
       line(code, 4, 0,h, 0,h/2)
       line(code, 5, 0,0, 0,h/2)
       line(code, 6, 0,h/2, w,h/2)
    }
    
    public function drawSign(code:String):void {
        graphics.clear()
        line(code, 0, 0,h/2, w,h/2)
    }
    
    private function line(code:String, comp:uint, x0:Number,y0:Number, x1:Number,y1:Number):void 
    {
        var light:Boolean = code.charAt(comp) == "1"
        graphics.lineStyle(10, light ? 0xff0000 : 0xcccccc, light ? .5 : 0.5)
        graphics.moveTo(x0, y0)
        graphics.lineTo(x1, y1)
    }
}
/*
import flash.display.* 
import flash.geom.* 
class moveTo3D extends Sprite implements
{
    
}    
    


*/