/**
 * Copyright paq ( http://wonderfl.net/user/paq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3NzN
 */

package 
{
	import com.adobe.serialization.json.JSON;
	import com.bit101.components.InputText;
	import com.bit101.components.Label;
	import com.bit101.components.PushButton;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.ProgressEvent;
	import flash.net.Socket;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import mx.utils.Base64Encoder;
	
	/**
	 * @author paq
	 */
	[SWF(width=465, height=465, backgroundColor=0xFFFFFF, frameRate=24)]
	public class Main extends Sprite 
	{
		public function Main():void 
		{
			__init(); 
		}
		
		private var _socket:Socket;	
		private var _textfield:TextField;
		private var _inputUser:InputText;
		private var _inputPass:InputText;
		private var _buttonConnect:PushButton;
		
		private function __init():void 
		{
			__initSocket();
			__initTextField();
			__initInput();
		}
		private function __initSocket():void
		{
			_socket = new Socket();
			_socket.addEventListener(Event.CONNECT, __socket_connect__);
			_socket.addEventListener(ProgressEvent.SOCKET_DATA, __socket_data__);
		}
		
		private function __initTextField():void
		{
			_textfield = new TextField();
			_textfield.x = 12;
			_textfield.y = 64;
			_textfield.width = 441;
			_textfield.height = 401;
			_textfield.wordWrap = true;
			_textfield.defaultTextFormat = new TextFormat("", 10, 0x2E2E2E);
			addChild(_textfield);
		}
		
		private function __initInput():void
		{
			new Label(this, 12, 9, "username:");
			new Label(this, 12, 33, "password:");
			
			_inputUser = new InputText(this, 64, 12);
			_inputPass = new InputText(this, 64, 36);
			
			_buttonConnect = new PushButton(this, 176, 12, "connect");
			_buttonConnect.height = 40;
			_buttonConnect.addEventListener(MouseEvent.CLICK, __buttonConnect_click__);
		}
		
		private function __buttonConnect_click__(e:MouseEvent):void 
		{
			_socket.connect("chirpstream.twitter.com", 80);
		}
		
		private function __socket_connect__(e:Event):void 
		{
			var encoder:Base64Encoder = new Base64Encoder();
			encoder.encode(_inputUser.text + ":" + _inputPass.text);
			
			_socket.writeUTFBytes("GET /2b/user.json HTTP/1.1\r\n");
			_socket.writeUTFBytes("Host: chirpstream.twitter.com\r\n");
			_socket.writeUTFBytes("Authorization: Basic " + encoder.toString() + "\r\n");
			_socket.writeUTFBytes("\r\n");
			_socket.flush();
		}
		
		private function __socket_data__(e:ProgressEvent):void 
		{
			var text:String = _socket.readUTFBytes(_socket.bytesAvailable);
			for (var i:int = 0; i < 10; i++) 
			{
				if (text.charAt(i) == "{")
				{
					var result:Object = JSON.decode(text.substr(i));
					if (result && result.hasOwnProperty("user"))
					{
						_textfield.text = (result.user.screen_name + "\t:" + result.text + "\n\n") + _textfield.text;
					}
					break;
				}
			}
		}
	}
	
}