/**
 * Copyright rooooon ( http://wonderfl.net/user/rooooon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3NuE
 */

// forked from rooooon's flash on 2009-7-7
package {
	
	import flash.display.Sprite;
	import flash.geom.Matrix3D;
	import flash.events.Event;
	
	public class TestMatrix extends Sprite {
		
		private var box:Sprite;
		private var mat:Matrix3D = new Matrix3D();
		private var nowVe:Vector.<Number> = new Vector.<Number>(16);
		
		public function TestMatrix() {
			
			box = new Sprite();
			box.graphics.beginFill( 0x00ff00 );
			box.graphics.drawRect( -50, -50, 100, 100 );
			box.graphics.endFill();
			addChild( box );
			
			box.x = stage.stageWidth/2;
			box.y = stage.stageHeight/2;
			
			box.transform.matrix3D = mat;
			
			addEventListener( Event.ENTER_FRAME, onEnter );
			
		}
		
		private function onEnter( e:Event ):void {
			
			nowVe = box.transform.matrix3D.rawData;
			
			var v:Vector.<Number> = Vector.<Number>([
				1, 0, 0, 0,
				0, 1, 0, 0,
				0, 0, 1, 0,
				mouseX, mouseY, 0, 1
			]);
			for( var i:uint = 0; i < 16; i++ ){
				nowVe[i] += ( v[i] - nowVe[i] ) * 0.2;
			}
			
			box.transform.matrix3D.rawData = nowVe;
		}
		
	}
}