/**
 * Copyright MixedMilkChOcOlate ( http://wonderfl.net/user/MixedMilkChOcOlate )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3NEz
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.Point;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.primitives.Cube;
    
    
    [SWF(frameRate="30", backgroundColor="#FFFFFF", width='550', height='500')]

    public class Main extends MovieClip
    {
	private var _p_world:PaperWorld;
	private var _p_world_w_min:int = -550;
	private var _p_world_w_max:int = 550;
	private var _p_world_h_min:int = -500;
	private var _p_world_h_max:int = 500;
	private var cpt:int = 0;
		
	//filters
        private var bmd:BitmapData = new BitmapData(550, 500, true, 0x00000);
        private var bm:Bitmap = new Bitmap (bmd);
        private var bf:BlurFilter;
        private var cmf:ColorMatrixFilter;
		
	public function Main() 
	{
		this.addEventListener(Event.ENTER_FRAME, new_enter_frame);
		
                bf = new BlurFilter (8, 8, 1)
                cmf = new ColorMatrixFilter ([1, 0, 0, 0, 0,            // red
                                              0, 1, 0, 0, 0,            // green
                                              0, 0, 1, 0, 0,            // blue
                                              0, 0, 0, 0.5, 0,]);       // alpha
		// appel de la classe qui creer un environement papervision
		_p_world = new PaperWorld(_p_world_w_max, _p_world_h_max);
		this.addChild(bm);
		this.addChild(_p_world);
	}
	
	private function new_enter_frame(e:Event):void 
	{
		// apply filters
		bmd.draw(this);
		bmd.applyFilter(bmd, bmd.rect, new Point (0, 0), bf);
		bmd.applyFilter(bmd, bmd.rect, new Point (0, 0), cmf);
		bmd.scroll(0, -5); // effect goes to top
	    cpt++;
		for (var i:int = 0 ; i < _p_world.tabCubes.length ; i++) {
        		var c:Cube = _p_world.tabCubes[i];
			
			var randomMoveX:int;
			var randomMoveY:int;
			var randomMoveZ:int;
			if (c.y > 0) {
				randomMoveY = Math.random() * 30 + 20;
			}else if (c.y < 0) {
				randomMoveY = Math.random() * -30 - 20;
			}else {
				randomMoveY = Math.random() * 100 - 50;
			}
			if (c.x > 0) {
				randomMoveX = Math.random() * 30 + 20;
			}else if (c.x < 0) {
				randomMoveX = Math.random() * -30 - 20;
			}else {
				randomMoveX = Math.random() * 100 - 50;
			}
			if (c.z > 0) {
				randomMoveX = Math.random() * 30 + 20;
			}else if (c.z < 0) {
				randomMoveZ = Math.random() * -30 - 20;
			}else {
				randomMoveZ = Math.random() * 100 - 50;
			}
			c.y += randomMoveY;
			c.x += randomMoveX;
			c.x += randomMoveZ;
			
			var randomRotate:int
			if(c.rotationX == 0) {
				randomRotate = Math.random() * 40 - 20;
			}else {
				randomRotate += 10;
			}
			c.rotationZ += randomMoveZ;
			c.rotationY += randomMoveY;
			c.rotationX += randomMoveX;
		    }
		
		    if (cpt > 30) {
			_p_world.removeMaterial(_p_world.tabCubes[0], "CUBE");
		    }
		
		    var randomMoveSize:int = Math.random() * 100 + 50;
		    var randomMoveH:int = Math.random() * 100 + 50;
		    _p_world.addCube([0x232323, 0x3a3a3a, 0x565656, 0x6f6f6f, 0x878686], randomMoveSize, randomMoveSize, randomMoveSize, 8, 8, 8);
        	}
	}
}

import flash.display.DisplayObject;
import flash.display.MovieClip;
import flash.display.Sprite;
import flash.events.Event;
import org.papervision3d.cameras.Camera3D;
import org.papervision3d.core.geom.Lines3D;
import org.papervision3d.materials.BitmapFileMaterial;
import org.papervision3d.materials.ColorMaterial;
import org.papervision3d.materials.MovieMaterial;
import org.papervision3d.materials.special.LineMaterial;
import org.papervision3d.materials.utils.MaterialsList;
import org.papervision3d.objects.DisplayObject3D;
import org.papervision3d.objects.primitives.Plane;
import org.papervision3d.render.BasicRenderEngine;
import org.papervision3d.scenes.Scene3D;
import org.papervision3d.objects.primitives.*;
import org.papervision3d.view.Viewport3D;

internal class PaperWorld extends Sprite
{
	// ATTRIBUTS
	private var _viewport:Viewport3D;
	private var _scene:Scene3D;
	private var _camera:Camera3D;
	private var _renderer:BasicRenderEngine;
	
	// OBJETS
	private var _tabPlane:Array;
	private var _tabLines:Array;
	private var _tabCubes:Array;
	
	// POUR LES PARAMETRE
	private var _w:int;
	private var _h:int;
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// CONSTRUCTOR
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	public function PaperWorld(w:int, h:int) 
	{
		_w = w;
		_h = h;
		this._tabPlane = new Array();
		this._tabLines = new Array();
		this._tabCubes = new Array();
		
		// initialise papervision
		initPapervision();
	}
		
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// INITIALISATION DE PAPERVISION3D
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	private function initPapervision():void
	{
		this._viewport = new Viewport3D(_w, _h, false,true);
		this.addChild( this._viewport );
		this._scene = new Scene3D();
		this._camera = new Camera3D();
		this._renderer = new BasicRenderEngine();
		this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
		this._camera.zoom = 50;
	}
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// ON ENTER FRAME SUR LE PLANE POUR UPDATE VISUELLE
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	private function onEnterFrame(e:Event):void 
	{
		this._renderer.renderScene ( this._scene, this._camera, this._viewport );
	}
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// OBJETS PAPERVISION3D
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// AJOUT D'UN PLANE POUR PLANE
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	public function addPlane(c:Number, _w:Number, _h:Number, _s_w:Number, _s_h:Number):void
	{
		var material:ColorMaterial = new ColorMaterial(c);
		material.interactive = true;
    	        var plane:Plane = new Plane(material, _w, _h, _s_w, _s_h);
		
		this._scene.addChild( plane );
		this._tabPlane.push(plane);
	}
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// PLANE IMAGES
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// @param img URL
	// X / Y / W / H
	// double face
	public function addPlaneImage(url:String, _w:Number, _h:Number, _s_w:Number, _s_h:Number, b:Boolean):void 
	{
		var material:BitmapFileMaterial = new BitmapFileMaterial(url);
		material.doubleSided = b;
		material.interactive = true;
		
		var plane:Plane = new Plane(material, _w, _h, _s_w, _s_h);
		this._scene.addChild(plane);
		this._tabPlane.push(plane);
	}
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// PLANE MOVIECLIP
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// @param img URL
	// X / Y / W / H
	// double face
	public function addPlaneMC(mc:MovieClip, _w:Number, _h:Number, _s_w:Number, _s_h:Number, b:Boolean):void 
	{
		var movieFront:MovieMaterial = new MovieMaterial(mc, true);
		movieFront.interactive = true;
		movieFront.animated = true;
		movieFront.smooth = true;
		movieFront.doubleSided = b;
		
		var plane:Plane = new Plane(movieFront, _w, _h, _s_w, _s_h);
		this._scene.addChild(plane);
		this._tabPlane.push(plane);
	}
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//3D LINES
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// pour chaque lignes du tableau, array = [x0, y0, z0, x1, y1, z1]
	public function addLines(c:Number, size:int, tabPoint:Array):void
	{
		var lineMaterial:LineMaterial = new LineMaterial(c, size);
		var lines3d:Lines3D = new Lines3D(lineMaterial);
		
		lines3d.addNewLine(tabPoint[0], 
								tabPoint[1],
									tabPoint[2],
										tabPoint[3],
											tabPoint[4],
												tabPoint[5],
													tabPoint[6]);
		
		this._scene.addChild(lines3d);
		this._tabLines.push(lines3d);
	}
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// CUBE
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// tabFaceColour [0 = all, 1 = right, 2 = left, 3 = top, 4 = bottom]
	// widht:int, depth:int, height:int, __segmentsS:int, __segmentsT:int, __segmentsH:int
	public function addCube(tabFaceColour:Array, w:Number , d:Number ,  h:Number , sS:Number , sT:Number , sH:Number):void {
		var matList:MaterialsList = new MaterialsList();
		matList.addMaterial(new ColorMaterial(tabFaceColour[0]), "all");
		matList.addMaterial(new ColorMaterial(tabFaceColour[1]), "right");
		matList.addMaterial(new ColorMaterial(tabFaceColour[2]), "left");
		matList.addMaterial(new ColorMaterial(tabFaceColour[3]), "top");
		matList.addMaterial(new ColorMaterial(tabFaceColour[4]), "bottom");
		var cube:Cube = new Cube(matList, w, d, h, sS, sH, sT);
		scene.addChild(cube);
		
		this._tabCubes[_tabCubes.length] = cube;
	}
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// REMOVE CHILD
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// CUBE
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// tabFaceColour [0 = all, 1 = right, 2 = left, 3 = top, 4 = bottom]
	// widht:int, depth:int, height:int, __segmentsS:int, __segmentsT:int, __segmentsH:int
	public function removeMaterial(child:DisplayObject3D, t:String):void {
		scene.removeChild(child);
		if (t == "PLANE") {
			
		}else if (t == "LINE") {
			
		}else if (t == "CUBE") {
			tabCubes.splice(0, 1);
		}
	}

    /////////////////////////////////////////////////////////////////////////////////////////////////////////// GETTER AND SETTER ATTRIBUTS DE CLASSE
	public function get viewport():Viewport3D { return _viewport; }
	public function set viewport(value:Viewport3D):void 
	{
		_viewport = value;
	}
	
	public function get scene():Scene3D { return _scene; }
	public function set scene(value:Scene3D):void 
	{
		_scene = value;
	}
	
	public function get camera():Camera3D { return _camera; }
	public function set camera(value:Camera3D):void 
	{
		_camera = value;
	}
	
	public function get renderer():BasicRenderEngine { return _renderer; }
	public function set renderer(value:BasicRenderEngine):void 
	{
		_renderer = value;
	}
	
	public function get tabPlane():Array { return _tabPlane; }
	public function set tabPlane(value:Array):void 
	{
		_tabPlane = value;
	}
	
	public function get tabLines():Array { return _tabLines; }
	public function set tabLines(value:Array):void 
	{
		_tabLines = value;
	}
	
	public function get w():int { return _w; }
	public function set w(value:int):void 
	{
		_w = value;
	}
	
	public function get h():int { return _h; }
	public function set h(value:int):void 
	{
		_h = value;
	}
	
	public function get tabCubes():Array { return _tabCubes; }
	
	public function set tabCubes(value:Array):void 
	{
		_tabCubes = value;
	}
}