/**
 * Copyright ravenzheng ( http://wonderfl.net/user/ravenzheng )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3MWA
 */

package 
{
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.*;
    import flash.display.BitmapData;
    import flash.events.*;
    import flash.text.*;
    import flash.geom.*;
    import flash.filters.*;
    import com.greensock.TweenMax;
    import com.greensock.easing.*;
    public class Main extends Sprite
    {
        private var str:String="360 vs QQ";
        private var arrayList:Array=[];//保存粒子
        private var contain:Sprite=new Sprite();//容器
        private var key:Boolean=false;
        public function Main()
        {
            init();
        }
        private function init():void
        {
            addChild(contain);
            contain.y=100;
            //创建文本
            var txt:TextField=new TextField();
            txt.defaultTextFormat=new TextFormat("Arail",25,0xffff00);
            txt.autoSize=TextFieldAutoSize.LEFT;
            txt.text=str;
            addChild(txt);
            txt.x=10;
            txt.y=10;
            var bmpdata:BitmapData=new BitmapData(txt.width,txt.height,false,0x0);//创建位图复制文本
            bmpdata.draw(txt);

            //扫描像素

            for (var i:int=0; i<bmpdata.width; i++)
            {
                for (var j:int=0; j<bmpdata.height; j++)
                {
                    var color:uint=bmpdata.getPixel(i,j);
                    var red:uint=(color>>16 )&0xff;

                    if (red>0)
                    {
                        var px:Number=j*5;
                        var py:Number=i*5;
                        var qq:QQ=new QQ();
                        qq.x=Math.random()*550;
                        qq.y=Math.random()*400;
                        qq.filters=[new GlowFilter(),new BlurFilter(1,1)];
                        var p:Particle=new Particle();
                        p.x=px;
                        p.y=py;
                        p.obj=qq;
                        contain.addChild(qq);
                        arrayList.push(p);
                    }

                }
            }
            render();
            stage.addEventListener(MouseEvent.CLICK,onClickHandler);
        }
        //渲染效果
        private function render( ):void
        {
            for (var i:int=0; i<arrayList.length; i++)
            {
                TweenMax.to(arrayList[i].obj,Math.random()*2+1,{x:arrayList[i].y,y:arrayList[i].x});
            }
        }
        
        //随机移动
        private function randomMove():void
        {
            for (var i:int=0; i<arrayList.length; i++)
            {
                TweenMax.to(arrayList[i].obj,Math.random()*2+1,{x:Math.random()*550,y:Math.random()*400});
            }
        }
        private function onClickHandler(event:MouseEvent):void
        {
            if (!key)
            {
                key=true;
                randomMove();
            }
            else
            {
                key=false;
                render();
            }
        }
    }
}

//简单的粒子模型
internal class Particle
{
    public var x:Number;
    public var y:Number;
    public var radius:Number=0;//半径
    public var color:uint;//颜色
    public var obj:*;
    public var angle:Number;

    public function Particle()
    {

    }
}


import flash.display.Sprite;
import flash.text.*;
internal class QQ extends Sprite
{

    public function QQ()
    {
        var txt:TextField=new TextField();
        txt.defaultTextFormat=new TextFormat("Arail",10,0xffff00);
        txt.autoSize=TextFieldAutoSize.LEFT;
        txt.text="QQ";
        txt.x=-txt.width/2;
        txt.y=-txt.height/2;
        txt.selectable=false;
        addChild(txt);

    }
    //设置坐标
    public function move(x:Number,y:Number):void
    {
        this.x=x;
        this.y=y;
    }
}