/**
 * Copyright FlashBum ( http://wonderfl.net/user/FlashBum )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3MOt
 */

package
{
        import caurina.transitions.*;
        
        import flash.display.*;
        import flash.events.*;
        import flash.net.*;
        
        // SWF Metadata
        [SWF(width="500", height="400", backgroundColor="#3a3e4a", framerate="30")]
        public class FlashBum extends Sprite
        {
                private var _display:Sprite;
                private var _background:Sprite;
                private var _loader:URLLoader;
                private var _currentLocationData:XML;
                
                public function FlashBum():void {
                        // Background
                        _background = createBackground();
                        addChild(_background);
                        // Display
                        _display = createDisplay();
                        addChild(_display);
                        //
                        loadLocation("http://flashbum.com/v4/xml/locations/eastvillage.xml");
                }
                
                private function createBackground():Sprite{
                        var background:Sprite = new Sprite();
                                background.graphics.beginFill(0x3a3e4a);
                                background.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
                                background.alpha = 0;
                                background.mouseChildren = false;
                                background.addEventListener(MouseEvent.CLICK, pullBack);
                        return background;
                }
                
                private function createDisplay():Sprite{
                        var display:Sprite = new Sprite();
                                display.x = stage.stageWidth * 0.5;
                                display.y = stage.stageHeight * 0.5;
                                display.mouseChildren = true;
                                display.addEventListener(MouseEvent.CLICK, zoomTo);
                        return display;
                }
                
                public function loadLocation(url:String):void{
                        _loader = new URLLoader();
                        _loader.addEventListener(Event.COMPLETE,onLoadLocation);
                        _loader.load(new URLRequest(url));
                }
                
                public function onLoadLocation(e:Event):void{
                        draw(new XML(e.target.data));
                }
                
                private function draw(data:XML):void{
                        var containers:XMLList = data.container;
                        for each(var item:XML in containers) {
                createItem(item);
            }
                }
                
                private function createItem(data:XML):void{
                        var sp:Sprite = new Sprite();
                                sp.graphics.beginFill(Math.random() * 0xFFFFFF);
                                sp.graphics.drawRect(0, 0, data.@w, data.@h);
                                sp.x = data.@x;
                                sp.y = data.@y;
                                sp.rotation = data.@r;
                                sp.z = data.@z;
                        _display.addChild(sp);
                }
                
                private function zoomTo(e:MouseEvent):void{
                        var sp:Sprite = Sprite(e.target);
                        Tweener.addTween(_display,{x:-sp.x+(sp.width * .5),y:-sp.y+(stage.stageHeight*.5), z:-sp.z+100, time:1});
                }
                
                private function pullBack(e:MouseEvent):void{
                        var next_z:Number = _display.z + 600;
                        Tweener.addTween(_display,{z:next_z,time:1});
                }
        }
}