/**
 * Copyright miyaoka ( http://wonderfl.net/user/miyaoka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3MBn
 */

// forked from corleonis's sakura
//クリックすると押し花みたいな桜が咲くよ

package {
	import flash.display.*;
	import flash.events.MouseEvent;
	import caurina.transitions.Tweener;
	import flash.events.Event;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.geom.Matrix;
	import flash.display.BlendMode;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	import flash.geom.Point;
	import flash.filters.BlurFilter;
	import flash.filters.GlowFilter;
	import flash.geom.ColorTransform;

	
	 [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "0xFFFFFF")]

	public class Hanasaka extends Sprite {
		private const W:Number = stage.stageWidth;
		private const H:Number = stage.stageHeight;
		private var bmd:BitmapData = new BitmapData(W, H, true, 0x00FFFFFF);
		
		public function Hanasaka():void {
			addChild(new Bitmap(bmd));
			var timer:Timer = new Timer(400);
			timer.addEventListener(TimerEvent.TIMER, function ():void 
			{
				bmd.applyFilter(bmd, bmd.rect, new Point(), new BlurFilter(2,2));
				bmd.colorTransform(bmd.rect, new ColorTransform(1, 1, 1, 0.90));
			});
			timer.start();
			
			stage.addEventListener(MouseEvent.CLICK,mouseClickHandler);
		}
		private function mouseClickHandler(e:MouseEvent):void {

			var num:uint = (Math.random() * 10 + 5) * (mouseY / H  + 1);
			var sandX:Number = W / 2;//Math.random() * W;
			for (var i:uint = 0; i < num; i++)
			{
				var sand:Sand = new Sand();
				sand.x =  sandX;
				sand.y = H + 100;
				sand.addEventListener("flowerComplete", flowerComplete);
				
				var r:Number = Math.random() * 100 * (mouseY / H + 0.7);
				var t:Number = Math.random() * Math.PI * 2;
				sand.throwSand(
					mouseX + Math.cos(t)*r,
					mouseY + Math.sin(t)*r / 2,
					1.5 + i * 0.02
				);
				
				addChild(sand);
			}
		}
		private function flowerComplete(e:Event):void 
		{
			var sand:Sand = Sand(e.target);
			sand.removeEventListener("flowerComplete", flowerComplete);
			bmd.draw(sand, new Matrix(1,0,0,1, sand.x, sand.y));
			removeChild(sand);
			sand = null;
		}
	}
}

import flash.display.*;
import caurina.transitions.Tweener;
import flash.events.Event;
import flash.filters.DropShadowFilter;
import flash.utils.Timer;
import flash.events.TimerEvent;

class Sand
extends Sprite
{
	public function Sand():void 
	{
		var g:Graphics = graphics;
		var num:uint = Math.random() * 10 + 30;
		while (num--) 
		{
			var clr:Number = Math.random() * 0.2 + 0.8;
			g.beginFill(clr * 0xFF << 16 | clr * 0xFF << 8 | clr * 0x0FF);
			
//			var r:Number = Math.random() * 30;
//			var t:Number = Math.random() * Math.PI * 2;			
			g.drawCircle(
//				Math.cos(t)*r,
//				Math.sin(t)*r,
				(Math.random()*2-1)*30,
				(Math.random()*2-1)*30,
				1.0 + Math.random() * 0.2
			);	
			g.endFill();
		}
	}
	public function throwSand(destX:Number, destY:Number, time:Number):void 
	{
		Tweener.addTween(this, {
			x: destX,
			time: time,
			transition: "easeOutSine"
		
		});
		Tweener.addTween(this, {
			y: destY,
			time: time,
			transition: "easeOutBack",
			onComplete: addFlower
		});		
	}
	private function addFlower():void 
	{
		graphics.clear();
		
		var sp:Shape = new Shape;
		addChild(sp);
		//sp.x = mouseX;
		//sp.y = mouseY;
		sp.scaleX = sp.scaleY = 0;
		sp.rotation = Math.random() * 180;
		filters = [
			new DropShadowFilter(0, 0, 0xFFFFFF, 0.5,3,3,10)
		]
		var rn:Number = (1- Math.random() * 0.7) * (y / 465 + 0.5);
		Tweener.addTween(sp, {
			scaleX:rn, scaleY:rn, 
			time:0.8, 
			transition:"easeOutExpo",
			onComplete: function ():void 
			{
				var timer:Timer = new Timer(1500, 1);
				timer.addEventListener(TimerEvent.TIMER_COMPLETE, function ():void 
				{
					timer = null;
					dispatchEvent(new Event("flowerComplete"));
				});
				timer.start();
			}
		});
	}
}

class Shape extends Sprite {
	public function Shape():void {
		var rc:Number = 0xFBD2D2 + Math.floor(Math.random() * 30);
		for (var i:int = 0; i < 5; i++) {
			var myShape:Sprite = new Sprite;
			myShape.graphics.lineStyle(15, rc, 1.0, false, LineScaleMode.NORMAL, CapsStyle.ROUND, JointStyle.MITER);
			myShape.graphics.moveTo(-6, -24);
			myShape.graphics.lineTo(0, -10);
			myShape.graphics.lineTo(6, -24);
			myShape.rotation = i * 72;
			myShape.alpha = 0.7;
			addChild(myShape);
		}
	}
}