/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3M9t
 */

// forked from irobutsu's 電気力線
package{
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.utils.IDataInput;
    import flash.accessibility.Accessibility;
    import flash.display.Sprite;

    [SWF(width="400", height="400",backgroundColor=0xffffff)]

    public class denba extends Sprite
    {
    private var hankei:int = 10 ; 
    private var r2:int = 100 ; 
    private var q1:charge;
    private var q2:charge;
    private var www:int = 64 ; 
    private var x1:Number = 150 ; 
    private var x2:Number = 300 ; 
    private var y1:Number = 140 ; 
    private var y2:Number = 180 ; 
    private var N:Number = 5.0 ; 
    private var showFFlg:Boolean = false ; 
    private var nowDrag:Sprite = null ; 
    private var cbV:Check,cbE:Check,cbY:Check,cbY1:Check,cbY2:Check;
    private var sbEE:Tsumami;
    private var sbQ1:Tsumami,sbQ2:Tsumami;
    private var w:int,h:int ; 

    public function denba():void { 
         sbEE = new Tsumami(this,0,-100,100,140,382,260,"外部電場=");
        // 初期値0、最小値-100、最大値100、位置(x=0,7=350)で表示幅200
        sbQ1 = new Tsumami(this,3,-5,5,140,346,140,"電荷１=",0xff);
        sbQ2 = new Tsumami(this,-2,-5,5,140,364,140,"電荷２=",0xaa00);
        cbY=new Check(this,false,0,382,140,"合成電場ベクトル",0xff00ff);
        cbY1=new Check(this,false,0,346,140,"１の電場ベクトル",0xaa);
        cbY2=new Check(this,false,0,364,140,"２の電場ベクトル",0x008800);
        cbE=new Check(this,true,280,346,120,"電気力線を描く");
        cbV=new Check(this,false,280,364,120,"電位を描く");

        stage.addEventListener(MouseEvent.MOUSE_DOWN, mPressed);
        stage.addEventListener(MouseEvent.MOUSE_UP, mReleased);
        stage.addEventListener(MouseEvent.MOUSE_MOVE, mMove);
        addEventListener("update",updateEvt);
        
        q1=new charge(3,0xff,200,100,this);
        q2=new charge(-2,0xaa00,300,300,this);

        update();
    }
    
    public function mMove(e:MouseEvent ):void { 
        if( nowDrag !=null ) {
        update();
        }
    }

    public function mPressed(e:MouseEvent ):void { 
        var mx:int = e.stageX ;
        var my:int = e.stageY ;
        if(nowDrag != null ) {
        return;
        } else if(q1.hitTestPoint(mx,my,false)) {
        nowDrag=q1;
        q1.goDrag();
        } else if(q2.hitTestPoint(mx,my,false)) {
        nowDrag=q2;
        q2.goDrag();
        }
    }
    

    public function mReleased(e:MouseEvent ):void {
        if(nowDrag != null ) {
        if(nowDrag == q1) q1.endDrag();
        if(nowDrag == q2) q2.endDrag();
        nowDrag = null ;
        }
        update();
    }
    
    private function SameSegment(xx:Number,yy:Number,xxx:Number,yyy:Number):Boolean { 
        var angle1:Number,angle2:Number,angle3:Number,angle4:Number ;
        if(Math.abs(xx-q1.X()) < 2.0 && q1.Y() > yy ) {
        angle1 = Math.atan2(q1.X()-xx,q1.Y()-yy) + Math.PI ;
        angle3 = Math.atan2(q1.X()-xxx,q1.Y()-yyy) + Math.PI ;
        }
        else {
        angle1 = Math.atan2(xx-q1.X(),yy-q1.Y());
        angle3 = Math.atan2(xxx-q1.X(),yyy-q1.Y());
        }
        if(Math.abs(xx-q2.X()) < 2.0 && q2.Y() > yy ) {
        angle2 = Math.atan2(q2.X()-xx,q2.Y()-yy) + Math.PI ;
        angle4 = Math.atan2(q2.X()-xxx,q2.Y()-yyy) + Math.PI ;
        }
        else {
        angle2 = Math.atan2(xx-q2.X(),yy-q2.Y());
        angle4 = Math.atan2(xxx-q2.X(),yyy-q2.Y());
        }
        var EE:Number=sbEE.value()*0.001;
        var inte:int = int(Math.floor((q1.Q()*angle1 + q2.Q()*angle2-EE*xx ) / (2.0*Math.PI )*N));
        var inte2:int = int(Math.floor((q1.Q()*angle3 + q2.Q()*angle4-EE*xxx ) / (2.0*Math.PI )*N));
        return (inte == inte2 );
    }
    
    private function writeRikisenFromTop(XX:int,YY:int):void { 
        var xs:Number = Number(XX);
        var xe:Number = Number((XX + 1 ));
        var ys:Number = Number(YY);
        var ye:Number = Number((YY + 1 ));
        if(SameSegment(xs,ys,xe,ys)) {
        return  ;
        }
        
        graphics.lineStyle(0,0xff0000);
        graphics.beginFill(0xff0000);
        graphics.drawRect(XX,YY,1,1);
        graphics.endFill();

        if((q1.Q() != 0 && (XX-q1.X())*(XX-q1.X()) + (YY-q1.Y())*(YY-q1.Y()) < r2 ) || (q2.Q() != 0 && (XX-q2.X())*(XX-q2.X()) + (YY-q2.Y())*(YY-q2.Y()) < r2 )) {
        return  ;
        }
        
        if(!SameSegment(xs, ye, xe, ye)) {
        if(YY < h-1 ) {
            writeRikisenFromTop(XX,YY + 1 );
        }
        
        }
        
        if(!SameSegment(xs, ys, xs, ye)) {
        if(XX > 0 ) {
            writeRikisenFromRight(XX-1,YY );
        }
        
        }
        
        if(!SameSegment(xe, ys, xe, ye)) {
        if(XX < w-1 ) {
            writeRikisenFromLeft(XX + 1,YY );
        }
        
        }
        
    }
    
    private function writeRikisenFromBottom(XX:int,YY:int ):void { 
        var xs:Number = Number(XX);
        var xe:Number = Number((XX + 1 ));
        var ys:Number = Number(YY);
        var ye:Number = Number((YY + 1 ));
        if(SameSegment(xs,ye,xe,ye)) {
        return  ;
        }
        
        graphics.lineStyle(0,0xff0000);
        graphics.beginFill(0xff0000);
        graphics.drawRect(XX,YY,1,1);
        graphics.endFill();
        if((q1.Q() != 0 && (XX-q1.X())*(XX-q1.X()) + (YY-q1.Y())*(YY-q1.Y()) < r2 ) || (q2.Q() != 0 && (XX-q2.X())*(XX-q2.X()) + (YY-q2.Y())*(YY-q2.Y()) < r2 )) {
        return  ;
        }
        
        if(!SameSegment(xs, ys, xe, ys)) {
        if(YY > 0 ) {
            writeRikisenFromBottom(XX,YY-1 );
        }
        
        }
        
        if(!SameSegment(xs, ys, xs, ye)) {
        if(XX > 0 ) {
            writeRikisenFromRight(XX-1,YY );
        }
        
        }
        
        if(!SameSegment(xe, ys, xe, ye)) {
        if(XX < w-1 ) {
            writeRikisenFromLeft(XX + 1,YY );
        }
        
        }
        
    }
    
    private function writeRikisenFromRight(XX:int,YY:int):void { 
        var xs:Number = Number(XX);
        var xe:Number = Number((XX + 1 ));
        var ys:Number = Number(YY);
        var ye:Number = Number((YY + 1 ));
        if(SameSegment(xe,ys,xe,ye)) {
        return  ;
        }
        graphics.lineStyle(0,0xff0000);
        graphics.beginFill(0xff0000);
        graphics.drawRect(XX,YY,1,1);
        graphics.endFill();

        if((q1.Q() != 0 && (XX-q1.X())*(XX-q1.X()) + (YY-q1.Y())*(YY-q1.Y()) < r2 ) || (q2.Q() != 0 && (XX-q2.X())*(XX-q2.X()) + (YY-q2.Y())*(YY-q2.Y()) < r2 )) {
        return  ;
        }
        
        if(!SameSegment(xs, ye, xe, ye)) {
        if(YY < h-1 ) {
            writeRikisenFromTop(XX,YY + 1 );
        }
        
        }
        
        if(!SameSegment(xs, ys, xs, ye)) {
        if(XX > 0 ) {
            writeRikisenFromRight(XX-1,YY );
        }
        
        }
        
        if(!SameSegment(xs, ys, xe, ys)) {
        if(YY > 0 ) {
            writeRikisenFromBottom(XX,YY-1 );
        }
        
        }
        
    }
    
    private function writeRikisenFromLeft(XX:int,YY:int):void { 
        var xs:Number = Number(XX);
        var xe:Number = Number((XX + 1 ));
        var ys:Number = Number(YY);
        var ye:Number = Number((YY + 1 ));
        if(SameSegment(xs,ys,xs,ye)) {
        return  ;
        }
        
        graphics.lineStyle(0,0xff00000);
        graphics.beginFill(0xff0000);
        graphics.drawRect(XX,YY,1,1);
        graphics.endFill();
        if((q1.Q() != 0 
            && (XX-q1.X())*(XX-q1.X()) + (YY-q1.Y())*(YY-q1.Y()) < r2
        ) 
        || (q2.Q() != 0 
            && (XX-q2.X())*(XX-q2.X()) + (YY-q2.Y())*(YY-q2.Y()) < r2
        ) 
        ) {
        return;
        }
        
        if(!SameSegment(xs, ye, xe, ye)) {
        if(YY < h-1 ) {
            writeRikisenFromTop(XX,YY + 1 );
        }
        }
        if(!SameSegment(xs, ys, xe, ys)) {
        if(YY > 0 ) {
            writeRikisenFromBottom(XX,YY-1 );
        }
        }
        if(!SameSegment(xe, ys, xe, ye)) {
        if(XX < w-1 ) {
            writeRikisenFromLeft(XX + 1,YY );
        }
        }
    }
    
    private function drawYajirusi(c:int,XX:int,YY:int,angle:Number,len:int,w:int ):void { 

        var x1:int = int((-w*Math.sin(angle) / 2 ));
        var y1:int = int((-w*Math.cos(angle) / 2 ));
        var x2:int = int((len*Math.cos(angle) / 2 ));
        var y2:int = int((-len*Math.sin(angle) / 2 ));
        var xl:int = int((len*Math.cos(angle)));
        var yl:int = int((-len*Math.sin(angle)));
        graphics.lineStyle(2,c);
        graphics.moveTo(XX,YY);
        graphics.lineTo(XX + xl,YY + yl);
        graphics.lineStyle(1,c);
        graphics.beginFill(c);
        graphics.moveTo(XX+xl,YY+yl);
        graphics.lineTo(XX + x2 + x1,YY + y2 + y1);
        graphics.lineTo(XX + x2-x1,YY + y2-y1);
        graphics.lineTo(XX+xl,YY+yl);
        graphics.endFill();

    }

    public function updateEvt(e:MouseEvent ):void {
        update();
    }
    public function update():void { 
        w = 400;
        h = 346;
        var XX:int,YY:int ;
        var xv:int,yv:int ; 

        q1.setQ(sbQ1.value());
        q2.setQ(sbQ2.value());

        graphics.clear();

        var mitudo:Number = 1.0 / N ;
        var x1i:int = q1.X();
        var x2i:int = q2.X();
        var y1i:int = q1.Y();
        var y2i:int = q2.Y();
        xv = (q1.X() + q2.X()) / 2 ;
        yv = (q1.Y() + q2.Y()) / 2 ;

        if(cbE.isChecked()) {
        if(q1.Q()*q2.Q() < 0 ) {
            if(Math.abs(q1.X()-q2.X()) > Math.abs(q1.Y()-q2.Y())) {
            if(xv == x1i || xv == x2i ) {
                xv = -1 ;
                yv = -1 ;
            }
            else {
                yv = -1 ;
            }
            }
            else {
            if(yv == y1i || yv == y2i ) {
                xv = -1 ;
                yv = -1 ;
            }
            else {
                xv = -1 ;
            }
            }
        }
        else {
            xv = -1 ;
            yv = -1 ;
        }
        for(XX = 0 ; XX < w ; XX++ ) {
            writeRikisenFromTop(XX,0 );
        }
        for(YY = 0 ; YY < h ; YY++ ) {
            writeRikisenFromRight(w-1,YY );
        }
        for(XX = w-1 ; XX >= 0 ; XX-- ) {
            writeRikisenFromBottom(XX,h-1 );
        }
        for(YY = h-1 ; YY > 1 ; YY-- ) {
            writeRikisenFromLeft(0,YY );
        }
        if(xv > 0 ) {
            for(YY = 0 ; YY < h-1 ; YY++ ) {
            writeRikisenFromLeft(xv,YY );
            writeRikisenFromRight(xv,YY );
            }
        }
        
        if(yv > 0 ) {
            for(XX = w-1 ; XX > 0 ; XX-- ) {
            writeRikisenFromTop(XX,yv );
            writeRikisenFromBottom(XX,yv );
            }
        }
        
        }
        
        if(cbV.isChecked()) {
        var Vol:Vector.<Vector.<int>>=new Vector.<Vector.<int>>(w+1);
        var Volmax:int=0;
        var Volmin:int=1;
        var v:int;
        var YYY1:Vector.<int>=new Vector.<int>(h+1);
        var YYY2:Vector.<int>=new Vector.<int>(h+1);
        for(YY = 0 ; YY <= h ; YY++ ) {
            YYY1[YY]=((YY-q1.Y())*(YY-q1.Y()));
            YYY2[YY]=((YY-q2.Y())*(YY-q2.Y()));
        }
        for(XX = 0 ; XX <= w ; XX++ ) {
            Vol[XX]=new Vector.<int>(h+1);
            var XXX1:int=(XX-q1.X())*(XX-q1.X());
            var XXX2:int=(XX-q2.X())*(XX-q2.X());
            for(YY = 0 ; YY <= h ; YY++ ) {
            if(XXX1+ YYY1[YY]> r2  && XXX2+ YYY2[YY] > r2 ) {
                v = int(Math.floor(
                    q1.Q()*Math.log(XXX1 + YYY1[YY]) 
                    + q2.Q()*Math.log(XXX2 + YYY2[YY])
                    - sbEE.value()*0.002*YY )
                );
                if( v>Volmax ) {
                Volmax=v;
                }
                if( v<Volmin ) {
                Volmin=v;
                }
                Vol[XX][YY]=v;
            } else {
                Vol[XX][YY]=0;
            }
            }
        }
        if( Volmin>Volmax ) {
            Volmax=1;Volmin=0;
        }

        var VV:Number=255.0/Number(Volmax-Volmin);
        for(XX = 0 ; XX < w ; XX++ ) {
            for(YY = 0 ; YY < h ; YY++ ) {
            //if((XX-q1.X())*(XX-q1.X()) + (YY-q1.Y())*(YY-q1.Y()) > r2 
            //&& (XX-q2.X())*(XX-q2.X()) + (YY-q2.Y())*(YY-q2.Y()) > r2 ) {
            if(Vol[XX][YY] != Vol[XX][YY + 1] || Vol[XX][YY] != Vol[XX + 1][YY] ) {
                //    || Vol[XX][YY] != Vol[XX + 1][YY + 1] ) {
                var k:int=VV*Number(Vol[XX][YY]-Volmin);
                if( k>255 ) k=255; 
                if( k<0) k=0;
                graphics.lineStyle(0,0x10001*k+(255-k)*0x100);
                graphics.beginFill(0x10001*k+(255-k)*0x100);
                graphics.drawRect(XX,YY,1,1);
                graphics.endFill();
                // }
            }
            }
        }
        }
        
        if(cbY.isChecked() || cbY1.isChecked() || cbY2.isChecked() ) {
        var ww:int = www / 8 ;
        for(XX = www ; XX < w ; XX += www ) {
            for(YY = www ; YY < h ; YY += www ) {
            var r1:Number = 1.0 / ((XX-q1.X())*(XX-q1.X()) + (YY-q1.Y())*(YY-q1.Y()) );
            var xxx:Number = q1.Q()*1000*(XX-q1.X())*r1 ;
            var yyy:Number = q1.Q()*1000*(YY-q1.Y())*r1 ;
            if(cbY1.isChecked() ) {
                drawYajirusi(0xff,XX,YY,Math.atan2(-yyy,xxx),int(Math.sqrt(xxx*xxx + yyy*yyy)),ww);
            }
            
            var rsq:Number = 1.0 / ((XX-q2.X())*(XX-q2.X()) + (YY-q2.Y())*(YY-q2.Y()) );
            var xxx2:Number = q2.Q()*1000*(XX-q2.X())*rsq ;
            var yyy2:Number = q2.Q()*1000*(YY-q2.Y())*rsq ;
            if(cbY2.isChecked() ) {
                drawYajirusi(0xaa00, XX,YY,
                Math.atan2(-yyy2,xxx2),int(Math.sqrt(xxx2*xxx2 + yyy2*yyy2)),ww);
            }
            
            if(cbY.isChecked() ) {
                drawYajirusi(0xff00ff,XX,YY,
                Math.atan2(-yyy-yyy2+sbEE.value(),xxx + xxx2),
                int(Math.sqrt((xxx + xxx2 )*(xxx + xxx2 ) + (yyy + yyy2-sbEE.value() )*(yyy + yyy2-sbEE.value() ))),ww);
            }
            
            }
        }
        }
        

        if(showFFlg ) {
        var f:int = int(
            (200000.0*q1.Q()*q2.Q()
            /
            ((q1.X()-q2.X())*(q1.X()-q2.X()) + (q1.Y()-q2.Y())*(q1.Y()-q2.Y()) )
            )
        );
        drawYajirusi(0xff00ff,q1.X(), q1.Y(),Math.atan2(q2.Y()-q1.Y(),q1.X()-q2.X()),f,8);
        drawYajirusi(0x00ff00,q2.X(), q2.Y(),Math.atan2(q1.Y()-q2.Y(),q2.X()-q1.X()),f,10);
        }

        q1.update();
        q2.update();
        sbEE.update(graphics);
        sbQ1.update(graphics);
        sbQ2.update(graphics);
        cbV.update();
        cbE.update();
        cbY.update();
        cbY1.update();
        cbY2.update();
    }
    
    }
}

import flash.events.Event;
import flash.events.MouseEvent;
import flash.utils.IDataInput;
import flash.accessibility.Accessibility;
import flash.display.Sprite;
import flash.display.*;
import flash.system.*;
import flash.geom.*;
import flash.text.*

class Clickable extends Sprite {
    public function Clickable(pp:Sprite):void {
    buttonMode=true;
    pp.addChild(this);
    }

}

class charge extends Clickable {
    private var q:int;
    private var hankei:int;
    private var color:int;
    private var nowDrag:Boolean;

    public function Q():int { return q;}
    public function X():int {return x+hankei;}
    // 中心のx座標を返す。xは左隅なので、半径分足す。
    public function Y():int {return y+hankei;}
    // 中心のy座標を返す。yは上隅なので、半径分足す。

    public function charge(qq:int,c:int,XX:int, YY:int,pp:Sprite):void {
    super(pp);
    x=XX;
    y=YY;
    q=qq;
    hankei=10;
    color=c;
    nowDrag=false;
    write();
//    pp.addChild(this);
   }
   public function setQ(qq:int):void { q=qq; }

    public function goDrag():void {
    nowDrag=true;
    startDrag(false,new Rectangle(0,0,400-hankei*2,346-hankei*2));
    }

    public function endDrag():void {
    nowDrag=false;
    stopDrag();
    update();
    }
    public function update():void {
    write();
    }
    public function write():void {
    graphics.lineStyle(1,color);
    graphics.beginFill(color);
    graphics.drawCircle(hankei,hankei,hankei);
    graphics.endFill();
    if( q != 0 ) {
        graphics.lineStyle(1,0xffffff);
        graphics.moveTo(3,hankei);
        graphics.lineTo(2*hankei-2 ,hankei);
        // ↑マイナス符号
        if( q> 0 ) {
        graphics.moveTo(hankei,2);
        graphics.lineTo(hankei,2*hankei-2);
        // ↑プラス符号に
        }
    }
    }
}



class Plate extends Sprite {
    protected var txt:TextField;
    protected var Width:int;
    public function Plate(pp:Sprite,X:int,Y:int,W:int,s:String):void {
    x=X;
    y=Y;
    txt=new TextField();
    txt.text=s;
    txt.height=18;
    txt.width=W-40;
    txt.y=0;
    addChild(txt);

    Width=W;
    buttonMode=true;
    writeNormal();
    pp.addChild(this);
    }

    protected function writeNormal():void { 
    graphics.clear();
    graphics.lineStyle(1,0xaaaaaa);
    graphics.beginFill(0xdddddd);
    graphics.drawRect(0,0,Width-1,17);
    graphics.endFill();
    graphics.lineStyle(1,0x666666);
    graphics.moveTo(1,17);
    graphics.lineTo(Width-1,17);
    graphics.lineTo(Width-1,1);
    }
}

class MessagePlate extends Plate {
    private var normalTxt:String;
    private var messageTxt:String;
    private var normalColor:int;
    private var messageColor:int;

    public function MessagePlate(pp:Sprite,X:int,Y:int,W:int,s1:String,s2:String,c1:int=0,c2:int=0xff0000):void {
    super(pp,X,Y,W,s1);
    normalTxt=s1;
    messageTxt=s2;
    normalColor=c1;
    messageColor=c2;
    Off();
    }
    public function On():void {
    txt.text=messageTxt;
    txt.textColor=messageColor;
    }
    public function Off():void {
    txt.text=normalTxt;
    txt.textColor=normalColor;
    }
}

class ClickablePlate extends Plate {
    public function ClickablePlate(pp:Sprite,X:int,Y:int,W:int,s:String):void {
    super(pp,X,Y,W,s);

    buttonMode=true;
    addEventListener(MouseEvent.MOUSE_UP,MUp);
    addEventListener(MouseEvent.MOUSE_OVER,MOver);
    addEventListener(MouseEvent.MOUSE_OUT,MOut);
    }

    public function MUp(e:Event):void {
    ;
    }

    public function MOut(e:Event):void {
    writeNormal();
    }

    public function MOver(e:Event):void {
    writeHilight();
    }
    protected function writeHilight():void {
    graphics.clear();
    graphics.lineStyle(1,0xffffff);
    graphics.beginFill(0xdddddd);
    graphics.drawRect(0,0,Width-1,17);
    graphics.endFill();
    graphics.lineStyle(1,0xaaaaaa);
    graphics.moveTo(1,17);
    graphics.lineTo(Width-1,17);
    graphics.lineTo(Width-1,1);
    }
}

class Charge extends Sprite {
    private var q:int;
    private var hankei:int;
    private var color:int;
    private var nowDrag:Boolean;

    public function Q():int { return q;}
    public function X():int {return x+hankei;}
    // 中心のx座標を返す。xは左隅なので、半径分足す。
    public function Y():int {return y+hankei;}
    // 中心のy座標を返す。yは上隅なので、半径分足す。

    public function Charge(qq:int,XX:int, YY:int,pp:Sprite):void {
    buttonMode=true;
    pp.addChild(this);
    x=XX;
    y=YY;
    q=qq;
    hankei=10;
    if( qq>0 ) {
        color=0xbb0000;
    } else {
        color=0xbb;
    }
    nowDrag=false;
    write();
    }

    public function goDrag():void {
    nowDrag=true;
    startDrag(false,new Rectangle(0,0,400-hankei*2,346-hankei*2));
    }

    public function endDrag():void {
    nowDrag=false;
    stopDrag();
    dispatchEvent(new Event("update"));
    }

    public function update():void {
    write();
    }
    public function write():void {
    graphics.clear();
    graphics.lineStyle(1,color);
    graphics.beginFill(color);
    graphics.drawCircle(hankei,hankei,hankei);
    graphics.endFill();
    if( q != 0 ) {
        graphics.lineStyle(1,0xffffff);
        graphics.moveTo(3,hankei);
        graphics.lineTo(2*hankei-2 ,hankei);
        // ↑マイナス符号
        if( q> 0 ) {
        graphics.moveTo(hankei,2);
        graphics.lineTo(hankei,2*hankei-2);
        // ↑プラス符号に
        }
    }
    }
}



class PushButton extends ClickablePlate{
    public function PushButton(pp:Sprite,L:int,Y:int,WW:int,l:String,c:int=0):void {
    super(pp,L,Y,WW,l);
    txt.x=2;
    txt.textColor=c;
    }
    public override function MUp(e:Event):void {
    dispatchEvent(new Event("allerase",true));
    }
}



class Check extends ClickablePlate {
    private var val:Boolean;
    private var box:Sprite;

    public function Check(pp:Sprite,now:Boolean,X:int,Y:int,W:int,l:String,c:int=0):void {
    super(pp,X,Y,W,l);
    val=now;
    txt.x=16;
    txt.textColor=c;
    box=new Sprite();
    box.buttonMode=true;
    addChild(box);
    write();
    }

    public override function MUp(e:Event):void {
    toggle();
    dispatchEvent(new Event("update",true));
    }

    public function setValue(a:Boolean):void {
    val=a;
    write();
    }


    public function isChecked():Boolean {
    return val;
    }

    public function toggle():void {
    setValue(!val);
    }

    public function update():void {
    write();
    }

    public function write():void {
    box.graphics.clear();
    box.graphics.lineStyle(1,0);
    box.graphics.beginFill(0xffffff);
    box.graphics.drawRect(1,1,14,14);
    box.graphics.endFill();    
    if( val ) {
        box.graphics.lineStyle(2,0);
        box.graphics.moveTo(2,11);
        box.graphics.lineTo(4,11);
        box.graphics.lineTo(6,13);
        box.graphics.lineTo(14,3);
    }
    }
}



class Tsumami extends Plate {
    private var val:int;
    private var min:int;
    private var max:int;
    private var label:String;
    private var nowDrag:Boolean;
    private var lever:Sprite;
    private var mizo:Sprite;
    public function Tsumami(pp:Sprite,now:int,minimum:int,maximum:int,X:int,Y:int,WW:int,l:String,c:int=0):void {
    super(pp,X,Y,WW,l);
    buttonMode=false;
    nowDrag=false;
    min=minimum;
    max=maximum;
    val=now;
    label=l;
    lever=new Sprite();
    mizo=new Sprite();
    addChild(mizo);
    addChild(lever);
    mizo.x=Width/2;
    mizo.y=6;
    mizo.buttonMode=true;
    lever.buttonMode=true;
    mizo.addEventListener(MouseEvent.MOUSE_UP,mizoMUp);
    mizo.addEventListener(MouseEvent.MOUSE_OVER,mizoMOver);
    mizo.addEventListener(MouseEvent.MOUSE_OUT,mizoMOut);
    stage.addEventListener(MouseEvent.MOUSE_UP,leverMUp);
    lever.addEventListener(MouseEvent.MOUSE_DOWN,leverMDown);
    lever.addEventListener(MouseEvent.MOUSE_OVER,leverMOver);
    lever.addEventListener(MouseEvent.MOUSE_OUT,leverMOut);
    leverNormal();
    mizoNormal();
    lever.x=this.XIchi();
    }

    public function leverMUp(e:MouseEvent):void {
        if(nowDrag ) {
        endDrag();
        }
    }
    public function leverMOver(e:MouseEvent):void {
    leverHighlight();
    }
    public function leverMDown(e:MouseEvent):void {
    goDrag();
    }


    public function mizoMUp(e:MouseEvent):void {
    var p:Point=localToGlobal(new Point(lever.x,lever.y) );
    if( e.stageX < p.x+6 ) {
        oneDown();
    } else {
        oneUp();
    }
    mizoHighlight(e);
    }
    public function mizoMOver(e:MouseEvent):void {
    mizoHighlight(e);
    }
    public function mizoMOut(e:MouseEvent):void {
    mizoNormal();
    }

    public function mizoNormal():void {
    mizo.graphics.clear();
    mizo.graphics.lineStyle(1,0x555555);
    mizo.graphics.beginFill(0x555555);
    mizo.graphics.drawRect(0,0,Width/2-4,5);
    mizo.graphics.endFill();
    mizo.graphics.lineStyle(1,0);
    mizo.graphics.moveTo(0,5);
    mizo.graphics.lineTo(0,0);
    mizo.graphics.lineTo(Width/2-4,0);
    }

    public function mizoHighlight(e:MouseEvent):void {
    if( nowDrag ) {
        return;
    }
    var p:Point=localToGlobal(new Point(lever.x,lever.y) );
    mizo.graphics.clear();
    mizo.graphics.lineStyle(1,0x555555);
    mizo.graphics.beginFill(0x555555);
    mizo.graphics.drawRect(0,0,Width/2-4,5);
    mizo.graphics.endFill();
    mizo.graphics.lineStyle(1,0xffffff);
    if( e.stageX > p.x+6 ) {
        mizo.graphics.moveTo(lever.x-mizo.x,0);
        mizo.graphics.lineTo(Width/2-4,0);
        mizo.graphics.beginFill(0xffff);
        mizo.graphics.moveTo(lever.x-mizo.x+8,0);
        mizo.graphics.lineTo(lever.x-mizo.x+18,3);
        mizo.graphics.lineTo(lever.x-mizo.x+8,6);
        mizo.graphics.endFill();
    } else {
        mizo.graphics.moveTo(lever.x-mizo.x,0);
        mizo.graphics.lineTo(0,0);
        mizo.graphics.lineTo(0,6);
        mizo.graphics.beginFill(0xffff);
        mizo.graphics.moveTo(lever.x-mizo.x-2,0);
        mizo.graphics.lineTo(lever.x-mizo.x-12,3);
        mizo.graphics.lineTo(lever.x-mizo.x-2,6);
        mizo.graphics.endFill();
    }
    }

    public function leverMOut(e:MouseEvent):void {
    if( !nowDrag ) {
        leverNormal();
    }
    }

    public function oneUp():void {
    setValue(val+1);
    }

    public function oneDown():void {
    setValue(val-1);
    }

    private function XIchi():int{
    return int(Number((Width/2-6)*(val-min))/Number(max-min))+Width/2;
    }


    public function goDrag():void {
    nowDrag=true;
    leverInDrag();
    lever.startDrag(false,new Rectangle(Width/2,0,Width/2-6,0));
    }

    public function endDrag():void {
    nowDrag=false;
    leverNormal();
    lever.stopDrag();
    val=min + int(Number((lever.x-Width/2)*(max-min))/Number(Width/2-6)+0.5);
    lever.x=XIchi();
    }

    public function setValue(a:int):void { 
    if( a>max ) {
        a=max;
    }
    if( a<min ) {
        a=min;
    }
    val=a; 
    lever.x=XIchi();
    dispatchEvent(new Event("update",true));
    }

    public function value():int {
    return val;
    }

    public function update(egraphics:Graphics):void {
    txt.text=label+String(val);
    }

    public function leverNormal():void {
    lever.graphics.clear();
    lever.graphics.lineStyle(1,0x333300);
    lever.graphics.beginFill(0xaa0000);
    lever.graphics.drawRect(0,0,6,18);
    lever.graphics.endFill();    
    }

    public function leverHighlight():void {
    lever.graphics.clear();
    lever.graphics.lineStyle(1,0xffff00);
    lever.graphics.beginFill(0xaa0000);
    lever.graphics.drawRect(0,0,6,18);
    lever.graphics.endFill();    
    }

    public function leverInDrag():void {
    lever.graphics.clear();
    lever.graphics.lineStyle(1,0x888800);
    lever.graphics.beginFill(0xff0000);
    lever.graphics.drawRect(0,0,6,18);
    lever.graphics.endFill();
    }
}