/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Ls2
 */

package  
{
    import com.bit101.components.NumericStepper;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    public class RPolygon extends Sprite
    {
        private var sprite:Sprite;
        private var sidesAmount:Number;
        private var delta:Number;
        private var spriteRotation:int;
        private var angle:Number;
        private var radius:Number;
        private var g:Graphics;
        
        public function RPolygon() 
        {
            new NumericStepper(this, 0, 0, sidesAmountHandle).value =sidesAmount = 10;
            sprite = Sprite(addChild(new Sprite));
            sprite.x = stage.stageWidth >> 1;
            sprite.y = stage.stageHeight >> 1;
            g = sprite.graphics;
            init();
            addEventListener(Event.ENTER_FRAME,loop ,false,0,true );
        }
        
        private function init():void 
        {
            delta = Math.PI * 2 / sidesAmount;
            angle = 0;
            radius = 100;
            g.clear();
            var count:Number = 4;
            while (count--) 
            {
                polygon();
            }
        }
        
        private function polygon():void 
        {
            g.lineStyle(3,0xff0000*Math.random());
            angle += 0.5 * delta;
            radius *= Math.cos(delta * 0.5); 
            g.moveTo(radius * Math.cos(angle), radius * Math.sin(angle));
            for (var i:int = 0; i < sidesAmount; i++) 
            {
                angle += delta;
                g.lineTo(radius * Math.cos(angle), radius * Math.sin(angle));
                
            }
        }
        
        private function loop(e:Event):void
        { 
            sprite.rotation = (spriteRotation > 360)?0:++spriteRotation;
            spriteRotation= sprite.rotation;  
        }
        
        private function sidesAmountHandle(e:Event):void 
        {
            sidesAmount = NumericStepper(e.target).value;
            init();
            
        }
        
    }

}