/**
 * Copyright rafael1 ( http://wonderfl.net/user/rafael1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Lo9
 */

// forked from beryu's forked from: webcam映像をRGB3色に着色して震えさせる
// forked from beryu's webcam映像をRGB3色に着色して震えさせる
/**
 * webcam映像のCMYK4色を抽出して震えさせる
 * 
 * fork元ではRGBに着色した画像を合成する時の透明度の調整で
 * 入力された色を擬似的に再現していたので、若干色が狂っていました。
 * コレは入力された映像の色をCMYKに分離して再度合成しているだけなので
 * 元の色は狂わず残っているはずです。
 */
package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.BlendMode;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Camera;
    import flash.media.Video;
    
    public class VibratingCam extends Sprite {
        // 震えの許容値
        private const LATITUDE:Number = 10;
        
        private var _cam:Camera;
        private var _vid:Video;
        private var _bmp:Bitmap;
        private var _bmpDataSrc:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
        private var _bmpDataDst:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
        private var _bmpDataC:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
        private var _bmpDataM:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
        private var _bmpDataY:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
        private var _bmpDataK:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
        
        public function VibratingCam()
        {
            // ビデオ準備
            _cam = Camera.getCamera();
            _cam.setMode(stage.stageWidth, stage.stageHeight, 15);
            _vid = new Video(stage.stageWidth, stage.stageHeight);
            _vid.attachCamera(_cam);
            
            // 表示用Bitmapに出力用bitmapを関連づける
            _bmp = new Bitmap(_bmpDataDst);
            
            // stageにadd
            addChild(_bmp);
            
            // イベント
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            // 基画像
            _bmpDataSrc.draw(_vid);
            
            // CMYK4色抽出
           /* _bmpDataC.copyChannel(
                _bmpDataSrc,
                _bmpDataSrc.rect,
                new Point(Math.random() * LATITUDE*2 - LATITUDE, Math.random() * LATITUDE*2 - LATITUDE),
                BitmapDataChannel.RED,
                BitmapDataChannel.RED
            );
            _bmpDataM.copyChannel(
                _bmpDataSrc,
                _bmpDataSrc.rect,
                new Point(Math.random() * LATITUDE*2 - LATITUDE, Math.random() * LATITUDE*2 - LATITUDE),
                BitmapDataChannel.GREEN,
                BitmapDataChannel.GREEN
            );
            _bmpDataY.copyChannel(
                _bmpDataSrc,
                _bmpDataSrc.rect,
                new Point(Math.random() * LATITUDE*2 - LATITUDE, Math.random() * LATITUDE*2 - LATITUDE),
                BitmapDataChannel.BLUE,
                BitmapDataChannel.BLUE
            );
            _bmpDataK.copyChannel(
                _bmpDataSrc,
                _bmpDataSrc.rect,
                new Point(Math.random() * LATITUDE*2 - LATITUDE, Math.random() * LATITUDE*2 - LATITUDE),
                BitmapDataChannel.ALPHA,
                BitmapDataChannel.ALPHA
            );*/
            
            _bmpDataC.copyChannel(
                _bmpDataSrc,
                _bmpDataSrc.rect,
                new Point(0, 0),
                BitmapDataChannel.RED,
                BitmapDataChannel.RED
            );
            _bmpDataM.copyChannel(
                _bmpDataSrc,
                _bmpDataSrc.rect,
                new Point(10, 10),
                BitmapDataChannel.GREEN,
                BitmapDataChannel.GREEN
            );
            _bmpDataY.copyChannel(
                _bmpDataSrc,
                _bmpDataSrc.rect,
                new Point(-10, -10),
                BitmapDataChannel.BLUE,
                BitmapDataChannel.BLUE
            );
            _bmpDataK.copyChannel(
                _bmpDataSrc,
                _bmpDataSrc.rect,
                new Point(20, 20),
                BitmapDataChannel.ALPHA,
                BitmapDataChannel.ALPHA
            );
        }
    }
}