/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3LNG
 */

// forked from 9re's MyCaretIndex, selectionBeginIndex, selectionEndIndex
package {
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.geom.Rectangle;
	import flash.text.TextFormat;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldType;

    public class TextField_caretIndex extends Sprite {
		private var outputField:TextField;
		private var tf:MyTextField;
		protected var caret:MyCaret;
    	
        public function TextField_caretIndex() {
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
            addChild(outputField = createCustomTextField(10, 200, 100, 100));
            
			
			tf = new MyTextField;
			tf.trace = trace;
            tf.defaultTextFormat = new TextFormat('_typewriter');
			tf.x = 10;
			tf.y = 10;
            //tf.wordWrap = true;
			//tf.background = true;
            //tf.type = TextFieldType.INPUT;
			addChild(tf);
            tf.text = "Click in this text field. Caret will move to the position you click.";

           //tf.addEventListener(MouseEvent.CLICK, printCursorPosition);
            tf.dispatchEvent(new MouseEvent(MouseEvent.CLICK));
            //tf.selectable = false;0
            
 
        }
        
        
        
        public function trace(...arguments:Array):void {
        		outputField.appendText(arguments + "\n");
        		outputField.scrollV = outputField.maxScrollV;
        		outputField.width = outputField.textWidth + 4;
        }

        private function printCursorPosition(event:MouseEvent):void {
            var tf:TextField = TextField(event.target);
            trace("caretIndex:", tf.caretIndex);
        }

        private function createCustomTextField(x:Number, y:Number, width:Number, height:Number):TextField {
            var result:TextField = new TextField();
            result.x = x;
            result.y = y;
            result.width = width;
            result.height = height;
            addChild(result);
            return result;
        }
    }
}

import flash.display.Shape;
import flash.display.Sprite;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.utils.setTimeout;

// jp.psyark.psycode.controls.UIControl
class UIControl extends Sprite {
	private var _width:Number = 100;
	private var _height:Number = 100;
	
	
	/**
	 * コントロールの幅と高さ設定します。
	 */
	public function setSize(width:Number, height:Number):void {
		if (_width != width || _height != height) {
			_width = width;
			_height = height;
			updateSize();
		}
	}
	
	
	/**
	 * コントロールの幅を取得または設定します。
	 */
	public override function get width():Number {
		return _width;
	}
	
	/**
	 * @private
	 */
	public override function set width(value:Number):void {
		if (_width != value) {
			_width = value;
			updateSize();
		}
	}
	
	/**
	 * コントロールの高さを取得または設定します。
	 */
	public override function get height():Number {
		return _height;
	}
	
	/**
	 * @private
	 */
	public override function set height(value:Number):void {
		if (_height != value) {
			_height = value;
			updateSize();
		}
	}
	
	
	/**
	 * コントロールのサイズを更新します。
	 */
	protected function updateSize():void {
	}
}



class MyCaret extends Sprite {
	private var _height:Number;
	private var _width:Number;
	private var _color:int;
	private var _count:int;
	private const INTERVAL:int = 30;
	
	public function MyCaret($h:int, $color:uint) {
		_color = $color;
		setSize(2, $h);
		
		addEventListener(Event.ENTER_FRAME, updateCaret);
	}
	
	private function updateCaret(e:Event):void 
	{
		_count = ++_count % INTERVAL;
		visible = _count < (INTERVAL >> 1);
	}
	
	public function setSize(w:Number, h:Number):void {
		_width = w;
		_height = h;
		draw();
	}
	
	private function draw():void {
		trace('draw', _height, _color);
		
		//graphics.clear();
		graphics.beginFill(_color);
		graphics.drawRect(0, 0, _width, _height);
		
		graphics.endFill();
	}
}


class MyTextField extends UIControl {
	private var _textField:TextField;
	private var _caret:MyCaret;
	
	public function MyTextField () {
		_textField = new TextField;
		
		_textField.background = true;
		_textField.selectable = false;
		_textField.mouseEnabled = _textField.mouseWheelEnabled = false;
		
		addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
		addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		
		addChild(_textField);
		addChild(_caret = new MyCaret(13, 0));
	}
	private function onMouseDown(e:MouseEvent):void {
	}
	
	public function set defaultTextFormat(value:TextFormat):void {
		_textField.defaultTextFormat = value;
		setZeroPos();
	}
	
	private function setZeroPos():void {
		var str:String = _textField.text;
		_textField.text = 'A';
		
		var rect:Rectangle = _textField.getCharBoundaries(0);
		
		_caret.x = rect.x;
		_caret.y = rect.y + 2;
		
		_textField.text = str;
	}
	
	public function getCharIndexFromMousePoint():int {
		var i:int = _textField.getCharIndexAtPoint(mouseX, mouseY);
		var line:int;
		if (i < 0) {
			line = _textField.getLineIndexAtPoint(mouseX, mouseY);
			if (line < 0) return -1;
			
			i = _textField.getLineOffset(line) + _textField.getLineLength(line) - 1;
			
			if (i == _textField.length - 1)
				i = _textField.length;
		}
		
		
		return i;
	}
	
	public function set text(value:String):void {
		_textField.wordWrap = true;
		_textField.text = value;
		_textField.height = _textField.textHeight + 4;
	}
	
	public var trace:Function;
	
	private function onMouseUp(e:MouseEvent):void {
		var i:int = getCharIndexFromMousePoint();
		if (i < 0) {
			setZeroPos();
			return;
		}
		
		var rect:Rectangle;
		if (i < _textField.length) {
			rect = _textField.getCharBoundaries(i);
		} else {
			//if (_textField.length < 1) {
				//setZeroPos();
				//return;
			//}
			rect = _textField.getCharBoundaries(i - 1);
			rect.x += rect.width + 2;
		}
		_caret.x = rect.x;
		_caret.y = rect.y + 2;
	}
	
	
	override protected function updateSize():void 
	{
		_textField.width = width;
		_textField.height = height;
	}
	
}