/**
 * Copyright kanatara ( http://wonderfl.net/user/kanatara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3L0f
 */

// forked from haiji505's NumberParticle
package {
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.display.MovieClip;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.filters.BlurFilter;
	import flash.events.Event;
	import flash.utils.Timer
	import flash.events.TimerEvent
	import flash.text.*;
	
	public class particleClass extends MovieClip {
		var timer:Timer;
		
		function particleClass() {
			timer = new Timer(5);
			timer.addEventListener(TimerEvent.TIMER, onTimer);
			timer.start();
		}
		
		function onTimer(e:TimerEvent):void {
			for (var i:int = 0; i<2; i++) {
			var pFormat:TextFormat;
			pFormat = new TextFormat();
			pFormat.size = 90;
			pFormat.font = "Helvetica";
				
			var pNumber:TextField;
			pNumber = new TextField();
			pNumber.defaultTextFormat = pFormat;
			pNumber.textColor = (Math.random() * 0xffff00);
			pNumber.text =  String(int(Math.random()*10));
			pNumber.selectable = false;

			var pbit:Bitmap;
			pbit = generateBitMap(pNumber);
			pbit.smoothing = true;
			
			var pObject:Sprite;
			pObject = new Sprite();
			pObject.addChild(pbit);
			addChild(pObject);
			
			var rx:int = Math.random()*300;
			var ry:int = Math.random()*400;
			pObject.x = stage.mouseX+rx*Math.pow(-0.5, 1);
			pObject.y = stage.mouseY+ry*Math.pow(-0.5, 1);
			pObject.addEventListener(Event.ENTER_FRAME, playParticle);
			}
		}
		
		function generateBitMap(txt:TextField):Bitmap {
			var bitMap:BitmapData = new BitmapData(txt.width, txt.height, true, 0xFFFFFF);
			bitMap.draw(txt);
			return new Bitmap(bitMap)
		}
		
		function playParticle(e:Event):void {

			var pObject:Sprite = e.target as Sprite;
			pObject.x += Math.random()*30;
			pObject.y += pObject.x/160;
			pObject.scaleX -= 0.05;
			pObject.scaleY -= 0.05;
			pObject.alpha -= 0.02;
			
			if (pObject.x>200) pObject.x += Math.random()*50;
			
			if(pObject.alpha<0.8){
				var blur : BlurFilter = new BlurFilter();
				pObject.filters = [blur];
				pObject.rotation += Math.random()*180;
			}
			
			if(pObject.alpha<0.1) {
				removeChild(pObject);
				pObject.removeEventListener(Event.ENTER_FRAME, playParticle);
			}
		}
	}
}