/**
 * Copyright earl223 ( http://wonderfl.net/user/earl223 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3KcE
 */

package {
    
    // @author Earl Andre Vergara
    // Submitted for 2011 Phlashers.com 5KB Challenge
    
    // Turn your PC/laptop into a Megafone.  
    // You will need a microphone and though your built-in PC/laptop speakers will work ok, 
    // more powerful speakers will work great.
    
    // To compile:  Flash Develop or Flash Builder publish to Air 3.0
    
    import flash.media.Microphone;
    import flash.media.MicrophoneEnhancedOptions;
    import flash.media.MicrophoneEnhancedMode;
    import flash.display.MovieClip;
    import flash.text.TextField;

    [SWF(backgroundColor="0x6699CC", width="100", height="100")]
    public class Megafone extends MovieClip {
        
        private var microphone:Microphone;
        private var options:MicrophoneEnhancedOptions;
        private var myText:TextField;
        
        function Megafone() {
            
            myText = new TextField();
            myText.htmlText = "MEGAFONE\n\nSpeak now!\n\nMicrophone required.";
            addChild(myText);
            
            myText.wordWrap = true;
            myText.width = 100;
            myText.height = 100;
            
            // Start microphone
            microphone = Microphone.getEnhancedMicrophone();
            
            // Setup microphone options
            options = new MicrophoneEnhancedOptions();
            options.echoPath = 128;
            options.mode = MicrophoneEnhancedMode.FULL_DUPLEX;
            options.nonLinearProcessing = true;
            
            // assign options to microphone
            microphone.enhancedOptions = options;
            
            // Set amount of noise to listen for.
            // zero (0) will listen to everything
            microphone.setSilenceLevel(5);
            
            // Prevent microphone feedback.
            // Sound coming from speakers will not be picked-up.
            microphone.setUseEchoSuppression(true);
            
            // Redirect microphone output to speakers.
            microphone.setLoopBack(true);
            
        }
        
        
    }

}