/**
 * Copyright yinaak ( http://wonderfl.net/user/yinaak )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3KZt
 */

// forked from ProjectNya's drawTriangles (3)
////////////////////////////////////////////////////////////////////////////////
// drawTriangles (3)
//
// [AS3.0] drawTriangles()メソッド！ (3)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1614
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.ProgressEvent;
    import flash.display.Shape;
    import flash.display.BitmapData;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.easing.*;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var fontloader:FontLoader;
        //private static var basePath:String = "";
        private static var basePath:String = "http://www.project-nya.jp/images/flash/";
        private static var fontPath:String = "fonts/MyriadProSemibold.swf";
        private static var className:String = "MyriadProSemibold";
        private var progressBar:ProgressBar;
        private var loader:ImageLoader;
        private static var filePath:String = "piyo_drawTriangles.png";
        private var container:Sprite;
        private var canvas:Shape;
        private var texture:BitmapData;
        private static var cx:uint = 232;
        private static var cy:uint = 232;
        private var pointer0:Pointer;
        private var pointer1:Pointer;
        private var pointer2:Pointer;
        private var pointer3:Pointer;
        private var distortion:DistortionUtil;

        public function Main() {
            //Wonderfl.capture_delay(4);
            init();
        }

        private function init():void {
            fontloader = new FontLoader();
            fontloader.addEventListener(FontLoader.COMPLETE, loaded, false, 0, true);
            fontloader.load(basePath + fontPath, className);
            //
            container = new Sprite();
            addChild(container);
            container.alpha = 0;
            container.visible = false;
            canvas = new Shape();
            container.addChild(canvas);
            canvas.x = cx;
            canvas.y = cy;
        }
        private function loaded(evt:Event):void {
            fontloader.removeEventListener(FontLoader.COMPLETE, loaded);
            fontloader = null;
            //
            progressBar = new ProgressBar(465);
            addChild(progressBar);
            progressBar.x = 232;
            progressBar.y = 222;
            progressBar.addEventListener(ProgressBar.FADE_OUT, fadeOut, false, 0, true);
            progressBar.addEventListener(ProgressBar.BAR_FADE_OUT, barFadeOut, false, 0, true);
            progressBar.init();
            //
            loader = new ImageLoader();
            loader.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
            loader.addEventListener(Event.COMPLETE, complete, false, 0, true);
            loader.load(basePath + filePath, true);
        }
        private function progress(evt:ProgressEvent):void {
            progressBar.progress(evt.bytesLoaded, evt.bytesTotal);
        }
        private function complete(evt:Event):void {
            loader.removeEventListener(ProgressEvent.PROGRESS, progress);
            loader.removeEventListener(Event.COMPLETE, complete);
            //
            texture = loader.content.bitmapData;
            setup();
        }
        private function fadeOut(evt:Event):void {
            progressBar.removeEventListener(ProgressBar.FADE_OUT, fadeOut);
        }
        private function barFadeOut(evt:Event):void {
            progressBar.removeEventListener(ProgressBar.BAR_FADE_OUT, barFadeOut);
            //
            var itween:ITween = BetweenAS3.to(container, {alpha: 1, visible: 1}, 0.6, Linear.easeNone);
            itween.addEventListener(TweenEvent.COMPLETE, faded, false, 0, true);
            itween.play();
        }
        private function faded(evt:Event):void {
            evt.target.removeEventListener(TweenEvent.COMPLETE, faded);
            removeChild(progressBar);
            progressBar = null;
            loader = null;
        }
        private function setup():void {
            Pointer.center(cx, cy);
            var rect:Rectangle = new Rectangle(40, 30, 384, 404);
            pointer0 = new Pointer("TL", -160, -120);
            container.addChild(pointer0);
            pointer0.area = rect;
            pointer0.addEventListener(Pointer.DRAG, update, false, 0, true);
            pointer1 = new Pointer("TR", 160, -120);
            container.addChild(pointer1);
            pointer1.area = rect;
            pointer1.addEventListener(Pointer.DRAG, update, false, 0, true);
            pointer2 = new Pointer("BL", -160, 120);
            container.addChild(pointer2);
            pointer2.area = rect;
            pointer2.addEventListener(Pointer.DRAG, update, false, 0, true);
            pointer3 = new Pointer("BR", 160, 120);
            container.addChild(pointer3);
            pointer3.area = rect;
            pointer3.addEventListener(Pointer.DRAG, update, false, 0, true);
            //
            distortion = new DistortionUtil(canvas.graphics, texture, 5, 5);
            draw();
        }
        private function update(evt:Event):void {
            draw();
        }
        private function draw():void {
            var p1:Point = new Point(pointer0.x - cx, pointer0.y - cy);
            var p2:Point = new Point(pointer1.x - cx, pointer1.y - cy);
            var p3:Point = new Point(pointer2.x - cx, pointer2.y - cy);
            var p4:Point = new Point(pointer3.x - cx, pointer3.y - cy);
            distortion.transform(p1, p2, p3, p4);
        }

    }

}


//////////////////////////////////////////////////
// DistortionUtilクラス
//////////////////////////////////////////////////

import flash.display.Graphics;
import flash.display.BitmapData;
import flash.geom.Point;
import flash.display.TriangleCulling;

class DistortionUtil {
    private var graphics:Graphics;
    private var texture:BitmapData;
    private var hsegments:uint = 1;
    private var vsegments:uint = 1;
    private var xunit:Number = 1;
    private var yunit:Number = 1;
    private var indices:Vector.<int>;
    private var uvData:Vector.<Number>

    public function DistortionUtil(g:Graphics, t:BitmapData, h:uint = 1, v:uint = 1) {
        graphics = g;
        texture = t;
        hsegments = h + 1;
        vsegments = v + 1;
        xunit = 1/hsegments;
        yunit = 1/vsegments;
        init();
    }

    private function init():void {
        indices = new Vector.<int>();
        for (var v:uint = 0; v < vsegments; v++) {
            for (var h:uint = 0; h < hsegments; h++) {
                var id0:Number = v*(hsegments + 1) + h;
                var id1:Number = v*(hsegments + 1) + h + 1;
                var id2:Number = (v + 1)*(hsegments + 1) + h;
                var id3:Number = (v + 1)*(hsegments + 1) + h + 1;
                indices.push(id0, id1, id2, id1, id3, id2);
            }
        }
        indices.reverse();
        uvData = new Vector.<Number>();
        for (var y:uint = 0; y < vsegments + 1; y++) {
            for (var x:uint = 0; x < hsegments + 1; x++) {
                uvData.push(xunit*x, yunit*y);
            }
        }
    }
    public function transform(p1:Point, p2:Point, p3:Point, p4:Point):void {
        var vertices:Vector.<Number> = new Vector.<Number>();
        for (var y:uint = 0; y < vsegments + 1; y++) {
            for (var x:uint = 0; x < hsegments + 1; x++) {
                var tx:Number = xunit*x;
                var ty:Number = yunit*y;
                var x12:Number = p1.x + (p2.x - p1.x)*tx;
                var y12:Number = p1.y + (p2.y - p1.y)*tx;
                var x34:Number = p3.x + (p4.x - p3.x)*tx;
                var y34:Number = p3.y + (p4.y - p3.y)*tx;
                var px:Number = x12 + (x34 - x12)*ty;
                var py:Number = y12 + (y34 - y12)*ty;
                vertices.push(px, py);
            }
        }
        graphics.clear();
        graphics.lineStyle(1);
        
        graphics.beginBitmapFill(texture, null, false, true);
        graphics.drawTriangles(vertices, indices, uvData, TriangleCulling.NONE);
        graphics.endFill();
    }

}


//////////////////////////////////////////////////
// Pointerクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.ColorTransform;
import flash.geom.Rectangle;

class Pointer extends Sprite {
    private static var cx:uint = 0;
    private static var cy:uint = 0;
    private var base:Shape;
    private var hit:Sprite;
    private var txt:TextField;
    private var id:String = "";
    private var pos:TextField;
    private var rect:Rectangle;
    private static var fontType:String = "Myriad Pro Semibold";
    private static var radius:uint = 4;
    private static var _width:uint = 100;
    private static var _height:uint = 20;
    private static var bColor:uint = 0xFFFFFF;
    private static var upColor:uint = 0x333399;
    private static var overColor:uint = 0xCC0000;
    private static var offColor:uint = 0x999999;
    private static var upColorTrans:ColorTransform;
    private static var overColorTrans:ColorTransform;
    private static var offColorTrans:ColorTransform;
    private var _enabled:Boolean = true;
    public static const DRAG:String = "drag";

    public function Pointer(i:String, px:int, py:int) {
        id = i;
        x = px + cx;
        y = py + cy;
        draw();
        show();
    }

    public static function center(px:int, py:int):void {
        cx = px;
        cy = py;
    }
    public function set area(r:Rectangle):void {
        rect = r;
    }
    public function reset(px:int, py:int):void {
        x = px + cx;
        y = py + cy;
        show();
    }
    private function draw():void {
        base = new Shape();
        hit = new Sprite();
        txt = new TextField();
        pos = new TextField();
        addChild(hit);
        addChild(base);
        addChild(txt);
        addChild(pos);
        base.graphics.beginFill(bColor);
        base.graphics.drawCircle(0, 0, radius);
        base.graphics.endFill();
        hit.graphics.beginFill(bColor, 0);
        hit.graphics.drawCircle(0, 0, 10);
        hit.graphics.endFill();
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 14;
        tf.align = TextFormatAlign.CENTER;
        txt.x = -_width*0.2;
        txt.y = -26;
        txt.width = _width*0.4;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        txt.embedFonts = true;
        txt.antiAliasType = AntiAliasType.ADVANCED;
        txt.defaultTextFormat = tf;
        txt.text = id;
        pos.x = -_width*0.5;
        pos.y = 6;
        pos.width = _width;
        pos.height = _height - 1;
        pos.type = TextFieldType.DYNAMIC;
        pos.selectable = false;
        pos.embedFonts = true;
        pos.antiAliasType = AntiAliasType.ADVANCED;
        pos.defaultTextFormat = tf;
        upColorTrans = new ColorTransform();
        upColorTrans.color = upColor;
        overColorTrans = new ColorTransform();
        overColorTrans.color = overColor;
        offColorTrans = new ColorTransform();
        offColorTrans.color = offColor;
        hitArea = hit;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
        addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        stage.addEventListener(MouseEvent.MOUSE_UP, releaseOutside, false, 0, true);
        stage.addEventListener(Event.MOUSE_LEAVE, leave, false, 0, true);
        startDrag(false, rect);
        addEventListener(Event.ENTER_FRAME, drag, false, 0, true);
    }
    private function release(evt:MouseEvent):void {
        _up();
        removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        stopDrag();
        removeEventListener(Event.ENTER_FRAME, drag);
        show();
        dispatchEvent(new Event(Pointer.DRAG));
    }
    private function releaseOutside(evt:MouseEvent):void {
        _up();
        removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        stopDrag();
        removeEventListener(Event.ENTER_FRAME, drag);
        show();
        dispatchEvent(new Event(Pointer.DRAG));
    }
    private function leave(evt:Event):void {
        removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        stopDrag();
    }
    private function click(evt:MouseEvent):void {
    }
    private function drag(evt:Event):void {
        _down();
        show();
        dispatchEvent(new Event(Pointer.DRAG));
    }
    private function show():void {
        pos.text = "(" + String(x-cx) + ", " + String(y-cy) + ")";
    }
    private function _up():void {
        base.transform.colorTransform = upColorTrans;
    }
    private function _over():void {
        base.transform.colorTransform = overColorTrans;
    }
    private function _down():void {
        base.transform.colorTransform = overColorTrans;
    }
    private function _off():void {
        base.transform.colorTransform = offColorTrans;
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
        _up();
        addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
        addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
        addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
        addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
        _off();
        removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
        removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
        removeEventListener(MouseEvent.MOUSE_DOWN, press);
        removeEventListener(MouseEvent.CLICK, click);
        }
    }

}


//////////////////////////////////////////////////
// FontLoaderクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.text.Font;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.system.ApplicationDomain;
import flash.system.SecurityDomain;
import flash.system.LoaderContext;
import flash.utils.getDefinitionByName;

class FontLoader extends EventDispatcher {
    public var id:uint;
    private var loader:Loader;
    private var info:LoaderInfo;
    private var _className:String;
    private var _font:Font;
    private var _fontName:String;
    private var embeded:Boolean = false;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function FontLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String, name:String, e:Boolean = false):void {
        _className = name;
        embeded = e;
        info.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            var context:LoaderContext = new LoaderContext();
            context.applicationDomain = ApplicationDomain.currentDomain;
            context.securityDomain = SecurityDomain.currentDomain;
            loader.load(new URLRequest(file), context);
        } catch (err:Error) {
            trace(err.message);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function progress(evt:ProgressEvent):void {
        dispatchEvent(evt);
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(FontLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(FontLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(FontLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        dispatchEvent(new Event(FontLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        var FontClass:Class = Class(ApplicationDomain.currentDomain.getDefinition(className));
        if (!embeded) {
            Font.registerFont(FontClass);
            _font = Font(new FontClass());
        } else {
            var document:Object = new FontClass();
            _font = document.font;
        }
        _fontName = _font.fontName;
        dispatchEvent(new Event(FontLoader.COMPLETE));
    }
    public function get className():String {
        return _className;
    }
    public function get font():Font {
        return _font;
    }
    public function get fontName():String {
        return _fontName;
    }

}


//////////////////////////////////////////////////
// ProgressBarクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;

class ProgressBar extends Sprite {
    private var base:Sprite;
    private var bar:Shape;
    private var prog:Shape;
    private var title:TextField;
    private var txt:TextField;
    private static var label:String = "loading...";
    private static var fontType:String = "Myriad Pro Semibold";
    private var _width:uint = 800;
    private static var _height:uint = 40;
    private static var bHeight:uint = 10;
    private static var tWidth:uint = 50;
    private static var tHeight:uint = 20;
    private static var bColor:uint = 0x000000;
    private static var tColor:uint = 0x000000;
    private static var pColor:uint = 0x000000;
    private static var eColor:uint = 0xCC0000;
    private var shade:DropShadowFilter;
    private var _percent:Number = 0;
    private var targetPercent:Number;
    private static var interval:uint = 500;
    private static var deceleration:Number = 0.4;
    private var timer:Timer;
    public static const FADE_OUT:String = "fadeOut";
    public static const BAR_FADE_OUT:String = "baseFadeOut";

    public function ProgressBar(w:uint) {
        _width = w;
        draw();
        percent = 0;
        visible = false;
    }

    private function draw():void {
        createChildren();
        createText();
    }
    public function update(w:uint):void {
        _width = w;
        base.x = -_width/2;
        createBar(bar, _width, pColor);
        createLine(prog, _width, bColor);
    }
    private function createChildren():void {
        base = new Sprite();
        bar = new Shape();
        prog = new Shape();
        addChild(base);
        base.addChild(bar);
        base.addChild(prog);
        base.x = -_width/2;
        base.y = 8;
        createBar(bar, _width, pColor);
        createLine(prog, _width, bColor);
        bar.mask = prog;
    }
    private function createText():void {
        title = new TextField();
        txt = new TextField();
        addChild(title);
        addChild(txt);
        title.x = -tWidth;
        title.y = -_height/2 + 2;
        title.width = tWidth;
        title.height = tHeight - 2;
        title.type = TextFieldType.DYNAMIC;
        title.selectable = false;
        title.embedFonts = true;
        title.antiAliasType = AntiAliasType.NORMAL;
        var tfl:TextFormat = new TextFormat();
        tfl.font = fontType;
        tfl.size = 12;
        tfl.align = TextFormatAlign.LEFT;
        title.defaultTextFormat = tfl;
        title.textColor = tColor;
        title.text = label;
        txt.x = 0;
        txt.y = -_height/2 + 2;
        txt.width = tWidth;
        txt.height = tHeight - 2;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        txt.embedFonts = true;
        txt.antiAliasType = AntiAliasType.NORMAL;
        var tfr:TextFormat = new TextFormat();
        tfr.font = fontType;
        tfr.size = 12;
        tfr.align = TextFormatAlign.RIGHT;
        txt.textColor = tColor;
        txt.defaultTextFormat = tfr;
    }
    public function init():void {
        alpha = 1;
        createBar(bar, _width, pColor);
        percent = 0;
        prog.x = 0;
        prog.scaleX = 0;
        visible = true;
    }
    public function error(e:String):void {
        alpha = 1;
        txt.text = "0%";
        createBar(bar, _width, eColor);
        prog.scaleX = 1;
        visible = true;
    }
    public function progress(l:Number, t:Number):void {
        targetPercent = Math.round(l/t*100);
        addEventListener(Event.ENTER_FRAME, progressTo, false, 0, true);
    }
    private function progressTo(evt:Event):void {
        percent += (targetPercent - percent)*deceleration;
        if (Math.abs(targetPercent - percent) < 0.5) {
            percent = targetPercent;
            removeEventListener(Event.ENTER_FRAME, progressTo);
        }
        if (percent >= 100) {
            timer = new Timer(interval, 1);
            timer.addEventListener(TimerEvent.TIMER, fadeOut, false, 0, true);
            timer.start();
        }
    }
    private function fadeOut(evt:TimerEvent):void {
        timer.removeEventListener(TimerEvent.TIMER, fadeOut);
        addEventListener(Event.ENTER_FRAME, reduction, false, 0, true);
    }
    private function reduction(evt:Event):void {
        prog.x += (_width - prog.x)*deceleration;
        if (Math.abs(_width - prog.x) < 0.5) {
            prog.x = _width;
            removeEventListener(Event.ENTER_FRAME, reduction);
            addEventListener(Event.ENTER_FRAME, baseFadeOut, false, 0, true);
            dispatchEvent(new Event(ProgressBar.FADE_OUT));
        }
    }
    private function baseFadeOut(evt:Event):void {
        var speed:Number = 0.1;
        alpha -= speed;
        if (alpha <= 0) {
            removeEventListener(Event.ENTER_FRAME, baseFadeOut);
            alpha = 0;
            visible = false;
            dispatchEvent(new Event(ProgressBar.BAR_FADE_OUT));
        }
    }
    public function get percent():Number {
        return _percent;
    }
    public function set percent(value:Number):void {
        _percent = value;
        manage(_percent);
    }
    private function manage(p:Number):void {
        txt.text = String(Math.round(p)) + "%";
        prog.scaleX = p/100;
    }
    private function createBase(target:Shape, x:int, y:int, w:uint, h:uint, color:uint):void {
        target.graphics.beginFill(color);
        target.graphics.drawRect(x, y, w, h);
        target.graphics.endFill();
    }
    private function createLine(target:Shape, w:uint, color:uint, alpha:Number = 1):void {
        target.graphics.clear();
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRect(0, 0, w, 1);
        target.graphics.endFill();
    }
    private function createBar(target:Shape, w:uint, color:uint):void {
        target.graphics.clear();
        target.graphics.beginFill(color);
        target.graphics.drawRect(0, 0, w, 1);
        target.graphics.endFill();
    }

}


//////////////////////////////////////////////////
// ImageLoaderクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.display.Bitmap;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;

class ImageLoader extends EventDispatcher {
    public var id:uint;
    private var loader:Loader;
    private var info:LoaderInfo;
    public var content:Bitmap;
    private var smoothing:Boolean;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function ImageLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String, s:Boolean = false):void {
        smoothing = s;
        info.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            loader.load(new URLRequest(file));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function progress(evt:ProgressEvent):void {
        dispatchEvent(evt);
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(ImageLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(ImageLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(ImageLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        content = Bitmap(info.content);
        if (smoothing) {
            content.smoothing = true;
        }
        dispatchEvent(new Event(ImageLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        dispatchEvent(new Event(ImageLoader.COMPLETE));
    }

}
