/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3KJj
 */

package {
    import com.bit101.components.Label;
    import net.hires.debug.Stats;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.system.Security;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff")]
    
    public class FlashTest extends Sprite {
        private static const SIZE:Number = 90;
        private static const RADIUS:int = 30;
        private static const CENTER_X:int = 465 >> 1;
        private static const CENTER_Y:int = 465 >> 1;
        private static const CAMERA_RADIUS:int = 600;
        private static const FOCUS:Number = 400;
        
        private static const KEYWORD:String = "sea";
        
        private const CENTER:MyVector3D = new MyVector3D();
        private const UP:MyVector3D = new MyVector3D(0, 1, 0);
        
        private var camera:MyVector3D;
        private var isMouseDown:Boolean;
        private var oldX:Number;
        private var oldY:Number;
        private var targetRot:Number;
        private var targetPitch:Number;
        private var rot:Number;
        private var pitch:Number;
        
        private var container:Array;
        private var n_planes:int;
        
        private var img_array:Array;
        private var count:int;
        private var label:Label;
        
        
        public function FlashTest() {
            stage.scaleMode = StageScaleMode.SHOW_ALL;
            stage.align = StageAlign.TOP;
            stage.quality = StageQuality.HIGH;
            stage.frameRate = 30;
            mouseChildren = false;
            mouseEnabled = false;
            
            img_array = [];
            container = [];
            oldX = oldY = rot = pitch = n_planes = count = 0;
            targetPitch = 90;
            targetRot = 180;
            isMouseDown = false;
            camera = new MyVector3D(0, 0, FOUCS);
            
            var radian:Number = Math.PI/180;
            var H:int = (RADIUS * Math.PI) / SIZE;
            var theta1:Number;
            var theta2:Number = 90;
            for(var i:int = 0; i < H; i++)
            {
                theta1 = 0;
                var pn:int = Math.floor((2*RADIUS*MATH.PI*Math.cos(theta2 * radian)) / SIZE);
                for(var j:int = 0; j < pn; j++)
                {
                    var plane:MyPlane = new MyPlane(SIZE, n_planes);
                    plane.rotationX = -theta2;
                    plane.rotationY = theta1;
                    plane.x = RADIUS * Math.cos(theta2 * radian) * Math.sin(theta1 * radian);
                    plane.y = RADISU * Math.sin(theta2 * radian);
                    plane.z = RADIUS * Math.cos(theta2 * radian) * Math.cos(theta1 * radian);
                    theta1 += 360 / pn;
                    container[n_planes] = plane;
                    n_planes ++;
                }
                theta2 -= 180 / H;
            }
            
            label = new Label(this, CENTER_X-80, CENTER_Y-50);
            label.scaleX = label.scaleY = 2;
            label.text = "Loading images from flickr.\n" + count.toString() + "\t/" + n_planes.toString();
            Security.loadPolicyFile("http://api.flickr.com/crossdomain.xml");
            Security.loadPolicyFile("http://farm1.static.flickr.com/crossdomain.xml");
            Security.loadPolicyFile("http://farm2.static.flickr.com/crossdomain.xml");
            Security.loadPolicyFile("http://farm3.static.flickr.com/crossdomain.xml");
            Security.loadPolicyFile("http://farm4.static.flickr.com/crossdomain.xml");
            
            var api_loader:URLLoader=new URLLoader;
            api_loader.addEventListener(Event.COMPLETE, onCompleteAccessAPI);
            api_loader.load(new URLRequest("http://api.flickr.com/services/rest/?method=flickr.photos.search&api_key=25c5f4bc0087edf4d6efdc567daf0a64&tags="+KEYWORD + "&per_page=" + n_planes));
        }
        
        private function onCompleteAccessAPI(e:Event):void
        {
            var api_loader:URLLoader = e.target as URLLoader;
            api_loader.removeEventListener(Event.COMPLETE, onCompleteAccessAPI);
            
            var xml:XML = XML(api_loader.data);
            if(xml.@stat == "ok")
            {
                for each(var photo:XML in xml.photos.photo)
                {
                    var url:String="http://farm" + photo.@farm + ".static.flickr.com/" + photo.@server + "/" + photo.@id + "_" + photo.@secret + ".jpg";
                    var img_loader:Loader=new Loader();
                    img_loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onCompletePhotoLoad);
                    img_loader.load(new URLRequest(url), new LoaderContext(true));
                }
            }            
        }
        
        private function onCompletePhotoLoad(e:Event):void
        {
            var img_loader:Loader = (e.target as LoaderInfo).loader;
            img_loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onCompletePhotoLoad);
            
            img_array[count] = (img_)
        }

    }
}