/**
 * Copyright KinkumaDesign ( http://wonderfl.net/user/KinkumaDesign )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3KHQ
 */

package  
{
    //see
    //Utils3D.projectVectorsの練習 nitoyon
    //http://wonderfl.net/code/0a28d4d3bdb068e674be2d9b165f27f1bd312f39
    
	import flash.display.GradientType;
	import flash.display.Graphics;
	import flash.display.GraphicsGradientFill;
	import flash.display.GraphicsPath;
	import flash.display.GraphicsPathCommand;
	import flash.display.GraphicsSolidFill;
	import flash.display.GraphicsStroke;
	import flash.display.IGraphicsData;
	import flash.display.JointStyle;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.geom.Matrix3D;
	import flash.geom.PerspectiveProjection;
	import flash.geom.Point;
	import flash.geom.Utils3D;
	import flash.geom.Vector3D;
	
	[SWF(width="600", height="400", frameRate="30", backgroundColor="0x000000")]
	public class Mat3 extends MovieClip
	{
		public var verts:Vector.<Number>;
		public var proj:Matrix3D;
		public var results:Vector.<Number>;
		public var uvts:Vector.<Number>;
		public var numOfPoints:int = 800;
		public var projDegY:Number = 0;
		public var projDegX:Number = 0;
		public var projDegZ:Number = 0;
		
		public var stroke:GraphicsStroke;
		public var path:GraphicsPath;
		//public var solid:GraphicsSolidFill;
		public var gradFill:GraphicsGradientFill;
		public var drawing:Vector.<IGraphicsData>;
		
		public function Mat3() 
		{
			var i:int;
			
			stroke = new GraphicsStroke(2); 
			stroke.joints = JointStyle.ROUND;
			stroke.fill = new GraphicsSolidFill(0xffffff, 1);
			path = new GraphicsPath(new Vector.<int>);
			for (i = 0; i < numOfPoints; i++) {
				if (i == 0) {
					path.commands.push(1);
				}else {
					path.commands.push(2);
				}
			}
			//solid = new GraphicsSolidFill(0xff3299, 1);
			var gradMat:Matrix = new Matrix();
			gradMat.createGradientBox(1000, 1000, 0, -380, -380);
			gradFill = new GraphicsGradientFill(
				GradientType.RADIAL, 
				[0xff3299, 0x00CBFF],
				[1, 1], 
				[0, 255],
				gradMat);
			
			var radius:Number = 10;
			var rad:Number = 0;
			var offsetY:Number = 0.7;
			var cntY:Number = 0.5;
			verts = new Vector.<Number>();
			var vec:Vector3D;
			for (i = 0; i < numOfPoints; i++) {
				vec = new Vector3D();
				vec.y = cntY;
				vec.x = Math.cos(rad) * radius;
				vec.z = Math.sin(rad) * radius;
				cntY += offsetY;
				verts.push(vec.x, vec.y, vec.z);
				rad += 0.15;
				radius += 0.5;
			}
			
			proj = new Matrix3D();
			results = new Vector.<Number>();
			uvts = new Vector.<Number>();
			this.addEventListener(Event.ENTER_FRAME, ef);
		}
		
		private function ef(e:Event):void 
		{
			var hh:Number = stage.stageHeight / 2;
			var hw:Number = stage.stageWidth / 2;
			var dy:Number = (hh - stage.mouseY) / hh;
			var dx:Number = (hw - stage.mouseX ) / hw;
			projDegX += (dy * 90 - projDegX) * 0.1;
			projDegZ += (dx * 90 - projDegZ) * 0.1;
			proj.identity();
			proj.appendRotation(projDegY, Vector3D.Y_AXIS);
			proj.appendRotation(projDegX, Vector3D.X_AXIS);
			proj.appendRotation(projDegZ, Vector3D.Z_AXIS);
			proj.appendTranslation(120, 120, 0);

			projDegY += 7;
			if (projDegY > 360) {
				projDegY %= 360;
			}
			Utils3D.projectVectors(proj, verts, results, uvts);
			
			var i:int;
			var g:Graphics = this.graphics;
			g.clear();
			path.data = new Vector.<Number>();

			for (i = 0; i < numOfPoints; i++) {
				path.data.push(results[i * 2], results[i * 2 + 1]);
			}
			drawing = new Vector.<IGraphicsData>();
			drawing.push(stroke, gradFill, path);
			graphics.drawGraphicsData(drawing);
		}
		
	}
	
}