/**
 * Copyright sakusan393 ( http://wonderfl.net/user/sakusan393 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3KDv
 */

// forked from sakusan393's 道っぽい表現のつもり
package  {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.GradientType;
	import flash.display.Graphics;
	import flash.display.InterpolationMethod;
	import flash.display.SpreadMethod;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	
	/**
	 * ...
	 * @author 393
	 * 道っぽい表現をつくりたかったけど
	 * なんだかいまいちな感じ。。。
	 * 
	 * self ｆork
	 * 影で進行方向へのスピード感を出したかったのだけど
	 * イマイチ伝わらない。。。

	 */

	public class Main extends Sprite {
		private var stage_center_x:Number;
		private var stage_center_y:Number;
		private var stage_right_x:Number;
		private var stage_bottom_y:Number;
		//ポイント座標格納用
		private var pointArray:Array;
		private var top:Point;
		private var left:Point;
		private var right:Point;
		private var bottom:Point;
		private var bmd:BitmapData;
		private var cTra:ColorTransform;
		private var rect:Rectangle;
		private var matrix:Matrix;
		private var speed:Number = 0;
		private var prevX:Number;
		private var prevY:Number;
		
		public function Main() {
			
			//ポイント座標の設定
			var ratio:Number = 1.5;
			var sideRatio:Number = 100;
			rect = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);
			matrix = new Matrix();
			
			//基本三角形の座標
			top = new Point(0,stage.stageHeight/2);
			left = new Point(0+stage.stageWidth/sideRatio,stage.stageHeight*ratio);
			right = new Point(stage.stageWidth-stage.stageWidth/sideRatio,stage.stageHeight*ratio);
			
			
			stage_center_x = stage.stageWidth/2;
			stage_center_y = stage.stageHeight/2;
			stage_right_x = stage.stageWidth;
			
			setPoint();
			var sp:Sprite  = new Sprite();
			//sp.blendMode = BlendMode.SCREEN;
			sp.x = stage.stageWidth;
			sp.y = stage.stageHeight;
			prevX = sp.x;
			prevY = sp.y;
			bmd = new BitmapData(stage.stageWidth,stage.stageHeight,false, 0x00000000);
			var bm:Bitmap = new Bitmap(bmd);
			addChild(bm);
			addChild(sp);
			cTra= new ColorTransform( 0.8, 0.7, 0.7, 1);
			
			sp.addEventListener(Event.ENTER_FRAME , enterFrameHandler);
		}
		
		private function enterFrameHandler(e:Event = null ):void {
			
			var sp:Sprite = e.target as Sprite;
			var spg:Graphics = sp.graphics;
			spg.clear();
			//spg.beginFill(Math.random()*0xFFFFFF);
			//spg.beginFill(0xFFCCFF);
			spg.beginGradientFill(GradientType.RADIAL,
				[0xFFFFcc , 0xFFFFcc , 0xFFFF33 , 0xFFFF00 , 0xCCCC00],
				[ 1 , 1 ,  1 ,  1 , 1],
				[ 0 , 64, 127 , 192 , 255],
				new Matrix(
					1 , 0 ,
					0 , 1 ,
					top.x , top.y
				),
				SpreadMethod.PAD,
				InterpolationMethod.LINEAR_RGB,
				0.0
			);

			spg.moveTo(pointArray[0].posX, pointArray[0].posY);
			for (var i:uint = 1; i < pointArray.length-1; i++){
				spg.curveTo(pointArray[i].posX, pointArray[i].posY,(pointArray[i].posX + pointArray[i+1].posX)/2, (pointArray[i].posY + pointArray[i+1].posY)/2);
			}
			spg.curveTo(pointArray[pointArray.length-1].posX, pointArray[pointArray.length-1].posY,pointArray[0].posX, pointArray[0].posY);
			spg.endFill();
			move(sp);
			
		}
		
		private function move(sp:Sprite):void{
			speed += 10;
			var radian:Number = degreeToRadian(speed);
			//固定的な動き
			sp.x = 60 * Math.sin(radian) + stage_center_x;
			sp.y = 80 * Math.cos(radian / 10);
			
			//マウスに反応
			//sp.x += ((mouseX + 100) - prevX)*0.05;
			//sp.y += ((mouseY -stage.stageHeight / 2 + 50) - prevY) * 0.05;
			//prevX = sp.x;
			//prevY = sp.y;
			
                        //残像用
			//matrix.tx = sp.x;
			//matrix.ty = sp.y;
			
			//bmd.draw(sp, matrix, cTra);
			//bmd.colorTransform(rect, cTra);

			matrix.tx = sp.x;
			matrix.ty = sp.y;
			
			var bm:CustomBitmap = new CustomBitmap(bmd);
			bmd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
			bmd.draw(sp,matrix);
			bmd.colorTransform(new Rectangle(0, 0, stage.stageWidth, stage.stageHeight),cTra);
			addChildAt(bm, 1);
			bm.x = 5
			bm.y = 20
			bm.addEventListener("dispose", dispose);

		}
		private function dispose(e:Event):void {
			removeChild(Bitmap(e.target));
		}

		private function degreeToRadian(degree:Number ):Number{
			var radian = degree * (Math.PI / 180);
			return radian;
		}
		private function setPoint():void{
			pointArray = new Array();
			pointArray.push(new CustomPoint(top.x, top.y, 100, 80, 5,2,0))
			pointArray.push(new CustomPoint(top.x -(top.x-left.x)*1/6,top.y-(top.y-left.y)*1/6,200,30,5,4,-30))
			pointArray.push(new CustomPoint(top.x -(top.x-left.x)*2/6,top.y-(top.y-left.y)*2/6,250,60,5,3,-60))
			pointArray.push(new CustomPoint(top.x -(top.x-left.x)*3/6,top.y-(top.y-left.y)*3/6,300,90,5,2,-90))
			pointArray.push(new CustomPoint(top.x -(top.x-left.x)*4/6,top.y-(top.y-left.y)*4/6,300,90,5,2,-120))
			pointArray.push(new CustomPoint(top.x -(top.x-left.x)*5/6,top.y-(top.y-left.y)*5/6,300,90,5,2,-150))
			pointArray.push(new CustomPoint(left.x,left.y,300,10,5,5, -120))
			pointArray.push(new CustomPoint(right.x,right.y,300,10,5,5,-120))
			pointArray.push(new CustomPoint(top.x -(top.x-right.x)*5/6,top.y-(top.y-right.y)*5/6,300,90,5,2,-150))
			pointArray.push(new CustomPoint(top.x -(top.x-right.x)*4/6,top.y-(top.y-right.y)*4/6,250,60,5,3,-120))
			pointArray.push(new CustomPoint(top.x -(top.x-right.x)*3/6,top.y-(top.y-right.y)*3/6,200,30,5,4,-90))
			pointArray.push(new CustomPoint(top.x -(top.x-right.x)*2/6,top.y-(top.y-right.y)*2/6,200,30,5,4,-60))
			pointArray.push(new CustomPoint(top.x -(top.x-right.x)*1/6,top.y-(top.y-right.y)*1/6,200,30,5,4,-30))
		}
	}
}
import flash.events.Event;
import flash.geom.Point;
import flash.display.*;

class CustomPoint extends Sprite {
	private var _posX:Number;
	private var _posY:Number;
	private var _radiusX:Number;
	private var _radiusY:Number;
	private var degreeSpeedX:Number = 0;
	private var degreeSpeedY:Number = 0;
	private var defoPosX:Number;
	private var defoPosY:Number;
	private var speed:Number;
	private var _speedX:Number;
	private var _speedY:Number;
	
	public function CustomPoint(posX:Number,posY:Number,radiusX:Number = 100,radiusY:Number = 100,speedX:Number = 15, speedY:Number = 15, delay:Number = 0):void {
		_posX = defoPosX = posX;
		_posY = defoPosY = posY;
		_speedX = speedX;
		_speedY = speedY;
		degreeSpeedX += delay;
		degreeSpeedY += delay;
		
		_radiusX = radiusX;
		_radiusY = radiusY;
		speed = 5;
		addEventListener(Event.ENTER_FRAME, enterFrameHandler);
	}
	
	private function enterFrameHandler(e:Event):void {
		degreeSpeedX += _speedX;
		degreeSpeedY += _speedY;
		var radianX = degreeToRadian(degreeSpeedX);
		var radianY = degreeToRadian(degreeSpeedY);
		_posX = _radiusX * Math.sin(radianX/.8) + defoPosX;
		_posY = _radiusY * Math.cos(radianY/.8) + defoPosY;
	}
	
	private function degreeToRadian(degree:Number ):Number{
		var radian = degree * (Math.PI / 180);
		return radian;
	}
	
	public function get posX():Number { return _posX; }
	
	public function set posX(value:Number):void{
		_posX = value;
	}
	
	public function get posY():Number { return _posY; }
	
	public function set posY(value:Number):void{
		_posY = value;
	}
	
}
class CustomBitmap extends Bitmap {
	public function CustomBitmap(bmd:BitmapData):void {
		super(bmd);
		addEventListener(Event.ENTER_FRAME, enterFrameHandler);
	}
	
	private function enterFrameHandler(e:Event):void {
		x+= 5;
		y+= 20;
		alpha -= .3
		if (alpha <= 0){
			removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
			dispatchEvent(new Event("dispose"));
		}
	}
}