/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3JuLX
 */

package {
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    import flash.ui.Mouse;
    import flash.events.MouseEvent;
    import flash.media.Video;
    import flash.display.Sprite;
    import flash.display.GraphicsPathCommand;
    
    public class FlashTest extends Sprite {
        
        private var commands:Vector.<int>;
        private var data:Vector.<Number>;
        private var lineWidth:Number = 0;
        private var lineColor:uint = 0;
        
        public function FlashTest() {
            // write as3 code here..
            commands = new Vector.<int>();
            data = new Vector.<Number>();
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
        }
        
        private function onMouseDown(e:MouseEvent):void
        {
            commands.push(GraphicsPathCommand.MOVE_TO);
            data.push(mouseX, mouseY);
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
        
        private function onMouseMove(e:MouseEvent):void
        {
            commands.push(GraphicsPathCommand.LINE_TO);
            data.push(mouseX, mouseY);
            draw();
        }
        
        private function onMouseUp(e:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
        
        private function onKeyUp(e:KeyboardEvent):void
        {
            if(e.keyCode == Keyboard.DOWN)
            {
                lineWidth = Math.max(0, lineWidth - 1);
            }
            else if(e.keyCode == Keyboard.UP)
            {
                lineWidth++;
            }
            else if(e.keyCode == Keyboard.SPACE)
            {
                lineColor = Math.random() * 0xFFFFFF;
            }
            draw();
        }
        
        private function draw():void
        {
            graphics.clear();
            graphics.lineStyle(lineWidth, lineColor);
            graphics.drawPath(commands, data);
        }
    }
}