/**
 * Copyright test12 ( http://wonderfl.net/user/test12 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3JKF
 */

// forked from vasari's forked from: Particle Wave in 3D
// forked from Dan0's Particle Wave in 3D
/**
* 
* Created by Dan0
* Credits to:
* fladdict's "FITC Cool Japan side A / Particle simple 40000"
* sake's "3Dでアトラクタっぽいの"
*
*/
package {
    import org.papervision3d.view.BasicView;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.utils.ByteArray;
    import flash.geom.Point;
    import flash.geom.ColorTransform;
    
    import org.papervision3d.core.effects.utils.BitmapClearMode;
    import org.papervision3d.core.geom.Pixels;
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    import org.papervision3d.core.effects.BitmapLayerEffect;
    import org.papervision3d.core.effects.BitmapColorEffect;
    
    import org.papervision3d.core.geom.renderables.Vertex3DInstance;
    import org.papervision3d.core.geom.renderables.Vertex3D;
    
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.WireframeMaterial;
    
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.StageDisplayState;
   
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="30")] 
    
    public class wave_3d extends BasicView {
        //
        private var layer:BitmapEffectLayer;
        private var pixels:Pixels;
        private var container:DisplayObject3D;
        //
        private var particleNum:int = 500;
        private var particles:Vector.<Particle>
        
        private var loopX:Number = 200;
        private var loopY:Number  = 100;
        private var loopZ:Number  = 20;
        
        private var stormMap0:BitmapData;
        private var stormMap1:BitmapData;
        private var forceMap:BitmapData;
        
        private var stormScaleX:Number;
        private var stormScaleY:Number;
        private var stormScaleZ:Number;
        
        private var tempColt:ColorTransform = new ColorTransform();
        private var tempPt:Point = new Point();
        private var stormCycle:Number =0;
        
        public function wave_3d() {
            //setup stage
            super(0, 0, true, true);
            camera.focus=50;
            camera.zoom=40;
            
            //add rendering layers, pixels create trail by fading out using ColorMatrixFilter
            layer = new BitmapEffectLayer(viewport, stage.stageWidth, stage.stageWidth, true, 0, BitmapClearMode.CLEAR_PRE, true, false);
            viewport.containerSprite.addLayer(layer);
            layer.addEffect(new BitmapColorEffect(1, 1, 1, 0.98));
            
            container= new DisplayObject3D;
            scene.addChild(container);
            
            pixels = new Pixels(layer);
            container.addChild(pixels);
            
            var cubeMaterial:WireframeMaterial = new WireframeMaterial(0xFFFFFF, 0.2, 1);
            cubeMaterial.doubleSided = true;
            var cube:Cube = new Cube(new MaterialsList({all:cubeMaterial}), loopX, loopZ, loopY, 1,1,1,0,0);
            container.addChild(cube);
            
            //create particles
            particles = new Vector.<Particle>(particleNum);
            
            var particle:Particle;
            var rr:int;
            for(var i:int=0; i<particleNum; i++)
            {
                particle = new Particle();
                
               // var ang:Number = Math.random() * Math.PI*2;
                
                particle.x = Math.random() *loopX -(loopX/2);
                particle.y = Math.random() *loopY -(loopY/2);
                particle.z = Math.random() *loopZ -(loopZ/2);
                
                //Customize the range of the particle color according to the amount of the particle and stage size.
                particle.r = particle.g = particle.b = 70  
                
                //Customize the rage of the scaleFactor according to the amount of the particle and stage size.
                particle.scaleFactor = 0.0002;
                particles[i] = particle;
                
                particle.vfri = 0.98+Math.random()*0.01;
            }
            //
            forceMap = new BitmapData(256,256,false,0x000000);
            
            stormMap0 = new BitmapData(256,256,false,0x000000);
            stormMap0.perlinNoise(128,128,5,Math.random()*100,true,true,1|2|4,false);
            stormMap1 = new BitmapData(256,256,false,0x000000);
            stormMap1.perlinNoise(128,128,5,Math.random()*100,true,true,1|2|4,false);
            
            stormScaleX = 1 / loopX*255;
            stormScaleY = 1 / loopY*255;
            stormScaleZ = 1 / loopZ*255;
            
            //
            addEventListener(MouseEvent.CLICK ,function(e:Event):void{stage.displayState=StageDisplayState.FULL_SCREEN});
            
            //
            addEventListener(Event.ENTER_FRAME, updateParticles);
            
            startRendering();
        }
        
        public function updateParticles(e:Event):void{
            stormCycle++;
            if(stormCycle == 180){
                stormMap0.perlinNoise(128,128,5,Math.random()*100,true,true,1|2|4,false);
            }else if(stormCycle==360){
                stormMap1.perlinNoise(128,128,5,Math.random()*100,true,true,1|2|4,false);
                
                stormCycle = 0;
            }
            
            forceMap.copyPixels(stormMap1, stormMap0.rect, tempPt);
            tempColt.alphaMultiplier = Math.cos(stormCycle*Math.PI/180)*0.5+0.5;
            forceMap.draw(stormMap0, null, tempColt);
            
            ///////////////////////////////////////
            ///////////////////////////////////////
            
            pixels.removeAllpixels();
            
            var byteIndex:int;
            var col:uint;
            var colZ:uint;
            
            var p:Pixel3D;
            var prt:Particle;
            
            for(var i:int=0; i<particleNum; i++){
                prt = particles[i];
                
                col = forceMap.getPixel(int((prt.x+loopX/2)*stormScaleX),int((prt.y+loopY/2)*stormScaleY));
                colZ = forceMap.getPixel(int((prt.z+loopZ/2)*stormScaleZ),int((prt.y+loopY/2)*stormScaleY));
                
                prt.vx = prt.vx * prt.vfri + ((col>>16&0xff)-128)*prt.scaleFactor;
                prt.vy = prt.vy * prt.vfri + ((col>>8&0xff)-128)*prt.scaleFactor;
                prt.vz = prt.vz * prt.vfri + ((colZ&0xff)-128)*prt.scaleFactor;
                prt.x += prt.vx;
                prt.y += prt.vy;
                prt.z += prt.vz;
                
                if(prt.x<-loopX/2){
                    prt.x += loopX;
                }else if(prt.x > loopX/2){
                    prt.x -= loopX;
                }
                if(prt.y<-loopY/2){
                    prt.y += loopY;
                }else if(prt.y > loopY/2){
                    prt.y -= loopY;
                }
                if(prt.z< -loopZ/2){
                    prt.z += loopZ;
                }else if(prt.z > loopZ/2){
                    prt.z -= loopZ;
                }
                
               // var a:Vertex3D = new Vertex3D(prt.x,prt.y,prt.z);
               // var v3d:Vertex3DInstance = new Vertex3DInstance(prt.x,prt.y,prt.z);
               // layer.canvas.setPixel32(v3d.x*2+stage.stageWidth/2, v3d.y*2+stage.stageHeight/2, 0xFFFF00FF);
                
                p = new Pixel3D(0xFFFF00FF,prt.x,prt.y,prt.z);
                pixels.addPixel3D(p);
                
                var v3d:Vertex3DInstance;
            
            for each(p in pixels){
                v3d = p.vertex3D.vertex3DInstance;
                if(v3d.visible){
                    layer.canvas.setPixel32(20, 20, p.color);
                }
            }
            }
            
            
            
           container.rotationY += mouseY/256;
           container.rotationZ += mouseX/256;
           //container.rotationX = (stage.stageWidth/2-mouseX)/stage.stageWidth*360;
           //container.rotationZ = (stage.stageHeight/2-mouseY)/stage.stageHeight*360;
        }
    }
}

class Particle
{
    //particle position
    public var x:Number = 0;
    public var y:Number = 0;
    public var z:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var vz:Number = 0;
    
    //friction
    public var vfri:Number = 1; 
    
    //particle color
    public var r:int;
    public var g:int;
    public var b:int;
    
    //scale factor that affects the force applied to the particle.
    public var scaleFactor:Number;
}