/**
 * Copyright hacker_yk666qry ( http://wonderfl.net/user/hacker_yk666qry )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3IMv
 */

package {
	import flash.display.Sprite;
	import flash.events.*;
	
	/**
	 * ...
	 * @author ...
	 */
	[SWF ( width="465", height="465", backgroundColor="0x000000", frameRate="30" )]
	public class MyLoader extends Sprite {
		private var _box:ImgBox;
		
		//コンストラクタ
		public function MyLoader() {
			init();
		}
		
		public function init():void {
			stage.addEventListener( MouseEvent.CLICK, add);
		}
		
		public function add(e:MouseEvent):void {
			_box = new ImgBox();
			_box.x = stage.mouseX;
			_box.y = stage.mouseY;
			
			_box.init();
			_box.show();
			addChild(_box);
		}
	}	
}
import flash.display.*;
import flash.events.*;
import caurina.transitions.Tweener
import flash.net.URLRequest;




class ImgBox extends Sprite {
	
	private var _bgRect:Sprite;
	private var _lineRect:Sprite;
	private var _loader:Loader;
	private var _maskRect:Sprite;
	
	private const IMG_SIZE:Number = 100;
	private const HALF_SIZE:Number = IMG_SIZE / 2;
	
	public function ImgBox() {
	}
	
	public function init():void {
		
		_bgRect = new Sprite();
		_bgRect.graphics.beginFill( 0xffffff, 0.5 );
		_bgRect.graphics.drawRect( 0, 0, IMG_SIZE, IMG_SIZE );
		_bgRect.graphics.endFill();
		_bgRect.x = _bgRect.y = -HALF_SIZE;
		
		_lineRect = new Sprite();
		//太さ、色、アルファ、pixelHinting、ラインスケール(NONEで線の太さを変化させない)
		_lineRect.graphics.lineStyle( 1, 0xFFFFFF, 1, false, LineScaleMode.NONE );
		_lineRect.graphics.moveTo( 0, 0 );
		_lineRect.graphics.lineTo( IMG_SIZE, IMG_SIZE );
		_lineRect.graphics.moveTo( 0, IMG_SIZE );
		_lineRect.graphics.lineTo( IMG_SIZE, 0 );
		_lineRect.graphics.drawRect( 0, 0, IMG_SIZE, IMG_SIZE );
		_lineRect.x = _lineRect.y = -HALF_SIZE;
		
		_loader = new Loader();
		_loader.alpha = 0;
		
		_maskRect = new Sprite();
		_maskRect.graphics.beginFill( 0xffffff, 0.5 );
		_maskRect.graphics.drawRect( 0, 0, IMG_SIZE, IMG_SIZE );
		_maskRect.graphics.endFill();
		_maskRect.x = _maskRect.y = -HALF_SIZE;
		
		//レイヤーはaddChildした順に下から表示
		addChild( _bgRect );
		addChild( _lineRect );
		addChild( _loader );
		addChild( _maskRect );
		
		alpha = 0;
		scaleX = 0;
		scaleY = 0;
	}
	
	public function show():void {
		Tweener.addTween( this, { alpha:1, scaleX:0.2, scaleY:0.2, time:1, transition:"easeOutExpo", onComplete:open } );
	}
	
	public function open():void {
		Tweener.addTween( this, { scaleX:1, scaleY:1, time:0.5, transition:"easeOutElastic" } );
		Tweener.addTween( _maskRect, { alpha:1, x:-HALF_SIZE, y:-HALF_SIZE, width:1, time:0.5, delay:0.5, transition:"easeOutExpo", onComplete:load } );
	}
	
	public function load():void {
		//ProgressEvent.PROGRESSイベントはデータをダウンロードする間、繰り返し発生します
		_loader.contentLoaderInfo.addEventListener( ProgressEvent.PROGRESS, loading );
		_loader.contentLoaderInfo.addEventListener( Event.COMPLETE, complete ); 
		_loader.contentLoaderInfo.addEventListener( IOErrorEvent.IO_ERROR, errorHandler );
		
		_loader.load( new URLRequest("http://wonderfl.net/images/icon/4/48/480f/480f876800731772d8e7a547397888a08d8f71bfm") );
	}
	
	public function loading( e:ProgressEvent ):void {
		var percent:Number = e.bytesLoaded / e.bytesTotal;
		Tweener.addTween( _maskRect, { x:-HALF_SIZE, y:-HALF_SIZE, width:IMG_SIZE * percent, time:0.5, transition:"easeOutExpo" } );
	}

	public function complete( e:Event ):void {
		Tweener.addTween( _maskRect, { alpha:1, x:-HALF_SIZE, y:-HALF_SIZE, width:IMG_SIZE, time:0.5, transition:"easeOutExpo", onComplete:showImg } );
	}
	
	public function errorHandler(e:IOErrorEvent):void {
		trace( "IO_ERROR" + e.text );
	}
	
	public function showImg():void {
		Tweener.addTween( _maskRect, { x:HALF_SIZE, y: -HALF_SIZE, width:1, time:0.5, transition:"easeOutExpo" } );
		_loader.x = _loader.y = -HALF_SIZE;
		Tweener.addTween( _loader, { alpha:1, time:0.5, transition:"easeOutExpo" } );
	}
}