/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Hrx
 */

// forked from wh0's esc
package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    import flash.utils.*;
    import flash.text.*;
    import fl.controls.Button;
    
    import com.codeazur.as3swf.*;
    import com.codeazur.as3swf.data.*;
    import com.codeazur.as3swf.tags.*;
    import com.bit101.components.*;
    
    public class FlashTest extends Sprite {
        
        private static const PROXY:String = 'http://p.jsapp.us/proxy/';
        private static const BASE:String = 'http://hg.mozilla.org/tamarin-redux/raw-file/db3ebe261f68/esc/bin/';
        private static const ESC:Array = [
            'debug.es.abc',
            'util.es.abc',
            'bytes-tamarin.es.abc',
            'util-tamarin.es.abc',
            'lex-char.es.abc',
            'lex-token.es.abc',
            'lex-scan.es.abc',
            'ast.es.abc',
            'define.es.abc',
            'parse.es.abc',
            'asm.es.abc',
            'abc.es.abc',
            'emit.es.abc',
            'cogen.es.abc',
            'cogen-stmt.es.abc',
            'cogen-expr.es.abc',
            'esc-core.es.abc',
            'eval-support.es.abc',
            'esc-env.es.abc',
            'main.es.abc'
        ];
        private static const CODE:String =
            "use namespace 'flash.display';\n" +
            "class Movie extends Sprite {\n" +
            "\n" +
            "    public function Movie() {\n" +
            "        // write es4 code here..\n" +
            "        graphics.beginFill(0x0000FF);\n" +
            "        graphics.drawCircle(20, 20, 16);\n" +
            "    }\n" +
            "\n" +
            "}";
        
        private var progress:ProgressBar;
        private var loading:int = 0;
        private var esc:SWF;
        private var compileStringToBytes:Function;

        private var swf:SWF;
        private var movie:Loader;
        private var data:SWFData;
        
        private var pp:MovieClip;
        private var compileB:Button = new Button(); 
        private var saveB:Button = new Button();
        
        private var text_field:TextField = new TextField();
        private var text_fieldA:TextField = new TextField();
        
        
        public function FlashTest() {
            Security.loadPolicyFile('http://p.jsapp.us/crossdomain.xml');
            
            graphics.beginFill(0x456789);
            graphics.drawRect(0, 0, 465, 465);
            
            progress = new ProgressBar(this, 5, 5);
            progress.width = 455;
            progress.maximum = ESC.length;
            

            addChild(text_field);
            text_field.x = 260;
            text_field.y = 235;
            text_field.width  = 260; 
            text_field.height = 235;
            text_field.text = 'Loading... Please Wait...\n';
            
            esc = new SWF();
            esc.version = 9;
            esc.frameSize.xmax = 0;
            esc.frameSize.ymax = 0;
            esc.frameRate = 0;
            esc.compressed = false;
            esc.tags.push(new TagFileAttributes());
            
            loadESC();
            
        }
        
        private function trace(...args):void {
            //log.textField.scrollV = log.textField.maxScrollV;
            text_field.appendText(args.join(' ') + '\n');
            
        }
        
        private function loadESC():void {
            progress.value = loading;
            
            if (loading >= ESC.length) {
                runESC();
                return;
            }
            
            var ul:URLLoader = new URLLoader(new URLRequest(PROXY + BASE + ESC[loading]));
            ul.dataFormat = URLLoaderDataFormat.BINARY;
            ul.addEventListener(Event.COMPLETE, function (e:Event):void {
                esc.tags.push(TagDoABC.create(ul.data));
                loading++;
                loadESC();
            });
            
        }
        
        private function runESC():void {
            esc.tags.push(new TagShowFrame());
            esc.tags.push(new TagEnd());
            var data:SWFData = new SWFData();
            esc.publish(data);
            esc = null;
            var l:Loader = new Loader();
            l.contentLoaderInfo.addEventListener(Event.COMPLETE, completeESC);
            l.loadBytes(data, new LoaderContext(false, ApplicationDomain.currentDomain));
            
        }
        
        private function completeESC(evt:Event):void {
            compileStringToBytes = ApplicationDomain.currentDomain.getDefinition('ESC.compileStringToBytes') as Function;
            
            swf = new SWF();
            swf.version = 9;
            swf.frameSize.xmax = 8000;
            swf.frameSize.ymax = 4000;
            swf.frameRate = 30;
            swf.compressed = false;
            swf.tags.push(new TagFileAttributes());
            swf.tags.push(null);
            
            var tsc:TagSymbolClass = new TagSymbolClass();
            tsc.symbols.push(SWFSymbol.create(0, 'Movie'));
            swf.tags.push(tsc);
            swf.tags.push(new TagShowFrame());
            swf.tags.push(new TagEnd());
            
            // clear();
            trace('ESC Compiler Boot Complete');
            
            pp = new MovieClip();
            pp.x = 260;
            pp.y = 5;
            addChild(pp);
            pp.graphics.beginFill(0xCCCCCC, 1.0);    // 面のスタイル設定
            pp.graphics.drawRect(0, 0, 200, 200);
            
            removeChild(progress);
            progress = null;
            
            
            addChild(text_fieldA);
            text_fieldA.x = 5;        // x 座標
            text_fieldA.y = 5;        // y 座標
            text_fieldA.width  = 250;    // 幅
            text_fieldA.height = 455;    // 高さ
            text_fieldA.type = TextFieldType.INPUT;
            text_fieldA.text = CODE;
   

            addChild(compileB);
            compileB.label = "CompileB";
            compileB.x = 260;
            compileB.y = 210; 
            compileB.addEventListener(MouseEvent.CLICK, compile); 
            
            addChild(saveB);
            saveB.label = "SaveB";
            saveB.x = 360;
            saveB.y = 210; 
            saveB.addEventListener(MouseEvent.CLICK, save); 
            
            movie = new Loader();
            movie.x = 260;
            movie.y = 5;
            addChild(movie);
            
            compile(null);
            
        }
        
        
        private function compile(evt:MouseEvent):void {
            // clear();
            trace('Compiling...');
            try {
                var abc:ByteArray = compileStringToBytes(text_fieldA.text, 'Movie.as');
                
            } catch (error:Error) {
                trace(error);
                
            }
            
            swf.tags[1] = TagDoABC.create(abc, '', false);
            data = new SWFData();
            swf.publish(data);
            
            trace('Compile Complete (' + data.length + ' bytes)');
            
            trace('Reloading swf');
            movie.unloadAndStop();
            movie.loadBytes(data);
            
        }
        
        private function save(evt:MouseEvent):void {
            if (!data) return;
            new FileReference().save(data, 'movie.swf');
            
        }
        
    }
}






///






