/**
 * Copyright osamX ( http://wonderfl.net/user/osamX )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3HYp
 */

/*
    ゼルダトワプリっぽいのが作りたかった。
*/
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.core.math.Plane3D;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;
	
	[SWF(width="465", height="465", frameRate="30", backgroundColor="0xffffff")]
	public class Twilight extends Sprite  
	{
		private var viewport:Viewport3D;
		private var scene:Scene3D;
		private var camera:Camera3D;
		private var renderer:BasicRenderEngine;
		
		private const PLANE_NUM:Number = 128; //Planeの個数
		private var planeArray:Array = new Array(PLANE_NUM);
		private var speedArray:Array = new Array(PLANE_NUM);
		
		/* コンストラクタ */
		public function Twilight():void 
		{	
			initPV3D();
			
			var material:ColorMaterial = new ColorMaterial( 0x000000 );
			material.oneSide = false;	//両面
			material.fillAlpha = 0.7;	//透明度
			
			for (var i:int = 0; i < PLANE_NUM; i++ ) {
				planeArray[i] = createPlane( material ); //Planeを作る
				speedArray[i] = 10 * Math.random() + 2; //PlaneのSpeed決定
			}
			
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		/* EnterFrame */
		private function onEnterFrame( event:Event ):void {
			var blur:Number;
			var cameraRotation: Number = 360 * stage.mouseX / stage.width;
			for (var i:int = 0; i < PLANE_NUM; i++ ) {
				var obj:Plane = planeArray[i] as Plane;
				obj.rotationY += speedArray[i] * 0.7;
				obj.y = ( planeArray[i].y + speedArray[i] * 0.5 ) % 2000;
				blur = getDistance(obj.x, obj.y, obj.z) / 50;
				obj.filters = [new BlurFilter(blur, blur, 2)];
			}
			camera.y = 500;
			camera.x = 500 * Math.cos( 2 * Math.PI * cameraRotation / 360 );
			camera.z = 500 * Math.sin( 2 * Math.PI * cameraRotation / 360 );
			camera.localRotationY = cameraRotation + 90;
			renderer.renderScene( scene, camera, viewport );
		}
		
		/* Planeを作る */
		private function createPlane( material:ColorMaterial ):Plane {
			var size:Number = 20 * Math.random() + 20;
			var plane:Plane = new Plane(material, size, size);
			plane.x = 1000 * Math.random() - 500;
			plane.y = 2000 * Math.random();
			plane.z = 1000 * Math.random() - 500;
			plane.rotationY = 360 * Math.random();
			plane.useOwnContainer = true;
			scene.addChild(plane);
			return plane;
		}
		
		/* カメラからの距離計算 */
		private function getDistance(_x:Number, _y:Number,_z:Number):Number {
			var tmp:Number = 0;
			tmp = (_x - camera.x) * (_x - camera.x);
			tmp += (_y - camera.y) * (_y - camera.y);
			tmp += (_z - camera.z) * (_z - camera.z);
			return Math.abs(Math.sqrt(tmp) - 500);
		}
		
		/* いろいろ初期化 */
		private function initPV3D():void {
			viewport = new Viewport3D(465,465);
			scene = new Scene3D();
			camera = new Camera3D();
			renderer = new BasicRenderEngine();
			addChild(viewport);viewport = new Viewport3D();
			scene = new Scene3D();
			camera = new Camera3D();
			renderer = new BasicRenderEngine();
			addChild(viewport);
		}
	}
}