/**
 * Copyright 3f5 ( http://wonderfl.net/user/3f5 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3HPI
 */

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var radius:int = 70;
            var alpha:Number = 1 / 3;
            
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 645, 645);
            graphics.endFill();

            graphics.beginFill(0xFF00FF, alpha);
            drawCircle(radius * 1.5, radius, radius);
            graphics.endFill();
            
            graphics.beginFill(0xFFFF00, alpha);
            drawCircle(radius * 1, radius * 2, radius);
            graphics.endFill();

            graphics.beginFill(0x00FFFF, alpha);
            drawCircle(radius * 2, radius * 2, radius);
            graphics.endFill();
            
            var pointRadius:int = 1;
            
            //graphics.beginFill(0xFF0000);
            graphics.drawCircle(radius * 1.5, radius, pointRadius);
            graphics.drawCircle(radius * 1, radius * 2, pointRadius);
            graphics.drawCircle(radius * 2, radius * 2, pointRadius);
            //graphics.endFill();
        }
        
        private function drawCircle(x:int, y:int, radius:int):void {
            var cx:uint, cy:int, d:int, dH:int, dD:int;

            d   = 1 - radius;
            dH  = 3;
            dD  = 5 - 2 * radius;
            cy  = radius;

            for (cx = 0; cx <= cy; cx++) {
                if (d < 0) {
                    d   += dH;
                    dH  += 2;
                    dD  += 2;
                }
                else {
                    d   += dD;
                    dH  += 2;
                    dD  += 4;
                    --cy;
               }

                graphics.lineTo(cy + x, cx + y);
                graphics.lineTo(cx + x, cy + y);
                graphics.lineTo(-cx + x, cy + y);
                graphics.lineTo(-cy + x, cx + y);
                graphics.lineTo(-cy + x, -cx + y);
                graphics.lineTo(-cx + x, -cy + y);
                graphics.lineTo(cx + x, -cy + y);
                graphics.lineTo(cy + x, -cx + y);
            }
        }
    }
}