/**
 * Copyright nayu ( http://wonderfl.net/user/nayu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3HHN
 */

// forked from yd_niku's FlyWeight Sample
package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    
    import com.flashdynamix.utils.SWFProfiler;
    
    public class FlyWeightSample extends Sprite {
        private var _clickFileld:Sprite;
        private var _imageFileld:Sprite;
        
        public function FlyWeightSample() {
            // container
            _imageFileld = new Sprite();
            addChild(_imageFileld);
            
            setupClickField(465, 465);
            
            setupTitle("FlyWeight Pattern Sample");
            
            var resouce:BitmapDataResource = new BitmapDataResource ( ResourceMap.IMG );
            resouce.addEventListener( Event.COMPLETE, onComplete );
            resouce.load();
            
            SWFProfiler.init(this);
        }
        private function onComplete (e:Event):void {
            clearImages();
            viewImages( 10, 10 );
        }
        private function onClick(e:Event ):void{
            clearImages();
            viewImages( (Math.random()*10>>0)+1, (Math.random()*10>>0)+1 );
        }
        
        private function setupClickField( w:int, h:int ):void {
            _clickFileld = new Sprite();
            _clickFileld.graphics.beginFill(0xFFFFFF, 0);
            _clickFileld.graphics.drawRect(0, 0, w, h);
            _clickFileld.graphics.endFill();
            _clickFileld.addEventListener(MouseEvent.CLICK, onClick);
            _clickFileld.buttonMode = true;
            addChild(_clickFileld);
        }
        
        private function setupTitle( str:String ):void {
            var textField :TextField = new TextField();
            textField.x = 20;
            textField.y = 200;
            textField.width = 420;
            textField.height= 48;
            var tf:TextFormat =  new TextFormat( null, 36, 0x000000,  true );
            tf.align = TextFormatAlign.CENTER;
            textField.defaultTextFormat = tf;
            textField.text = str;
            textField.blendMode = BlendMode.INVERT;
            textField.mouseEnabled = false;
            textField.selectable = false;
            addChild(textField);
        }
        
        public function viewImages( w:int, h:int ):void{
            for( var i :int = 0; i<w; ++i ) {
                for( var j :int = 0; j<h; ++j ) {
                    var tile:DisplayObject = _imageFileld.addChild( new Bitmap( BitmapDataResource.getResource( ResourceMap.IMG ) ) );
                    tile.x = i * 46;
                    tile.y = j * 46;
                    tile.width = tile.height = 46;
                }
            }
        }
        public function clearImages():void{
            var num:int = _imageFileld.numChildren;
            while( num-- ) {
                var bmp:Bitmap = _imageFileld.removeChildAt(0) as Bitmap;
                bmp.bitmapData = null;
                bmp = null;
            }
        }
    }
}

internal class ResourceMap {
    public static const IMG:String = "http://assets.wonderfl.net/images/related_images/7/74/741f/741fc0b9afc2ddb3db777a9d2c3c4705dc064054";
}

import flash.display.*;
import flash.events.*;
import flash.net.*;
import flash.utils.*;
import flash.system.*;

internal class BitmapDataResource extends EventDispatcher {
        private static var _resources:Dictionary = new Dictionary();
        
        private var _key: String;
        public function BitmapDataResource ( key:String ) {
            _key = key;
        }
        public function load():void {
            var req:URLRequest = new URLRequest(_key);
            
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener( Event.COMPLETE, onLoadComplete );
            loader.load( req, new LoaderContext(true) );
        }
        private function onLoadComplete(e:Event):void {
            var loaderInfo :LoaderInfo = e.target as LoaderInfo;
            var content:Bitmap = Loader( loaderInfo.loader ).content as Bitmap;
            _resources[ _key ] = content.bitmapData;
            
            dispatchEvent( new Event(Event.COMPLETE) );
        }
        
        public static function getResource( key:String ) :BitmapData{
            return _resources[ key ] as BitmapData;
        }
}