/**
 * Copyright rainafter ( http://wonderfl.net/user/rainafter )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3HFs
 */

// forked from rainafter's forked from: flash on 2010-2-7
// forked from _ryotaros's flash on 2010-2-7
package {
	import flash.display.Sprite;
    import flash.events.Event;
    public class FlashTest extends Sprite {
        
        public var Particles:Array;
        public var ball:Ball;
        public var numParticle:int = 15;
        
        public var minDist:Number = 100;
        public var spring:Number = 0.005;
        public var size:int;
        
        public function FlashTest() {
           init();
        }
        
        public function init():void{
        		Particles =[];
        		for (var i:int = 0; i <numParticle; i++){
        			Particles.push(new Ball(5));
        			size = Math.random()* 3 + 2;
        			Particles[i].scaleY = Particles[i].scaleX = size;
        			Particles[i].mass = size;
        			Particles[i].x = Math.random() * stage.stageWidth;
        			Particles[i].y = Math.random() * stage.stageHeight;
        			Particles[i].vx = Math.random()* 6 - 3;
        			Particles[i].vy = Math.random() * 6 - 3;
        			addChild(Particles[i]);
        		}
        		
        		addEventListener(Event.ENTER_FRAME, onenterframe);
        }
        
        public function onenterframe(e:Event):void{
        		for (var i:int = 0;i < numParticle;i++){
        			var p:Ball = Particles[i];
        			p.x += p.vx;
        			p.y += p.vy;
        			if (p.x >stage.stageWidth + p.width/2){
        				p.x =0;
        			} else if (p.x < -p.width){
        			 	p.x = stage.stageWidth;	
        			}
        			if (p.y > stage.stageHeight + p.height/2){
        				p.y = 0;
        			} else if (p.y < -p.height) {
        				p.y = stage.stageHeight;	
        			}
        		}
        		
        		for (i = 0; i < numParticle;i++){
        			var pA:Ball = Particles[i];
        			for (var j:int = 0;j < numParticle - 1;j++){
        				var pB:Ball = Particles[j];
        				Spring(pA,pB);
        			}
        		}
        	
    			graphics.clear();
    			particleLine();   		
        }
        
        public function Spring(pA:Ball,pB:Ball):void{
        		var dx:Number = pB.x - pA.x;
        		var dy:Number = pB.y - pA.y;
        		var dist:Number = Math.sqrt(dx * dx + dy * dy);
        		if (dist < minDist){
        				var ax:Number = dx * spring;
        				var ay:Number = dy * spring;
        				pA.vx += ax / pA.mass;
        				pA.vy += ay / pA.mass;
        				pB.vx -= ax / pB.mass;
        				pB.vy -= ay / pB.mass;
       		}
        }
        
        public function particleLine():void{
        		for (var i:int = 0;i < numParticle -1; i++){
	        			graphics.lineStyle(1,0xaaaaaa);
	        			graphics.lineTo(Particles[i].x, Particles[i].y);
	        			graphics.moveTo(Particles[i].x, Particles[i].y);
        		}
        }
    }
}

import flash.display.Sprite;

class Ball extends Sprite {
	
	public var mass:int;
	public var vx:Number;
	public var vy:Number;
	
	public function Ball (r:Number = 5,color:uint = 0x000000){
		graphics.lineStyle(0);
		graphics.beginFill(color);
		graphics.drawCircle(0,0,r);
		graphics.endFill();
		
	}
	
		
}