/**
 * Copyright jamasian ( http://wonderfl.net/user/jamasian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Gtd
 */

/*
      _                           _             
     | |                         (_)            
     | | __ _ _ __ ___   __ _ ___ _  __ _ _ __  
 _   | |/ _` | '_ ` _ \ / _` / __| |/ _` | '_ \ 
| |__| | (_| | | | | | | (_| \__ \ | (_| | | | |
 \____/ \__,_|_| |_| |_|\__,_|___/_|\__,_|_| |_|

Copyright 2010, Kaiyi Chan
*/

/*
-> Notes:
using screen detector as element searcher
it is able to detect surrounding elements with a simple screen algorithm.

Press space to remove elements.
*/
package
{
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.KeyboardEvent;
    
    [SWF(width="465", height="465", frameRate="125", backgroundColor="0x000000")]
    
    public class testClass extends Sprite
    {
        public var bmd:BitmapData;
        public var getPixelColor:uint;
        public var mouseClick:Boolean;
        public var testField:TextField =    new TextField();
        public var getCurrentColor:uint=    0xFF0000 * Math.random(); //0xFF0000;

        
        public function testClass() { onLoad(); }
        
        public function onLoad():void
        {
            bmd = new BitmapData(465, 465, false, 0x000000);
            addChild(new Bitmap(bmd));  
            
            stage.addEventListener(Event.ENTER_FRAME, loop);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, detectKey);
        }
        
        
        public function loop(evt:Event):void
        {
            gravHandler();
            mouseClickCreateDot();

            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseClickDown);
       }

        private function mouseClickDown(evt:Event):void
        {
            this.mouseClick = true;
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseClickUp);
            stage.removeEventListener(MouseEvent.MOUSE_DOWN, mouseClickDown);
        }

        private function mouseClickUp(evt:Event):void
        {
            this.mouseClick = false;
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseClickDown);
            stage.removeEventListener(MouseEvent.MOUSE_UP, mouseClickUp);
        }

        public function gravHandler():void
        {
            this.bmd.lock();
            
            for (var y:int=this.bmd.height-5; y>0; y--)
            {
                for (var x:int=this.bmd.width; x>0; x--)
                {
                    getPixelColor    =    this.bmd.getPixel(x, y);
                    
                    //handler object: unique
                    if (getPixelColor != 0x000000)
                    {
                        var posx:int=    x;// + (Math.random()*3)-(Math.random()*3);
                        var posy:int=    y + (Math.random()*3);

                        if (this.bmd.getPixel(posx, posy) == 0x000000)
                        {
                            this.bmd.setPixel(x, y, 0);
                            this.bmd.setPixel(posx, posy, getPixelColor);
                        }

                    }
                }
            }
            this.bmd.unlock();
        }  
        
        public function detectKey(evt:KeyboardEvent):void
        {
            if (evt.keyCode == 32)
            {
                this.getCurrentColor    =    0xFF0000 * Math.random();
            }
            
            if (evt.keyCode == 68)
            {
                for (var posx:int=mouseX-12;posx<=mouseX+12;posx++)
                {
                    for (var posy:int=mouseY-12;posy<=mouseY+12;posy++)
                    {
                        this.bmd.setPixel(posx, posy, 0x000000);
                    }
                }
            }
        }
        
        
        public function mouseClickCreateDot():void
        {
            if (this.mouseClick)
            {
                
                /*        spray-level        */
                var d:int = 20;
                
                if (mouseX > 0 && mouseX < 465 && mouseY > 0 && mouseY < 465)
                {
                    for (var i:int = 0;i<=d*5;i++)
                    {
                        var posx:int=    mouseX + (Math.random()*d)-(Math.random()*d);
                        var posy:int=    mouseY + (Math.random()*d)-(Math.random()*d);

                        if (this.bmd.getPixel(posx, posy) == 0x000000)
                        {
                            this.bmd.setPixel(posx, posy, this.getCurrentColor); //this.element.getType().color)
                        }
                    }
                }
            }
         }

    }
}