/**
 * Copyright Nao_u ( http://wonderfl.net/user/Nao_u )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3GhW
 */

package {    
    import flash.display.Sprite;    
    import flash.events.*;    
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]     
    public class FlashTest extends Sprite {    
        public function FlashTest() {    
            Main = this;    
            initialize();    
            stage.addEventListener(Event.ENTER_FRAME,update);     
        }    
    }    
}            
import flash.display.Sprite;    
import flash.text.*;
import flash.events.*;    
import flash.geom.*; 
var SCREEN_W:Number = 465, SCREEN_H:Number = 465;   
var Main:Sprite;    

var EaseOutAry:Vector.<EaseOut>;
var EaseOut0:EaseOut;

// x
function linear( x:Number ):Number{
    return x;
}

// 0.5-cos(x*PI)*0.5"
function type0( x:Number ):Number{
    return 0.5 - Math.cos(x*Math.PI)*0.5;
}

// 3x^2 - 2x^3
function type1( x:Number ):Number{
    return 3*x*x - 2*x*x*x;
}

// 1.0 - exp(-3.0 * x)
function type2( x:Number ):Number{
    return 1.0 - Math.exp(-3.0 * x);
}

// 1-(1-x)^3
function type3( x:Number ):Number{
    return 1-(1-x)*(1-x)*(1-x);
}

// 1-pow(1-x,3)
function type4( x:Number ):Number{
    return 1-Math.pow(1-x,3);
}



function initialize():void{    
    EaseOutAry = new Vector.<EaseOut>;
    EaseOutAry.push( new EaseOut( 8,75*0+8,"x",                   linear) );
    EaseOutAry.push( new EaseOut( 8,75*1+8,"0.5-cos(x*PI)*0.5",   type0) );
    EaseOutAry.push( new EaseOut( 8,75*2+8,"3x^2 - 2x^3",         type1) );
    EaseOutAry.push( new EaseOut( 8,75*3+8,"1.0 - exp(-3.0 * x)", type2) );
    EaseOutAry.push( new EaseOut( 8,75*4+8,"1-(1-x)^3",           type3) );
    EaseOutAry.push( new EaseOut( 8,75*5+8,"1-pow(1-x,3)",        type4) );
}    

function update(e :Event):void{    
    graphicClear();  
    for( var i:int=0; i<EaseOutAry.length; i++ ){
        EaseOutAry[i].update();
        EaseOutAry[i].draw();
    }
} 

class EaseOut {
    private var X:int, Y:int;
    private var Text:TextField   
    private var Time:Number;
    private var t:Number;
    private var f:Function;
    
    public function EaseOut( x:int, y:int, name:String, func:Function ){
        X = x;
        Y = y;
        Text = new TextField();    
        Text.text = name;  
        Text.autoSize = "left";  
        Text.x = X;
        Text.y = Y;
        Main.addChild(Text);     
        Time = 0;
        f = func;
    }
    
    public function update():void{
        Time += 0.01;
        t = Time - int(Time);
        if( (int(Time) % 2) == 1 ){
            t = 1.0 - t;
        }
    }
    
    public function draw():void{
        drawRect( X, Y, 450, 70, 0xffffc0 );    
        drawCircle( X+35+f(t)*320, Y+40, 20, 0xffff40 );

        var bx:Number = X+385, by:Number = Y+5, size:Number = 60, step:Number = 0.05;
        drawRect( bx, by, size, size, 0xffffe0 );
        for( var i:Number=0; i<=1.0; i+=step ){
            drawLine( bx+i*size, by+(1-f(i))*size, bx+(i+step)*size, by+(1-(f(i+step)))*size, 1, 0x000000);    
        }
        drawCircle( bx+t*size, by+(1-f(t))*size, 2, 0xff0000 );
    }
}

function graphicClear():void{  
    Main.graphics.clear();   
}  

function drawCircle( x:Number, y:Number, size:Number, col:int ):void{    
    Main.graphics.lineStyle(2.0,0x000000);       
    Main.graphics.beginFill( col, 1 );    
    Main.graphics.drawCircle( x, y, size );    
    Main.graphics.endFill();    
}   

function drawRect( x:Number, y:Number, w:Number, h:Number, col:int ):void{    
    Main.graphics.lineStyle(1.0,0x000000);       
    Main.graphics.beginFill( col, 1 );    
    Main.graphics.drawRect( x, y, w, h );    
    Main.graphics.endFill();    
}   

function drawLine( sx:Number, sy:Number, ex:Number, ey:Number, size:Number, col:int ):void{    
    Main.graphics.lineStyle(size,col);       
    Main.graphics.moveTo( sx, sy );       
    Main.graphics.lineTo( ex, ey );          
}
