/**
 * Copyright tronster ( http://wonderfl.net/user/tronster )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Ga9
 */

/**
	Sin
	Tronster - http://tronster.com

	Use the mouse-wheel to tweak forward/backward in time.
	Spacebar to reset and mouse-wheel time tweaking.
*/
package 
{
	import flash.display.BlendMode;
	import flash.display.Sprite;
	import flash.events.*;
	import flash.filters.GlowFilter;
	import flash.utils.getTimer;
	
    [SWF(backgroundColor="#101010", frameRate=61)]	
	public class SinClass extends Sprite 
	{
		// Change maximum # of sine waves.
		private const MAX_SINS	:int = 21;
		
		// Setup...
		private var halfHeight	:Number;
		private var advance		:int = 0;		
	
		// Ctor
		public function SinClass() 
		{
			blendMode = BlendMode.LIGHTEN;
			this.cacheAsBitmap = false; 
			
			this.filters = [    
				new GlowFilter( 0x00ff00, 0.5, 16, 16, 2 ,3)
				,new GlowFilter( 0x0000ff, 0.5,  4,  4, 3 ,3) ];
			
			addEventListener( Event.ADDED_TO_STAGE, onAddedToStage );
        }
		
		// This is on the stage; wire listeners.
		private function onAddedToStage( e:Event ):void 
		{
			removeEventListener( Event.ADDED_TO_STAGE, onAddedToStage );
			halfHeight = stage.stageHeight * 0.5;
			addEventListener( Event.ENTER_FRAME, onFrame );
			stage.addEventListener( KeyboardEvent.KEY_DOWN, onDown );
			stage.addEventListener( MouseEvent.MOUSE_WHEEL, onWheel );			
		}
		
		// Draw a Sine wave
		private function drawSin( xoff:Number, color:uint, freq:Number ) :void 
		{
			graphics.moveTo(0, (Math.sin((xoff) * freq) * (Math.sin(xoff*.00001) * halfHeight) ) + halfHeight);
			graphics.lineStyle(3, color, 0.5, false );
			var dot:Number;
			for( var i:Number=0; i < stage.stageWidth; i++ )
			{
				dot = (Math.sin((i + xoff) * freq) * (Math.sin(xoff*.00001) * halfHeight));
				graphics.lineTo(i, dot + halfHeight);
			}
		}
				
		// Called once a frame
		private function onFrame( e:Event ):void {
			var t:int = getTimer() + advance;   
			graphics.clear();
			for(var i:int = 1; i < MAX_SINS; ++i)
				drawSin( t * (i * 0.1), makeColor(t * (0.1 * i)), 0.0001 * i );
		}
		
		// Create a color based on time offset
		private function makeColor( off:int ) :uint {
			var g:Number = 0.5 + (((off + 64) % 96) / 255);
			var b:Number = 0.5 + ((off % 128) / 255);
			return colorRGB(0.3,g,b);
		}
		
		// r,g,b values 0.0 to 1.0
		// returns hex color
		private function colorRGB(r:Number,g:Number,b:Number):uint {
			var c:uint = int(r * 255) << 16;
			c |= int(g * 255) << 8;
			c |= int(b * 255);  
			return c;
		}
		
		private function onDown( e:KeyboardEvent ):void { advance = 0 ; }
		private function onWheel( e:MouseEvent ) :void  { advance += (e.delta * 500); }
	}
}
