/**
 * Copyright 883108 ( http://wonderfl.net/user/883108 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3GYT
 */

package  {
    
    import flash.display.MovieClip;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.display.Sprite;
    
    
    public class RandomLIneMain extends MovieClip {
        private var _points:Vector.<Point> = new Vector.<Point>;
        private const POINT_NUM:Number = 5;
        
        public function RandomLIneMain() {
            var w:Number = this.stage.stageWidth;
            var h:Number = this.stage.stageHeight;
            var tf:TextField;
            var dotCanvas:Sprite = addChild(new Sprite) as Sprite;
            for(var i:int = 0; i< POINT_NUM; i++){
                _points[i] = new Point(Math.random()*w|0, Math.random()*h|0);
                addChild(tf = new TextField());
                tf.x = _points[i].x;
                tf.y = _points[i].y;
                tf.text = 'p[' + i + '] ' + 'x : ' + tf.x + 'y : ' + tf.y;
                
                dotCanvas.graphics.beginFill(0x004444);
                dotCanvas.graphics.drawCircle(tf.x, tf.y, 2);
            }
            
            graphics.lineStyle(0, 0x33aaff);
            graphics.moveTo(_points[0].x, _points[0].y);
            var targetPoint:Point;
            for(i = 1; i< POINT_NUM - 2; i++){
                trace(i);
                targetPoint = new Point(    (_points[i].x + _points[i+1].x)/2
                                        ,    (_points[i].y + _points[i+1].y)/2);
                graphics.curveTo(_points[i].x, _points[i].y, targetPoint.x, targetPoint.y); 
                addChild(tf = new TextField());
                tf.x = targetPoint.x;
                tf.y = targetPoint.y;
                tf.text = 't[' + i + '] ' + 'x : ' + tf.x + 'y : ' + tf.y;
                
                dotCanvas.graphics.beginFill(0x6688BB);
                dotCanvas.graphics.drawCircle(targetPoint.x, targetPoint.y, 2);
            }
            trace(POINT_NUM -2);
            trace(POINT_NUM -1);
            graphics.curveTo(_points[POINT_NUM -2].x, _points[POINT_NUM -2].y, _points[POINT_NUM -1].x, _points[POINT_NUM -1].y)
        }
    }
    
}
