/**
 * Copyright PESakaTFM ( http://wonderfl.net/user/PESakaTFM )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Fyk
 */

/*
Created by: PESakaTFM
Inspired by http://www.loadedrecords.com/assets/plecs.swf
I don't know who made that one, but I kind of liked the idea.
Mine is different from the original that inspired me (I assume) 
because I draw everything to a bitmap instead of using (and reusing) 
lots of MovieClips.
I'm hoping this will give people more flexibility for effects.
*/

package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.geom.Point;

	[SWF(width=600, height=360, backgroundColor='#000000', frameRate=30)]
	public class Main extends Sprite
	{
		public const MAX:int = 30;
		public var lastType:int = 2;
		public var curType:int = 0;
		public var gy:int = 0;
		public var gx:int = 0;
		public var dir:int = 0;
		public var path:CurvingPath;
		
		public var bmp:Bitmap;
		public var bmd:BitmapData;
		public var matrix:Matrix;
		
		public var GridSize:Point = new Point(5,3);
		
		public function Main()
		{
			path = new CurvingPath();
			path.end = step;
			path.draw = draw;
			
			bmd = new BitmapData(600, 360, false, 0);
			bmp = new Bitmap(bmd, 'auto', true);
			matrix = new Matrix(1,0,0,1,0,0);
			this.addChild(bmp);
			
			this.graphics.lineStyle(1,0,1);
			this.graphics.drawRect(0,0,GridSize.x*120,GridSize.y*120);
			this.graphics.endFill();
			step();
		}
		
		protected function draw():void
		{
			var angle:Number = Math.PI * .5 * dir;
			
			matrix.a = matrix.d = Math.cos(angle);
			matrix.b = Math.sin(angle);
			matrix.c = -matrix.b;
			matrix.tx = gx*120;
			matrix.ty = gy*120;
			
			bmd.draw(path, matrix, null, null, null, true);
		}
		
		protected function step():void
		{
			curType = Math.floor(2.99*Math.random());
			
			if(lastType == 0)
			{
				dir += 1;
			}
			else if(lastType == 1)
			{
				switch(dir)
				{
					case 0:
						gy += 1;
						gx += 1;
						break;
					case 1:
						gy += 1;
						gx -= 1;
						break;
					case 2:
						gy -= 1;
						gx -= 1;
						break;
					case 3:
						gy -= 1;
						gx += 1;
						break;
				}
				dir -= 1;
			}
			else if(lastType == 2)
			{
				switch(dir)
				{
					case 0:
						gy += 1;
						break;
					case 1:
						gx -= 1;
						break;
					case 2:
						gy -= 1;
						break;
					case 3:
						gx += 1;
						break;
				}
			}
			if(dir == 4) dir = 0;
			else if(dir == -1) dir = 3;
			
			switch(dir)
			{
				case 0:
					if(gy >= GridSize.y) gy = 0;
					if(gx >= GridSize.x) gx = 0;
					if(gy < 0) gy = GridSize.y-1;
					if(gx < 0) gx = GridSize.x-1;
					break;
				case 1:
					if(gy >= GridSize.y) gy = 0;
					if(gx > GridSize.x) gx = 1;
					if(gy < 0) gy = GridSize.y-1;
					if(gx <= 0) gx = GridSize.x;
					break;
				case 2:
					if(gy > GridSize.y) gy = 1;
					if(gx > GridSize.x) gx = 1;
					if(gy <= 0) gy = GridSize.y;
					if(gx <= 0) gx = GridSize.x;
					break;
				case 3:
					if(gy > GridSize.y) gy = 1;
					if(gx >= GridSize.x) gx = 0;
					if(gy <= 0) gy = GridSize.y;
					if(gx < 0) gx = GridSize.x-1;
					break;
			}
			
			path.init(curType);
			lastType = curType;
		}
	}
}

	import flash.display.Sprite;
	import flash.events.Event;
	import flash.display.Graphics;

class CurvingPath extends Sprite
{
	private var count:int = 30;
	public var type:int = 0;
	
	public var end:Function;
	public var draw:Function;
	
	public const COLORS:Array = [0xFF0000, 0xFFFF00, 0x00FF00, 0x00FFFF, 0x0000FF, 0xFF00FF];
	public const LINE_WIDTH:int = 15;
	public const SQUARE_WIDTH:int = 120;
	
	public function CurvingPath()
	{
		
	}
	
	public function init(type:int = 0):void
	{
		this.graphics.clear();
		this.type = type;
		this.count = 15;
		this.addEventListener(Event.ENTER_FRAME, onEnter);
	}
	
	protected function onEnter(e:Event):void
	{
		count--;
		var i:int = 0;
		var a:int = 0;
		var angle:int = 90-(count*6);
		var h:int = this.SQUARE_WIDTH-(count*8);
		var g:Graphics = this.graphics;
		
		if(this.type == 0)
		{
			for(i=0; i<6; i)
			{
				g.beginFill(COLORS[i], 1);
				g.moveTo(i*LINE_WIDTH, 0);
				for(a=0; a<=angle; a++)
				{
					g.lineTo(i*LINE_WIDTH*Math.cos(Math.PI*a/180), i*LINE_WIDTH*Math.sin(Math.PI*a/180));
				}
				i++;
				for(a--; a>=0; a--)
				{
					g.lineTo(i*LINE_WIDTH*Math.cos(Math.PI*a/180), i*LINE_WIDTH*Math.sin(Math.PI*a/180));
				}
				g.endFill();
			}
		}
		else if(this.type == 1)
		{
			for(i=2; i<8; i)
			{
				g.beginFill(COLORS[7-i], 1);
				g.moveTo(i*LINE_WIDTH, 0);
				for(a=0; a<=angle; a++)
				{
					g.lineTo(i*LINE_WIDTH*Math.cos(Math.PI*(180-a)/180)+SQUARE_WIDTH, i*LINE_WIDTH*Math.sin(Math.PI*(180-a)/180));
				}
				i++;
				for(a--; a>=0; a--)
				{
					g.lineTo(i*LINE_WIDTH*Math.cos(Math.PI*(180-a)/180)+SQUARE_WIDTH, i*LINE_WIDTH*Math.sin(Math.PI*(180-a)/180));
				}
				g.endFill();
			}
		}
		else if(this.type == 2)
		{
			for(i=0; i<6; i)
			{
				g.beginFill(COLORS[i], 1);
				g.moveTo(i*LINE_WIDTH, 0);
				g.lineTo(i*LINE_WIDTH, h);
				i++;
				g.lineTo(i*LINE_WIDTH, h);
				g.lineTo(i*LINE_WIDTH, 0);
				g.endFill();
			}
		}
		draw();
		if(count <= 0)
		{
			this.removeEventListener(Event.ENTER_FRAME, onEnter);
			end();
		}
	}
}