/**
 * Copyright Knuckle ( http://wonderfl.net/user/Knuckle )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3FXN
 */

// forked from tkinjo's カエルの卵
// forked from tkinjo's ひもっぽい何か
// forked from tkinjo's 点の追従
package  
{
	/**
	 * 参考
	 * 
	 * bouze's hybrid-brush-05
	 * http://wonderfl.kayac.com/code/ff5d0155b7268a766c3bc22da04be974a0778d0e
	 */
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.geom.Point;
	
	[SWF(width="465", height="465", frameRate="60", backgroundColor="0xeeeeff")]
	/**
	 * ...
	 * @author tkinjo
	 */
	public class Main extends Sprite {
		
		// 点の数
		private const dotNum:int = 100;
		
		// 点の半径
		private const dotRadius:uint = 1;
		
		// 点と点との距離
		private const distance:uint = 5;
		
		
		// 点の配列
		private var dots:Array = new Array();
		
		/**
		 * コンストラクタ
		 */
		public function Main() {
			
			createDots();
			
			// フレームごとにループ
			addEventListener(Event.ENTER_FRAME, function( event:Event ):void {
					
					calc();
					draw();
				} );
		}
		
		/**
		 * 点の作成
		 */
		private function createDots():void {
			
			for ( var i:uint = 0; i < dotNum; i++) {
				
				var dot:Point = new Point( mouseX, mouseY );
				dots.push( dot );
			}
		}
		
		/** --------------------------------------------------
		 * 計算
		 */
		private function calc():void {
			
			for ( var i:uint = 0; i < dotNum; i++ ) {
				
				// 座標の算出
				if ( i == 0 ) {
					
					dots[ i ].x = mouseX;
					dots[ i ].y = mouseY;
					
				} else {
					
					var angle:Number = Math.atan2( dots[ i ].y - dots[ i - 1 ].y, dots[ i ].x - dots[ i - 1 ].x );
					dots[ i ].x = dots[ i - 1 ].x + distance * Math.cos( angle );
					dots[ i ].y = dots[ i - 1 ].y + distance * Math.sin( angle );
				}
			}
		}
		
		/** --------------------------------------------------
		 * 描画
		 */
		private function draw():void {
			
			graphics.clear();
			graphics.beginFill( 0 );
			
			for ( var i:uint = 0; i < dotNum; i++ ) {
				
				if( i == 0 )
					graphics.drawCircle( dots[ i ].x, dots[ i ].y, dotRadius );
				
				else {
					
					var angle:Number = Math.atan2( dots[ i ].y - dots[ i - 1 ].y, dots[ i ].x - dots[ i - 1 ].x );
					
					if ( i % 2 == 0 )
						angle += ( 90 / 360 ) * ( 2 * Math.PI );
						
					else
						angle -= ( 90 / 360 ) * ( 2 * Math.PI );
					
					graphics.drawCircle( dots[ i ].x + dotRadius * Math.cos( angle ), dots[ i ].y + dotRadius * Math.sin( angle ), dotRadius );
				}
			}
			
			graphics.endFill();
			
			// -----
			
			graphics.lineStyle( 1, 0xcccccc );
			graphics.moveTo( dots[ 0 ].x, dots[ 0 ].y );
			
			for ( i = 1; i < dotNum; i++ ) {
				
				angle = Math.atan2( dots[ i ].y - dots[ i - 1 ].y, dots[ i ].x - dots[ i - 1 ].x ) + ( 90 / 360 ) * ( 2 * Math.PI );
				graphics.lineTo( dots[ i ].x + ( dotRadius * 4 ) * Math.cos( angle ), dots[ i ].y + ( dotRadius * 4 ) * Math.sin( angle ) );
			}
			
			for ( i = dotNum - 1; i > 0; i-- ) {
				
				angle = Math.atan2( dots[ i ].y - dots[ i - 1 ].y, dots[ i ].x - dots[ i - 1 ].x ) - ( 90 / 360 ) * ( 2 * Math.PI );
				graphics.lineTo( dots[ i ].x + ( dotRadius * 4 ) * Math.cos( angle ), dots[ i ].y + ( dotRadius * 4 ) * Math.sin( angle ) );
			}
			graphics.lineTo( dots[ 0 ].x, dots[ 0 ].y );
		}
	}
}