/**
 * Copyright madflash ( http://wonderfl.net/user/madflash )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Esp
 */

package
{
    /*
     * How to use FragBit.
     *
     * ビットフラグ(ビットマスク)を使うメリットと、
     * 論理和(OR)処理と加算処理の違いを解説します。
     * 
     * 簡潔にまとめると、
     * ビットフラグは「Boolean型の変わりにint,uint,Number型をフラグとして使う」
     * ことが出来るものです。
     * 
     * ActionScript上で使用するメリットには
     * ・大量にフラグを生成しなくていいこと
     * ・Objectでまとめる事により関連性が分かりやすくなる
     *　・場合によっては処理しやすくなる
     * などがあります。
     *
     * 以下に処理と結果の違いを解説してますのでどうぞ。
     *
     */
    
    
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    
    public class BitMaskDevelop extends Sprite
    {
        private static const DEF_POINT_X:uint = 100;
        private static const DEF_POINT_Y:uint = 40;
        private static var _movement:uint = 16;

        /* まずマスク用の変数を用意します。 */
        //　ここでは色を扱うとして、COLORという名前でObjectを作成します。
        // ビットマスク用の変数を扱う場合には、設定する値がそれぞれの合計値とかぶらないようにします。
        // ※1+2=3なので3は使えません。
        // 
        public static const COLOR:Object = 
        {
            RED : 1,
            GREEN : 2,
            BLUE : 4
        };
        
        public function BitMaskDevelop()
        {
            var resultpack:Array = new Array();
            
            /* ここからは、右の画面と照らし合わせながら見て下さい */
            
            /* 以下の二つは見かけ上、同じ結果が得られる。 */
            resultpack[0]  = COLOR.RED | COLOR.GREEN | COLOR.BLUE; //Resut 0
            resultpack[1]  = COLOR.RED + COLOR.GREEN + COLOR.BLUE; //Resut 1
            
            /* 2と3では結果が異なる。これが論理和と加算の決定的な違い。 */
            // 論理和の結果
            // REDフラグは埋まっている = 既にフラグがたっているので加算はされない。
            resultpack[2]  = COLOR.RED | COLOR.RED; //Resut 2
            
            // 加算の結果
            // 加算処理ではREDは単なる「3」という数値として処理される。結果、加算される。
            resultpack[3]  = COLOR.RED + COLOR.RED; //Resut 3
            
            /*
             * 以上のように、ビットフラグ処理をORで行うことは、
             * ビットフラグの可読性の問題よりも、間違って２度処理を行った時の
             * 予期しないエラーを防ぐ上で重要となります。
             * 
             * さらに解説すると、内部では
             * 0x0001 |= 0x0001; 
             * 0x0001 += 0x0001; 
             * ということになる。
             */
             
             /* パターン2と3の内部処理 */
             resultpack[4]  = (0x0001 | 0x0001); //Resut 4
             resultpack[5]  = (0x0001 + 0x0001); //Resut 5
             
             /* 以上です。 */
            
            _trace( resultpack );
        }
        
        private function _trace(entry_:Array) :void
        {
            var movement:uint = 0;
            var entryname:String = "";
            var cnt:uint = 0;
            
            var format:TextFormat = new TextFormat();
            format.color = 0xff0000;
            format.size = 12;
            format.font = 'MS Gothic';
            
            for each(var e:uint in entry_)
            {
                entryname = "Result" + String(cnt);
                
                var txt:TextField = new TextField();
                txt.autoSize = TextFieldAutoSize.LEFT;
                txt.defaultTextFormat = format;
                txt.text = entryname + " = " + e;
                
                txt.x = DEF_POINT_X;
                txt.y = DEF_POINT_Y + movement;
                txt.width = 100;
                txt.height = 16;
                
                addChild( txt );
                
                movement += _movement;
                ++cnt;
            }
        }
    }
}