/**
 * Copyright tananuka13 ( http://wonderfl.net/user/tananuka13 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3ERC
 */

// forked from ProjectNya's ColorWaveLine
////////////////////////////////////////////////////////////////////////////////
// [AS3.0] ランダム波形 (1)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1081
//
// 参考にさせていただいたwonderfl投稿
// forked from: FrocessingSample    [http://wonderfl.net/c/8ECj]
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.geom.Point;
    import frocessing.math.PerlinNoise;
    import frocessing.color.ColorHSV;
    //import org.libspark.utils.GeomUtil;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var canvas:Sprite;
        private var bitmap:Bitmap;
        private var bitmapData:BitmapData;
        private static var bWidth:uint = 465;
        private static var bHeight:uint = 232;
        private static var segments:uint = 5;
        private static var ratio:Number = 1/segments;
        private static var colors:uint = 360;
        private var perlin:PerlinNoise;
        private var color:ColorHSV;
        private var t:Number = 0;
        private var c:uint = 0;
        private static var tightness:uint = 40;

        public function Main() {
            Wonderfl.capture_delay(30);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            canvas = new Sprite();
            bitmapData = new BitmapData(bWidth, bHeight, true, 0x00000000);
            bitmap = new Bitmap(bitmapData);
            addChild(bitmap);
            bitmap.y = uint((bWidth - bHeight)/2);
            perlin = new PerlinNoise();
            color = new ColorHSV();
            addEventListener(Event.ENTER_FRAME, draw, false, 0, true);
            stage.addEventListener(MouseEvent.CLICK, reset, false, 0, true);
        }
        private function draw(evt:Event):void {
            canvas.graphics.clear();
            color.h = c;
            canvas.graphics.lineStyle(0, color.value, 0.2);
            c ++;
            c %= colors;
            bitmapData.lock();
            var points:Array = new Array();
            points.push(new Point(-bWidth*ratio, bHeight*0.5));
            for (var n:uint = 1; n <= segments+1; n++) {
                var xPos:Number = n*bWidth*ratio;
                var yPos:Number = perlin.noise(n*0.25, t)*bHeight;
                points.push(new Point(xPos-bWidth*ratio, yPos));
            }
            t += 0.01;
            points.push(new Point(bWidth*(1+ratio), bHeight*0.5));
            points.unshift(points[0]);
            points.push(points[points.length-1]);
            canvas.graphics.moveTo(points[0].x, points[0].y);
            for (var p:uint = 0; p < points.length-3; p++) {
                var p0:Point = points[p];
                var p1:Point = points[p+1];
                var p2:Point = points[p+2];
                var p3:Point = points[p+3];
                for (var s:uint = 1; s < tightness+1; s++) {
                    //var px:Number = GeomUtil.spline(p0.x, p1.x, p2.x, p3.x, s/tightness);
                    //var py:Number = GeomUtil.spline(p0.y, p1.y, p2.y, p3.y, s/tightness);
                    var px:Number = spline(p0.x, p1.x, p2.x, p3.x, s/tightness);
                    var py:Number = spline(p0.y, p1.y, p2.y, p3.y, s/tightness);
                    canvas.graphics.lineTo(px, py);
                }
            }
            bitmapData.draw(canvas);
            bitmapData.unlock();
        }
        private function spline(p0:Number, p1:Number, p2:Number, p3:Number, t:Number):Number {
            var v0:Number = (p2 - p0) * 0.5;
            var v1:Number = (p3 - p1) * 0.5;
            var t2:Number = t * t;
            var t3:Number = t2 * t;
            return (2 * p1 - 2 * p2 + v0 + v1) * t3 + ( -3 * p1 + 3 * p2 - 2 * v0 - v1) * t2 + v0 * t + p1;
        }
        private function reset(evt:MouseEvent):void {
            bitmapData.lock();
            bitmapData.fillRect(bitmapData.rect, 0x00000000);
            bitmapData.unlock();
        }

    }

}
