/**
 * Copyright hig_an ( http://wonderfl.net/user/hig_an )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3EQI
 */

package {
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
    [SWF(backgroundColor='#000000', frameRate='30', width='465', height='465')]

	public class Main extends Sprite {
		private var numOfEnemy:int = 10;
		private var circleSize:Number = 10;
		private var timer:Timer = new Timer(200);;
		
		private var bmpd:BitmapData;
		private var sp:Shape;
		private var sp2:Shape;
		private var enemyList:Array;
		private var mt:Matrix;
		private var myUnit:Circle;
		private var explosionList:Array;
		private var score:int = 50;
		private var tf:TextField;
		
		public function Main() :void {
			
			
			tf = new TextField();
			tf.defaultTextFormat = new TextFormat("_typeWriter", 40, 0x0, true);
			tf.autoSize = "left";
			addChild(tf);
			tf.text = score.toString();
			tf.x = stage.stageWidth - tf.width;
			
			bmpd = new BitmapData(465, 465, false, 0x0);
			enemyList = new Array();
			mt = new Matrix();
			myUnit = new Circle(232, 465, 0);
			myUnit.radius = circleSize * 2;
			
			
			sp = newFig(0, 0, circleSize);
			sp2 = newFig(0, 0, circleSize*2, 0x00FF00);
			for (var i:int = 0; i < numOfEnemy; i++) {
				enemyList[i] = new Circle(465 * Math.random(), - circleSize,10 * Math.random() + 1);
				enemyList[i].radius = circleSize;
			}
			addChild(new Bitmap(bmpd));
			addEventListener(Event.ENTER_FRAME, loop);
			timer.addEventListener(TimerEvent.TIMER, onTimerEvent);
			timer.start();
		}
		private function loop(e:Event) :void {
			bmpd.lock()
			bmpd.fillRect(bmpd.rect, 0xFFFFFF);
			myUnit.x = mouseX; myUnit.y = mouseY;
			mt.identity()
			mt.translate(myUnit.x, myUnit.y);
			bmpd.draw(sp2, mt);
			
			for (var i:int = 0; i < enemyList.length; i++) {
				enemyList[i].y += enemyList[i].vy + enemyList[i].y * enemyList[i].ay;
				
				if (enemyList[i].y > 465) {
					enemyList[i].y = - circleSize;
					enemyList[i].x = 465 * Math.random();
					tf.text = (score--).toString();
					tf.x = stage.stageWidth - tf.width;
					if (score == 0) {
						tf.text = "0";
						tf.textColor = 0xff0000;
						removeEventListener(Event.ENTER_FRAME, loop);
					}
					
				}
				mt.identity();
				mt.translate(enemyList[i].x, enemyList[i].y);
				bmpd.draw(sp, mt);
				if (atari(myUnit, enemyList[i])) {
					enemyList.splice(i, 1)
					i--
					tf.text = (score++).toString();
					tf.x = stage.stageWidth - tf.width;
				}
			}
			
			
			bmpd.unlock();
		}
		private function atari(unit:Circle,enemy:Circle):Boolean{
			if ((enemy.x + enemy.radius > unit.x-unit.radius && enemy.x - enemy.radius < unit.x+unit.radius) 
			&& (enemy.y + enemy.radius > unit.y-unit.radius && enemy.y - enemy.radius < unit.y+unit.radius)) {
				return true;
			}else {
				return false;
			}
		}
		private function newFig(xx:Number,yy:Number,size:int,col:uint = 0xFF0000):Shape {
			var s:Shape = new Shape();
			s.graphics.beginFill(col);
			s.graphics.drawCircle(xx, yy, size);
			s.graphics.endFill();
			return s;
		}
		private function onTimerEvent(e:TimerEvent):void {
			enemyList.push(new Circle(465 * Math.random(), - circleSize,10 * Math.random() + 1));
		}
		private function explosion():void {
			
		}
	}
}

class Circle{
		public var x:Number;
		public var y:Number;
		public var vx:Number;
		public var vy:Number;
		public var ax:Number;
		public var ay:Number;
		public var radius:Number;
		public function Circle(xx:Number, yy:Number ,vvy:Number) {
			x = xx;
			y = yy;
			vy = vvy;
			ay = 0.05;
		}
}
