/**
 * Copyright ruiko ( http://wonderfl.net/user/ruiko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3EOq
 */

// forked from ruiko's flash on 2010-8-11　メモー
// forked from ruiko's flash on 2010-7-31
//イベントハンドラが滅茶苦茶
package {
    import flash.trace.Trace;
    import flash.ui.Mouse;
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    import flash.ui.Keyboard;
    [SWF(width="640", height="400", backgroundColor="0xffffff", frameRate="24")]

    public class Main extends Sprite {
        // 最下層にしいてある長方形
        private var screen:Sprite = new Sprite();
        //3画面の制御
        private var flag:int = 1;
        //右ボタン
        private var right:Sprite = new Sprite();
        //左ボタン
        private var left:Sprite = new Sprite();
        //入力フォーム付き上カバー
        private var cover:Cover = new Cover();
        //ゴミ箱
        private var dustBox:Sprite = new Sprite();
        
        public function Main():void {
            trace("aaa");
            //画面（最下層）設定
            screen= new Sprite();
            screen.graphics.beginFill(0xE6E6FA,1);
            screen.graphics.drawRect(0,0,stage.stageWidth*3,stage.stageHeight);
            screen.graphics.endFill();
            //ゴミ箱定義
            dustBox.graphics.beginFill(0x000000, 1);
            dustBox.graphics.drawRect(0,0,50,50);
            dustBox.graphics.endFill();
            screen.addChild(dustBox);
            dustBox.x = stage.stageWidth;
            dustBox.y = 0;
            //マウスボタンダウン
            dustBox.addEventListener(MouseEvent.MOUSE_DOWN, dustBoxDown);
            //マウスボタンアップ
            dustBox.addEventListener(MouseEvent.MOUSE_UP, dustBoxUp);
            
            screen.x = -stage.stageWidth;
            
            addChild(screen);
            //移動ボタン描画
            drawMoveButton();
            
            // クリックイベントを監視する
            stage.addEventListener("click", stageClick);
            right.addEventListener("click", moveRight);
            left.addEventListener("click", moveLeft);
        }
        
       //ゴミ箱ドラッグ開始
        private function dustBoxDown(event:MouseEvent ):void {
                    dustBox.startDrag();
        }
        //ゴミ箱ドラッグ終了
        private function dustBoxUp(event:MouseEvent ):void {
                    dustBox.stopDrag();
        }
        
        //左に移動（スクリーンを右にずらす）
        private function moveLeft(event:MouseEvent):void {
            if(flag>0){
                screen.x+=stage.stageWidth;
                flag-=1;
            }
            //移動ボタン描画
            drawMoveButton();
        }
        
        //右に移動（スクリーンを左にずらす）
        private function moveRight(event:MouseEvent):void {
            if(flag<2){
                screen.x -= stage.stageWidth; 
                flag+=1;
            }
            //移動ボタン描画
            drawMoveButton();
        }

        
        //イベントハンドラ
        private function stageClick(event:MouseEvent):void {
            //スクリーン上で起こった
            if (event.target == screen) {
             
            // 四角を作成
            var memo:Memo = new Memo();
            
            screen.addChild(memo.createMemo(Math.random() * 0x1000000));
            // 四角をクリックされた位置に移動
            memo.x = event.stageX+(stage.stageWidth*flag);
            memo.y = event.stageY;
            //ダブルクリック許可
            memo.doubleClickEnabled = true;
           
            //マウスボタンダウン
            memo.addEventListener(MouseEvent.MOUSE_DOWN, rectClickDown(memo));
            //マウスボタンアップ
            memo.addEventListener(MouseEvent.MOUSE_UP, rectClickUp(memo));
            //ダブルクリック
            memo.addEventListener(MouseEvent.DOUBLE_CLICK, rectDoubleClick(memo));
            }
            else if (event.target == cover) {
                //カバー上で起こった
                //テキストフィールドの入力を取得
                var input:String = cover.text.text;
                //サイズ取得
                cover.clickedMemo.format.size = cover.size.text;
                //色取得(16進数)
                cover.clickedMemo.format.color = "0x"+cover.color.text;
                screen.removeChild(cover);
                //文字を書き換えてメモ描画
                screen.addChild(cover.clickedMemo.editText(input));
                //移動ボタン描画
                this.drawMoveButton();
            }
        }
        
        //ドラッグ開始
        private function rectClickDown(memo:Memo):Function {
            return function (event:MouseEvent ):void { 
                if (screen.numChildren > 0) {
                    screen.addChildAt(memo, screen.numChildren - 1);
                }
                if (!(event.target is TextField)) {
                    event.target.startDrag( );
                }
            }
        }
        //ドラッグ終了
        private function rectClickUp(memo:Memo):Function {
            return function (event:MouseEvent):void {
                trace(dustBox.x + ":" + dustBox.y);
                trace(event.stageX+":"+event.stageY);
            if (!(event.target is TextField)) {
                event.target.stopDrag( );
            }
            //ゴミ箱上なら消す
            if (event.stageX >= dustBox.x && event.stageY >= dustBox.y && event.stageX <= dustBox.x + 50 && event.stageY <= dustBox.y + 50) {
                trace("rem");
                screen.removeChild(memo);
            }
            }
        }
        //ダブルクリック
        private function rectDoubleClick(memo:Memo):Function {
            return function (event:MouseEvent ):void{  
            
                right.graphics.clear();
                left.graphics.clear();
                cover = new Cover();
             
                //クリックしたメモと画面サイズと画面位置
                screen.addChild(cover.createCover(stage.stageWidth, stage.stageHeight, memo, flag));
            }
        }

        /**
         * 画面移動ボタン描画
         */
        public function drawMoveButton():void {
           
           if(flag==0 || flag==1){
                right.graphics.beginFill(0x000000);
                right.graphics.drawCircle(stage.stageWidth-25,stage.stageHeight-40,20);
                right.graphics.endFill();
                addChild(right);;
            }else{
                right.graphics.clear();
            }

            if(flag==1 || flag==2){
                left.graphics.beginFill(0x000000);
                left.graphics.drawCircle(25,stage.stageHeight-40,20);
                left.graphics.endFill();
                addChild(left); 
            }else{
                left.graphics.clear();
            }
        }
   }
}
import flash.display.SimpleButton;
    import flash.display.Sprite;
    import flash.text.*;
    class Memo extends Sprite {
        public var colorNum:uint;
        public var inputText:String = "テスト";
        public var tf:TextField = new TextField();
        public var format:TextFormat=new TextFormat();

        public function createMemo(color:uint):Memo{
            var s:Sprite = new Sprite();
            colorNum = color;
            inputText = colorNum.toString();
            
            this.graphics.beginFill(colorNum,0.8);
            this.graphics.drawRect(this.x,this.y,120,100);
            this.graphics.endFill();
            
            format= new TextFormat("", 10, 0x0, true);
            tf.defaultTextFormat = format;
            tf.width = 110;
            tf.height=84;
            tf.x=4;
            tf.y=15;
            tf.wordWrap = true;
            tf.text = inputText;
            tf.type = "input";
            tf.border = true;
            tf.borderColor=color+0x111111;
            tf.multiline = true;
            
            this.addChild(tf);
            
            return(this);
        }
        
        //テキストのみ書き換え
        public function editText(newText:String):Memo {
            
            tf.defaultTextFormat=format;
            
            tf.text = newText;
            
            this.addChild(tf);
            
            return(this);
        }

    }
    
    import flash.display.Sprite;
    import flash.text.*;
    class Cover extends Sprite {
        public var colorNum:uint;
        public var text:TextField = new TextField();
        public var size:TextField = new TextField();
        public var color:TextField = new TextField();
        public var clickedMemo:Memo = new Memo();

        public function createCover(width:int, height:int, memo:Memo, flag:int):Cover {
            
            clickedMemo = memo;
            this.graphics.beginFill(0x555555,0.3);
            this.graphics.drawRect(0,0,width*3,height);
            this.graphics.endFill(); 
            
            var button:SimpleButton=new SimpleButton();
            button.x= width * flag + 200;
            button.y=100;
            this.addChild(button);
              
              //テキストボックス
            text = new TextField();
            text.border = true;
            text.background = true;
            text.wordWrap = true;
            text.type = "input";
            text.text = memo.tf.text;
            text.x = width * flag + 100;
            text.y = 100;
            this.addChild(text);
             //テキストボックス
            size = new TextField();
            size.border = true;
            size.background = true;
            size.wordWrap = true;
            size.type = "input";
            size.text = memo.format.size.toString();
            size.x = width * flag + 100;
            size.y = 220;
            size.height=20;
            size.width=30;
            this.addChild(size);
            //テキストボックス
            color = new TextField();
            color.border = true;
            color.background = true;
            color.wordWrap = true;
            color.type = "input";
            color.text = memo.format.color.toString(16);
            color.x = width * flag + 200;
            color.y = 220;
            color.height=20;
            this.addChild(color);
            return(this);
            
        }

    }
