/**
 * Copyright codeonwort ( http://wonderfl.net/user/codeonwort )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3D2U
 */

// forked from gameegg's Lightning 1

package {
    
    import flash.display.*;
    import flash.events.*;
    
    [SWF(width = "465", height = "465", frameRate = "40")]
    public class Main extends Sprite {
        
        public static const WIDTH:Number = 465;
        public static const HEIGHT:Number = 465;
        
        private var debug:Boolean = false;
        private var entities:Vector.<Entity> = new Vector.<Entity>();
        
        public function Main():void {
            var fogR:Number = 116;
            var fogG:Number = 126;
            var fogB:Number = 143;
            
            var mountainR:Number = 23;
            var mountainG:Number = 21;
            var mountainB:Number = 32;
            
            const NUMBER_OF_MOUNTAINS:int = 4;
            
            var l:Lightning = new Lightning
            entities.push(addChild(l));
            
            for (var i:int = 0; i < NUMBER_OF_MOUNTAINS; i++) {
                var blend:Number = i / (NUMBER_OF_MOUNTAINS - 1);
                
                var _r:Number = lerp(fogR, mountainR, blend);
                var _g:Number = lerp(fogG, mountainG, blend);
                var _b:Number = lerp(fogB, mountainB, blend);
                
                var baseHeight:Number = HEIGHT / 2 + i * 25;
                var color:uint = (_r << 16) | (_g << 8) | _b;
                
                var mountain:Mountain = new Mountain(-Math.pow(i + 1, 2), baseHeight, color);
                entities.push(addChild(mountain));
                l.mountains.push(mountain)
            }
            
            entities.push(addChild(new PoleAndWire()));
            entities.push(addChild(new Tunnel()));
            
            var outline:Shape = new Shape();
            var g:Graphics = outline.graphics;
            g.lineStyle(1, 0x808080);
            g.drawRect( -1, -1, WIDTH + 2, HEIGHT + 2);
            addChild(outline);
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler(e:Event):void {
            for each (var entity:Entity in entities){
                entity.update();
            }
        }
        
    }
    
}

///////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// outside of package ////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////

import flash.display.*;
import flash.filters.BlurFilter;
import flash.filters.GlowFilter;
import flash.geom.Matrix;
import flash.geom.Rectangle;

class Entity extends Sprite { public function update():void {} }

class Mountain extends Entity {
    
    private var heightMap:Vector.<Number> = new Vector.<Number>();
    private const SEGMENT_LENGTH:Number = 10;
    
    private var baseHeight:Number;
    private var color:uint;
    private var speed:Number;
    
    public var light:Shape = new Shape
    public var flashStrength:Number = 0
    
    function Mountain(speed:Number, baseHeight:Number, color:uint) {
        this.baseHeight = baseHeight;
        this.color = color;
        this.speed = speed;
        
        generateHeightMap();
        createShape();
        addChild(light).visible = false
    }
    
    public override function update():void {
        x += speed;
        if (x < -(width - Main.WIDTH)) {
            var removeSegmentNumber:int = (width - Main.WIDTH) / SEGMENT_LENGTH;
            heightMap.splice(0, removeSegmentNumber);
            x += removeSegmentNumber * SEGMENT_LENGTH;
            
            generateHeightMap();
            createShape();
        }
    }
    
    private function generateHeightMap():void {
        // 再帰で分割していく
        divide(baseHeight, baseHeight, 0, 200);
        
        function divide(left:Number, right:Number, depth:int, offset:Number):void {
            if (depth < 6) {
                var half:Number = (left + right) / 2 + rnd( -offset / 2, offset / 2);
                
                divide(left, half, depth + 1, offset / 2);
                divide(half, right, depth + 1, offset / 2);
            } else {
                // 十分に分割したら順番に書き出し
                heightMap.push(left);
            }
        }
    }
        
    private function createShape():void {
        var g:Graphics = graphics;
        
        g.clear();
        g.beginFill(color);
        g.moveTo(0, Main.HEIGHT);
        for (var i:int = 0; i < heightMap.length; i++) {
            g.lineTo(i * SEGMENT_LENGTH, heightMap[i]);
        }
        g.lineTo((i - 1) * SEGMENT_LENGTH, Main.HEIGHT);
        g.endFill();
        
        // デバッグ表示
        g.lineStyle(1, color);
        g.moveTo(0, heightMap[0]);
        g.lineTo(0, Main.HEIGHT * 2);
        
        g = light.graphics
        g.clear()
        g.beginFill(0xffffff);
        g.moveTo(0, Main.HEIGHT);
        for (i = 0; i < heightMap.length; i++) {
            g.lineTo(i * SEGMENT_LENGTH, heightMap[i]);
        }
        for(i=heightMap.length-1 ; i>=0 ; i--){
            g.lineTo(i * SEGMENT_LENGTH, heightMap[i] + flashStrength);
        }
    }
}

const SPEED:Number = 80;

class PoleAndWire extends Entity {
    private const SPACING:Number = Main.WIDTH * 5;
    
    private const POLE_THICK:Number = 40;
    private const WIRE_TOP:Number = 20;
    private const WIRE_BOTTOM:Number = 100;
    
    function PoleAndWire() {
        var g:Graphics = graphics;
        
        g.beginFill(0x333344);
        g.drawRect(-POLE_THICK / 2, 0, POLE_THICK, Main.HEIGHT);
        g.endFill();
        
        g.lineStyle(1, 0x222233);
        g.moveTo(POLE_THICK / 2, WIRE_TOP);
        g.curveTo(SPACING / 2, WIRE_BOTTOM, SPACING - POLE_THICK, WIRE_TOP);
        g.moveTo(-POLE_THICK / 2, WIRE_TOP);
        g.curveTo(-SPACING / 2, WIRE_BOTTOM, -SPACING + POLE_THICK, WIRE_TOP);
        
        x = (SPACING + Main.WIDTH) / 2;
        
        filters = [ new BlurFilter(80, 0, 1) ];
    }
    
    public override function update():void {
        x -= SPEED;
        if (x < (-SPACING + Main.WIDTH) / 2) {
            x += SPACING;
        }
    }
}

class Tunnel extends Entity {
    // |ENTRANCE|SPACE|LIGHT|SPACE|ENTRANCE|
    // ^ origin
    
    private const LIGHT:Number = 100;
    private const SPACE:Number = Main.WIDTH * 1.4;
    private const ENTRANCE:Number = Main.WIDTH * 1.5;
    private const WIDTH:Number = LIGHT + SPACE * 2 + ENTRANCE * 2;
    
    private const ENTRANCE_COLOR:uint = 0x888899;
    private const DARKNESS_COLOR:uint = 0x0A0908;
    private const LIGHT_COLOR:uint = 0xFFF0E0;
    
    private var lightCount:int;
    private var light:Shape;
    
    function Tunnel()
    {
        var g:Graphics = graphics;
        
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(ENTRANCE, Main.HEIGHT);
        g.beginGradientFill(GradientType.LINEAR, [ENTRANCE_COLOR, DARKNESS_COLOR], null, [0, 255], matrix);
        g.drawRect(0, 0, ENTRANCE, Main.HEIGHT);
        matrix.createGradientBox(ENTRANCE, Main.HEIGHT, 0, WIDTH - ENTRANCE, 0);
        g.beginGradientFill(GradientType.LINEAR, [DARKNESS_COLOR, ENTRANCE_COLOR], null, [0, 255], matrix);
        g.drawRect(WIDTH - ENTRANCE, 0, ENTRANCE, Main.HEIGHT);
        g.endFill();
        
        g.beginFill(DARKNESS_COLOR);
        g.drawRect(ENTRANCE, 0, LIGHT + SPACE * 2, Main.HEIGHT);
        g.endFill();
        
        light = new Shape();
        light.graphics.beginFill(LIGHT_COLOR);
        light.graphics.drawRect(WIDTH / 2, Main.HEIGHT * 0.55, LIGHT, 20);
        light.graphics.endFill();
        addChild(light);
        
        prepareNextTunnel();
        
        // 最初のトンネルまでは定距離にする。
        x = SPEED * 600;
        
        filters = [ new BlurFilter(80, 0, 1) ];
        light.filters = [ new GlowFilter(0xFF8000, 1, 50, 50, 3, 4) ];
    }
    
    public override function update():void
    {
        x -= SPEED;
        if (x < -(WIDTH - ENTRANCE - Main.WIDTH)) {
            if (--lightCount >= 0) {
                // ライトをループ
                x += SPACE * 2 + LIGHT - Main.WIDTH;
                trace(length);
            }
        }
        if (x < -WIDTH * 2) {
            prepareNextTunnel();
        }
    }
    
    private function prepareNextTunnel():void
    {
        x = SPEED * rnd(300, 1500);
        lightCount = rnd(6, 60);
    }
}

// 線形補間
function lerp(n0:Number, n1:Number, p:Number):Number {
    return n0 * (1 - p) + n1 * p;
}

// [min, max)の乱数を取得
function rnd(min:Number, max:Number):Number {
    return min + Math.random() * (max - min);
//    return lerp(min, max, Math.random());
}

import flash.geom.ColorTransform;
import flash.geom.Point;
import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Shape;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.filters.ColorMatrixFilter;
import flash.filters.BlurFilter;
//import flash.filters.DropShadowFilter
import flash.geom.ColorTransform;

internal class Lightning extends Entity {
    
    private var _bitd:BitmapData;
    private var _bit:Bitmap;
    private var _flash:Shape;
    private var _ground:Shape;
    private var _cmf:ColorMatrixFilter = new ColorMatrixFilter([0.95,0,0,0,0,
                                                                0,0.97,0,0,0,
                                                                0,0,1,0,0,
                                                                0,0,0,1,0]);
    private var _cmf2:ColorMatrixFilter = new ColorMatrixFilter([0.9,0,0,0,0,
                                                                0,0.9,0,0,0,
                                                                0,0,1,0,0,
                                                                0,0,0,1,0]);
    private var _bf:BlurFilter = new BlurFilter(8,8,2);
    private var _ctf:ColorTransform = new ColorTransform(1,1,1,0.99);
    private var _startPoint:Point = new Point(250,200);
    private var _r:Number = 0;
    private var scroll_count:int = 0
    private var light_count:int = 0
    
    public var mountains:Array = []
    //private var shadow:DropShadowFilter = new DropShadowFilter(4, 90, 0xffffff, 1, 0, 8, 1, 1, true)
    
    public function Lightning() {
        _bitd = new BitmapData(465,465,false,0x000000);
        _bit = new Bitmap(_bitd);
        _ground = new Shape();
        _flash = new Shape();
        _flash.graphics.beginFill(0xffffff);
        _flash.graphics.drawRect(0,0,465,465);
        _flash.alpha = 0;
        
        _ground.filters = [new GlowFilter(0x123456, 1, 8, 8, 4)]
        addChild(_bit);
        addChild(_flash);
    }
    public override function update():void {
        if(light_count-- == 0){
            var x0:Number = Math.random() * stage.stageWidth
            var h:Number = stage.stageHeight/2 + Math.random()*stage.stageHeight/2
            drawLines(x0, 0, x0, h, true);
            light_count = 5 + Math.random()*60 + Math.random()*120
        }
        if(scroll_count++ == 10){
            scroll_count = 0
            _bitd.scroll(-1, 0)
        }
        if(_flash.alpha < 0.6)_bitd.applyFilter(_bitd,_bitd.rect,new Point(0,0),_cmf);
        if(_flash.alpha < 0.6)_bitd.colorTransform(_bitd.rect,_ctf);
        _flash.alpha -= _flash.alpha/16;
        if(_flash.alpha > 0.01){
            for each(var mt:Mountain in mountains){
                //shadow.distance = int((_flash.alpha-0.3)*12)
                mt.flashStrength = _flash.alpha * 30
                mt.light.alpha = _flash.alpha
                mt.light.visible = true
                //mt.filters = [shadow]
            }
        }else for each(mt in mountains) mt.light.visible = false//mt.filters = null
    }
    private function drawLines(sx:Number,sy:Number,ex:Number,ey:Number,mainRoot:Boolean):void{
        var _currentPoint:Point = new Point(sx,sy);
        var _endPoint:Point = new Point(ex,ey);
        var distance:Number = pit(_currentPoint,_endPoint);
        var random:Number;
        _ground.graphics.moveTo(sx,sy);
        
        while(distance > 10){
            _ground.graphics.lineStyle(distance/44+0.05,0xffffff);
            _r = Math.atan2(_endPoint.y - _currentPoint.y, _endPoint.x - _currentPoint.x) + Math.random()*2.4 - 1.2;
            random = Math.random()*(distance/50)
            _currentPoint.x += Math.cos(_r)*random;
            _currentPoint.y += Math.sin(_r)*random;
            
            _ground.graphics.lineTo(_currentPoint.x,_currentPoint.y);
            distance = pit(_currentPoint,_endPoint);
            if(Math.random() > 0.95 && mainRoot || Math.random()>0.97){

                var _rofchild:Number = 0.7*(_r + Math.random() - 0.5);
                drawLines(_currentPoint.x, _currentPoint.y,
                          _currentPoint.x + Math.cos(_rofchild)*Math.random()*distance/1.5,
                          _currentPoint.y + Math.sin(_rofchild)*Math.random()*distance/1.5,
                          false);

            }
            _ground.graphics.moveTo(_currentPoint.x,_currentPoint.y)

        }
        if(mainRoot){
            _startPoint.x = _endPoint.x;
            _startPoint.y = _endPoint.y;
            _bitd.draw(_ground);
            _bitd.applyFilter(_bitd,_bitd.rect,new Point(0,0),_bf);
            _bitd.applyFilter(_bitd,_bitd.rect,new Point(0,0),_cmf2);
            _flash.alpha = 1;
            _bitd.draw(_ground);
            _ground.graphics.clear();
        }
    }
    private function pit(PointA:Point, PointB:Point):Number{
        return Math.sqrt((PointA.x - PointB.x)*(PointA.x - PointB.x) + (PointA.y - PointB.y)*(PointA.y - PointB.y));
    }
}
