/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3D0r
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.Point;
    
    public class FlashTest extends Sprite {
        private var W:Number;
        private var H:Number;
        private var FRONT:MovieClip;
        private var REVERSE:Sprite;
        private var MASK_F:Sprite;
        private var MASK_R:Sprite;
        private var PI:Number = Math.PI;
        private var sx:Number = 0;
        private var sy:Number = 0;
        private var ax:Number = 0;
        private var ay:Number = 0;
        private var bx:Number = 0;
        private var by:Number = 0;
        private var flg:Boolean = true;
        
        public function FlashTest() {
            var cnt:uint = 50;
            while(cnt--) {
                setObject();
            }            
        }
        
        public function setObject():void {
            var mc:MovieClip = new MovieClip();
            var sp:Sprite = new Sprite();
            var txt:TextField = new TextField();
            var tfo:TextFormat = new TextFormat();
            tfo.size = 30;
            txt.defaultTextFormat = tfo;
            var w:Number = Math.random() * 200 + 50;
            var h:Number = Math.random() * 25 + 25;
            var col:uint = Math.floor(Math.random()*0xffffff);
            sp.graphics.beginFill(Math.floor(Math.random()*0xffffff));
            sp.graphics.drawRect(0,0,w,h);
            mc.addChild(sp);
            txt.textColor = 0xffffff;
            txt.text = "めくれるよ";
            txt.width = w;
            txt.height = h;
            sp.addChild(txt);
            
            var bmd:BitmapData = new BitmapData(txt.width, txt.height, true);
            bmd.draw(sp);
            var bmp:Bitmap = new Bitmap(bmd);
            bmp.smoothing = true;
            mc.addChild(bmp);
            
            mc.x = Math.random()*300;
            mc.y = Math.random()*400;
            
            mc.mouseEnabled = true;
            mc.mouseChildren = false;
            mc.alpha = Math.random()*0.5 + 0.4;
            
            mc.alpha = Math.random() * 0.5 * 0.4;
            setFlip(mc);
            stage.addChild(mc);
        }
        
        public function setFlip(mc:MovieClip):void
        {
            mc.addEventListener(MouseEvent.MOUSE_DOWN, flipDown);
        }
        
        private function flipDown(e:Event):void
        {
            if(!flg) return;
            e.target.removeEventListener(MouseEvent.MOUSE_DOWN, flipDown);
            FRONT = e.target as MovieClip;
            stage.setChildIndex(FRONT, stage.numChildren - 1);
            W = FRONT.width;
            H = FRONT.height;
            MASK_F = new Sprite();
            MASK_F.graphics.beginFill(0xff0000);
            MASK_F.graphics.drawRect(0, -H*5, W*2, H*10);
            MASK_F.graphics.endFill();
            
            MASK_R = new Sprite();
            MASK_R.graphics.beginFill(0x00ff00);
            MASK_R.graphics.drawRect(0, -H*5, W*2, H*10);
            MASK_R.graphics.endFill();
            
            var matrix:Matrix = new Matrix();
            matrix.scale(-1, 1);
            matrix.translate(FRONT.width, 0);
            var bmd:BitmapData = new BitmapData(FRONT.width, FRONT.height, true);
            bmd.draw(FRONT, matrix);
            trace(bmd.width);
            REVERSE = new Sprite();
            
            var bmp:Bitmap = new Bitmap(bmd);
            bmp.x = -W;
            bmp.smoothing = true;
            REVERSE.alpha = FRONT.alpha;
            REVERSE.addChild(bmp);
            REVERSE.mask = MASK_R;
            trace(REVERSE.width);
            FRONT.mask = MASK_F;
            
            var GLPoint:Point = FRONT.parent.localToGlobal(new Point(FRONT.x, FRONT.y));
            REVERSE.x = GLPoint.x - FRONT.width;
            REVERSE.y = GLPoint.y - FRONT.height;
            MASK_R.cacheAsBitmap = true;
            MASK_F.cacheAsBitmap = true;
            stage.addChild(MASK_F);
            stage.addChild(MASK_R);
            stage.addChild(REVERSE);
            
            stage.addEventListener(MouseEvent.MOUSE_UP, flipUp);
            stage.addEventListener(Event.ENTER_FRAME, flipAnimate);
            var an1:Number = Math.atan2(e.target.mouseX, e.target.mouseY);
            var an2:Number = PI/2-an1; 
        }
        private function flipUp(e:Event):void
        {
            stage.removeChild(MASK_F);
            stage.removeChild(MASK_R);
            stage.removeChild(REVERSE);
            FRONT.addEventListener(MouseEvent.MOUSE_DOWN, flipDown);
            FRONT.mask = null;
            REVERSE.mask = null;
            FRONT = null;
            REVERSE = null;
            MASK_F = null;
            MASK_R = null;
            stage.removeEventListener(MouseEvent.MOUSE_UP, flipUp);
            stage.removeEventListener(Event.ENTER_FRAME, flipAnimate);
        }
        
        private function flipAnimate(e:Event):void
        {
            var GLPoint:Point = FRONT.parent.localToGlobal(new Point(FRONT.x, FRONT.y));
            if(stage.mouseX > GLPoint.x + W * 1.5 || stage.mouseY > GLPoint.y + H * 1.5) {
                stage.removeEventListener(MouseEvent.MOUSE_UP, flipUp);
                stage.removeEventListener(Event.ENTER_FRAME, flipAnimate);
                stage.addEventListener(Event.ENTER_FRAME, flipAnimateAuto);
                flg = false;
            } else {
                if(stage.mouseX < GLPoint.x) return;
                if(stage.mouseY < GLPoint.y) return;
                var an1:Number = -Math.atan((e.target.mouseX - GLPoint.x)/(e.target.mouseY-GLPoint.y));
                var an2:Number = (PI/2)*180/PI-an1*180/PI;
                var an3:Number = an2*2;
                var px:Number = (mouseX - GLPoint.x);
                px = px * px;
                var py:Number = (mouseY - GLPoint.y);
                py = py * py;
                var sq:Number = Math.sqrt(px+py);
                MASK_F.x = mouseX - (sq/2)*Math.cos(an1 * PI / 180) + 1;
                MASK_F.y = mouseY - (mouseY - GLPoint.y)/PI;
                MASK_R.x = mouseX - (sq/2)*Math.cos(an1*PI/180);
                MASK_R.y = mouseY - (mouseY - GLPoint.y)/PI;
                REVERSE.x = mouseX;
                REVERSE.y = mouseY;
                REVERSE.rotation = -an3;
                if(-an2 + 180 > 0 && -an2 + 180 < 90) {
                    MASK_R.rotation = -an2 + 180;
                    MASK_F.rotation = -an2 + 180;
                }
            }
            bx = mouseX;
            by = mouseY;
        }
        
        private function flipAnimateAuto(e:Event):void
        {
            var GLPoint:Point = FRONT.parent.localToGlobal(new Point(FRONT.x, FRONT.y));
            if(sx == 0) {
                var bufx:Number = GLPoint.x - mouseX;
                var bufy:Number = GLPoint.y - mouseY;
                sx = mouseX - GLPoint.x;
                sy = mouseY - GLPoint.y;
                ax = (bufx / (bufx+bufy))*3 + (W/(W+H))*3;
                ay = (bufy / (bufy+bufy))*3 + (H/(W+H))*3;
            } else {
                sx += ax;
                sy += ay;
            }
            var an1:Number = -Math.atan(sx/sy);
            var an2:Number = (PI/2)*180/PI-an1*180/PI;
            var an3:Number = an2*2;
            var px:Number = sx;
            px = px * px;
            var py:Number = sy;
            py = py * py;
            var sq:Number = Math.sqrt(px + py);
            MASK_F.x = (GLPoint.x + sx) - (sq/2) + Math.cos(an1 * PI / 180)+1;
            MASK_F.y = (GLPoint.y + sy) - ((GLPoint.y + sy) - GLPoint.y)/PI;
            MASK_R.x = (GLPoint.x + sx) - (sq/2)*Math.cos(an1 * PI / 180);
            MASK_R.y = (GLPoint.y + sy) - ((GLPoint.y + sy) - GLPoint.y)/PI;
            REVERSE.x = (GLPoint.x + sx);
            REVERSE.y = (GLPoint.y + sy);
            REVERSE.rotation = -an3;
            FRONT.alpha /= 1.2;
            REVERSE.alpha /= 1.2;
            if(-an2 + 180 > 0 && - an2 + 180 < 90) {
                MASK_R.rotation = -an2 + 180;
                MASK_F.rotation = -an2 + 180;
            }
            if(sx > W * 4 || sy > H * 4 || FRONT.alpha < 0.01)
            {
                sx = 0;
                sy = 0;
                FRONT.alpha = 0;
                REVERSE.alpha = 0;
                FRONT.visible = false;
                REVERSE.visible = false;
                stage.removeChild(MASK_F);
                stage.removeChild(MASK_R);
                stage.removeChild(REVERSE);
                stage.removeEventListener(Event.ENTER_FRAME, flipAnimateAuto);
                FRONT.addEventListener(MouseEvent.MOUSE_DOWN, flipDown);
                MASK_F = null;
                MASK_R = null;
                REVERSE = null;
                flg = true;
            }
        }
    }
}