/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3CLM
 */

// forked from siouxcitizen's Away3D練習7　テキストをビットマップとしてPlaneのテクスチャに使用
// forked from siouxcitizen's Away3D練習6　Torus表示
// forked from siouxcitizen's Away3D練習5　Shading&Phong Color MaterialでCone表示
// forked from siouxcitizen's Away3D練習4　3種類のMaterialでCube表示
// forked from siouxcitizen's Away3D練習3　3種類のMaterialでSphere表示
// forked from siouxcitizen's Away3D練習2　3種類のMaterialでPlane表示
// forked from siouxcitizen's Away3D練習1　Plane表示
// forked from siouxcitizen's forked from: Away3Dの練習
// forked from ser1zw's Away3Dの練習
//
//以下、参考にした自分作成の昔のコードと、そのコード作成時に参考にさせていただいたサイト＆コード
//
//自分作成の昔のコード
//http://wonderfl.net/c/gjEW
//
//dots
//http://wonderfl.net/c/q7hZ
//
//Flashの描画速度をBitmapDataクラスを使って上げる方法
//http://sipo.jp/blog/2009/12/flashbitmapdata.html
//
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.display.BitmapData;

    import away3d.containers.View3D;
    import away3d.primitives.Plane;
    import away3d.materials.BitmapMaterial;

    [SWF(frameRate="60", backgroundColor="#ffffff")]
    public class Away3DTest extends Sprite {
        private var view:View3D;
        private var plane:Plane;
    
        public function Away3DTest() {
            view = new View3D();
            view.x = stage.stageWidth >> 1;
            view.y = stage.stageHeight >> 1;
            addChild(view);

            //テクスチャ用画像を作成
            var recipe:Recipe = new Recipe();
            recipe.width = 16;
            recipe.height = 16;
            recipe.scale = 20.0;
            recipe.data = [0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,
                           0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,
                           0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,
                           0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,
                           0,0,1,2,2,1,1,1,1,1,1,2,2,1,0,0,
                           0,1,1,1,3,2,1,1,1,1,2,3,1,1,1,0,
                           0,1,1,1,3,2,2,2,2,2,2,3,1,1,1,0,
                           1,1,1,1,3,2,3,1,1,3,2,3,1,1,1,1,
                           1,1,1,1,3,3,3,1,1,3,3,3,1,1,1,1,
                           1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                           0,1,1,1,1,3,3,3,3,3,3,1,1,1,1,0,
                           0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,
                           0,0,0,0,3,3,3,3,3,3,3,3,2,2,0,0,
                           0,0,2,2,2,3,3,3,3,3,2,2,2,2,2,0,
                           0,0,2,2,2,2,3,3,3,2,2,2,2,2,2,0,
                           0,0,0,0,2,2,2,0,0,2,2,2,2,2,0,0];
            recipe.pallet.push(0xFFff0000, 0xFF4090c0, 0xFF305080, 0xFFa0fff0);//0xFFa0fff0 0xFF4090c0
            recipe.transparent = 0;
            var textureOnPlane : DotDraw = new DotDraw(recipe);

            //bitmapDataを用意する
            var bitmapData:BitmapData = new BitmapData(320, 320, true, 0x00000000); // 透明なBitmapDataを用意
            var matrix:Matrix = new Matrix();   // 表示位置はMatrixで指定する
            matrix.translate(0, 0);   // (0, 0)の位置に描画する設定にする
            bitmapData.draw(textureOnPlane, matrix);    // spriteをbitmapDataに描画する

            //ビットマップからPlane用テクスチャを作成
            var bitmapMaterial:BitmapMaterial = new BitmapMaterial(bitmapData);
            
            plane = new Plane({width: 150, height: 150});
            plane.material = bitmapMaterial;
            plane.bothsides = true;
            plane.rotationX = -90;
            view.scene.addChild(plane);

            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        private function onEnterFrame(e:Event):void {
            plane.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            plane.rotationY = stage.mouseX - (stage.stageWidth >> 1);
            view.render();
        }
    }
}
            

class Recipe {
    public var width:uint = 0;
    public var height:uint = 0;
    public var scale:Number = 1.0;
    public var data:/*uint*/Array = new Array();
    public var pallet:/*uint*/Array = new Array();
    public var transparent:int = -1;
}

import flash.display.Sprite;
class DotDraw extends Sprite {
    public function DotDraw(recipe:Recipe) {
        for (var index:uint = 0; index < recipe.width * recipe.height; ++index) {
            var x:uint = index % recipe.width;
            var y:uint = uint(index / recipe.width);
            
            var datum:uint = recipe.data[x + (y * recipe.width)];
            var color:uint = recipe.pallet[datum];
            var scale:Number = recipe.scale;
            var alpha:Number = (datum == recipe.transparent) ? 0.0 : 1.0;
            
            this.graphics.beginFill(color, alpha);
            this.graphics.drawRect(x * scale, y * scale, scale, scale);
            this.graphics.endFill();
        }
    }

}