/**
 * Copyright Kihara ( http://wonderfl.net/user/Kihara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3C5Y
 */

package
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;

    [SWF(frameRate="60", width="465", height="465")]
    public class lightTest extends Sprite
    {
        private var sp:Sprite;
        private var startPoint:uint=10;
        private var endPoint:uint=stage.stageWidth;
        private var noises:Vector.<Number>=new Vector.<Number>();
        private var now:Vector.<Number>=new Vector.<Number>();
        private var rate:uint;
        private var NUM:uint=20;
        private var lines:Vector.<Lines>=new Vector.<Lines>();

        public function lightTest()
        {
            stage.scaleMode=StageScaleMode.NO_SCALE;
            stage.align=StageAlign.TOP_LEFT;

            for (var i:uint=0; i < NUM; i++)
            {
                noises.push(1);
                now.push(Math.random() * 100 - 50);
            }

            sp=new Sprite();
            sp.graphics.beginFill(0);
            sp.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            rate=(endPoint - startPoint) / NUM;

            addChild(sp);
            setLine();

            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        private function setLine():void
        {
            for (var i:uint=0; i < 3; i++)
            {
                var _line:Lines=new Lines(NUM, rate, startPoint, endPoint);
                lines.push(_line);
                addChild(lines[i]);
            }
        }

        private function setNoise(haba:Number):void
        {
            for (var i:uint=0; i < noises.length; i++)
            {
                noises[i]=Math.random() * haba - haba / 2;
            }
        }

        public function onEnterFrame(e:Event):void
        {
            for (var i:uint=0; i < lines.length; i++)
            {
                lines[i].move();
            }

        }
    }
}

import flash.display.BlendMode;
import flash.display.Sprite;
import flash.filters.GlowFilter;

class Lines extends Sprite
{

    private var noise:Vector.<Number>=new Vector.<Number>();
    private var now:Vector.<Number>=new Vector.<Number>();
    private var pointNum:uint;
    private var rate:uint;
    private var sPoint:uint, ePoint:uint;

    public function Lines(_pointNum:uint, _rate:uint, _sPoint:uint, _ePoint:uint)
    {
        this.filters=[new GlowFilter(0x009C65, 1, 8, 8)];
        this.blendMode=BlendMode.ADD;
        this.pointNum=_pointNum;
        this.rate=_rate;
        this.sPoint=_sPoint;
        this.ePoint=_ePoint;
        for (var i:uint=0; i < pointNum; i++)
        {
            noise.push(1);
            now.push(Math.random() * 100 - 50);
        }
    }

    private function setNoise(haba:Number):void
    {
        for (var i:uint=0; i < noise.length; i++)
        {
            noise[i]=Math.random() * haba - haba / 2;
        }
    }

    public function move():void
    {
        var myrate:uint=1;
        for (var noiseNum:uint=0; noiseNum < 5; noiseNum++)
        {
            myrate*=3;
            setNoise(200 / myrate);
            for (var t:uint=0; t < pointNum; t++)
            {
                now[t]+=noise[t] / myrate;
            }
        }
        for (var i:uint=0; i < pointNum; i++)
        {
            now[i]=now[i] * 0.8;
        }

        var xPoint:uint=0;
        this.graphics.clear();
        for (var j:uint=0; j < pointNum - 1; j++)
        {
            this.graphics.lineStyle(Math.random() * 3, 0xFFFFFF);
            this.graphics.moveTo(sPoint + xPoint, now[j] + 230);
            this.graphics.lineTo(sPoint + xPoint + rate, now[j + 1] + 230);
            xPoint+=rate;
        }
    }
}









































