/**
 * Copyright folbore ( http://wonderfl.net/user/folbore )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3BpU
 */

// forked from umhr's Bitmap.draw()を使ってみる2
/*
Bitmapにstageの絵柄を書き込む。
直前に描いた画像をちょっとずつ暗くすると、
残像が残ったようにみえる。

*/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    
    import caurina.transitions.Tweener;

    public class Main extends Sprite {
        private var _sp:Sprite;
        private var _bitmap:Bitmap;
        private var _colorTransform:ColorTransform;
        
        public var lac_s : Sprite = new Sprite();
        public var lacx : Number , lacy : Number = 15;

        public function Main() {
            
            _sp = new Sprite();
            _sp.graphics.beginFill(0xFF0000,1);
            _sp.graphics.drawRect(100,0,100,100);
            _sp.graphics.endFill();
            _sp.x=stage.stageWidth/2;
            _sp.y=stage.stageHeight/2;
            //this.addChild(_sp);
            
            var ha : Number; //歯末のたけ
            var hf : Number; //歯元のたけ
            var p : Number; //基準ピッチ
            var a : Number; //圧力角
            var i : int;        
            
            //ラック設定
            ha = 20;
            hf = 20;
            p = 40;
            a = 20; //度
            z = 7; //歯数

            //描画
            lacx = stage.stageWidth/2-p/2*z;
            a=a/180*Math.PI;
            
            lac_s.graphics.beginFill(0xFF00FF)
            lac_s.graphics.lineTo(hf*Math.tan(a)+lacx,0);
            for (i=0 ; i<z ; i++) {
                lac_s.graphics.lineTo(hf*Math.tan(a)+p*i+lacx,lacy);
                lac_s.graphics.lineTo(p/2-hf*Math.tan(a)+p*i+lacx,lacy);
                lac_s.graphics.lineTo(p/2+ha*Math.tan(a)+p*i+lacx,ha+hf+lacy);
                lac_s.graphics.lineTo(p-ha*Math.tan(a)+p*i+lacx,ha+hf+lacy);
            }
            lac_s.graphics.lineTo(p+ha*Math.tan(a)+p*(i-1)+lacx,lacy);
            lac_s.graphics.lineTo(p+ha*Math.tan(a)+p*(i-1)+lacx,0);
            lac_s.graphics.endFill();
            addChild(lac_s);
            
            //bitmapの表示エリアを作っている。
            var bitmapData:BitmapData=new BitmapData(stage.stageWidth,stage.stageHeight);
            _bitmap=new Bitmap(bitmapData);
            this.addChild(_bitmap);
            
            //変色の内容。ちょっとだけ暗くしている。
            _colorTransform = new ColorTransform(1, 1, 1, 1, -0x5, -0x5, -0x5);
            
            this.addEventListener(Event.ENTER_FRAME,onEnter);
        }
        
        private function onEnter(event:Event):void {
            //Spriteを回転
            lac_s.rotation++;
            
            //一度、真っ白に戻している。
            //_bitmap.bitmapData.fillRect(_bitmap.bitmapData.rect,0xFFFFFF);
            //前に描いた画像を変色している。
            //_bitmap.bitmapData.colorTransform(_bitmap.bitmapData.rect,_colorTransform);
            //_bitmap.bitmapData.scroll(1,1);
            //stageの内容を書き込んでいる。
            _bitmap.bitmapData.draw(stage);
        }
        
        //ラックを描く
        public function drawlac() :Sprite {
            var ha : Number; //歯末のたけ
            var hf : Number; //歯元のたけ
            var p : Number; //基準ピッチ
            var a : Number; //圧力角
            var i : int;        
            
            //ラック設定
            ha = 20;
            hf = 20;
            p = 40;
            a = 20; //度
            z = 7; //歯数

            //描画
            lacx = stage.stageWidth/2-p/2*z;
            a=a/180*Math.PI;
            
            lac_s.graphics.beginFill(0xFF00FF)
            lac_s.graphics.lineTo(hf*Math.tan(a)+lacx,0);
            for (i=0 ; i<z ; i++) {
                lac_s.graphics.lineTo(hf*Math.tan(a)+p*i+lacx,lacy);
                lac_s.graphics.lineTo(p/2-hf*Math.tan(a)+p*i+lacx,lacy);
                lac_s.graphics.lineTo(p/2+ha*Math.tan(a)+p*i+lacx,ha+hf+lacy);
                lac_s.graphics.lineTo(p-ha*Math.tan(a)+p*i+lacx,ha+hf+lacy);
            }
            lac_s.graphics.lineTo(p+ha*Math.tan(a)+p*(i-1)+lacx,lacy);
            lac_s.graphics.lineTo(p+ha*Math.tan(a)+p*(i-1)+lacx,0);
            lac_s.graphics.endFill();
            return lac_s;
        }
    }
}